/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupResponse;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountResponse;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleRequest;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleResponse;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountRequest;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsResponse;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionResponse;

/**
 * Service client for accessing AWS Greengrass asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * AWS IoT Greengrass seamlessly extends AWS onto physical devices so they can act locally on the data they generate,
 * while still using the cloud for management, analytics, and durable storage. AWS IoT Greengrass ensures your devices
 * can respond quickly to local events and operate with intermittent connectivity. AWS IoT Greengrass minimizes the cost
 * of transmitting data to the cloud by allowing you to author AWS Lambda functions that execute locally.
 */
@Generated("software.amazon.awssdk:codegen")
public interface GreengrassAsyncClient extends SdkClient {
    String SERVICE_NAME = "greengrass";

    /**
     * Create a {@link GreengrassAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GreengrassAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GreengrassAsyncClient}.
     */
    static GreengrassAsyncClientBuilder builder() {
        return new DefaultGreengrassAsyncClientBuilder();
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
     *
     * @param associateRoleToGroupRequest
     * @return A Java Future containing the result of the AssociateRoleToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateRoleToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateRoleToGroupResponse> associateRoleToGroup(
            AssociateRoleToGroupRequest associateRoleToGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRoleToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateRoleToGroupRequest#builder()}
     * </p>
     *
     * @param associateRoleToGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateRoleToGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateRoleToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateRoleToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateRoleToGroupResponse> associateRoleToGroup(
            Consumer<AssociateRoleToGroupRequest.Builder> associateRoleToGroupRequest) {
        return associateRoleToGroup(AssociateRoleToGroupRequest.builder().applyMutation(associateRoleToGroupRequest).build());
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.
     *
     * @param associateServiceRoleToAccountRequest
     * @return A Java Future containing the result of the AssociateServiceRoleToAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateServiceRoleToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceRoleToAccountResponse> associateServiceRoleToAccount(
            AssociateServiceRoleToAccountRequest associateServiceRoleToAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateServiceRoleToAccountRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateServiceRoleToAccountRequest#builder()}
     * </p>
     *
     * @param associateServiceRoleToAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateServiceRoleToAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateServiceRoleToAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateServiceRoleToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceRoleToAccountResponse> associateServiceRoleToAccount(
            Consumer<AssociateServiceRoleToAccountRequest.Builder> associateServiceRoleToAccountRequest) {
        return associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest.builder()
                .applyMutation(associateServiceRoleToAccountRequest).build());
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.
     *
     * @param createConnectorDefinitionRequest
     * @return A Java Future containing the result of the CreateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorDefinitionResponse> createConnectorDefinition(
            CreateConnectorDefinitionRequest createConnectorDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param createConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorDefinitionResponse> createConnectorDefinition(
            Consumer<CreateConnectorDefinitionRequest.Builder> createConnectorDefinitionRequest) {
        return createConnectorDefinition(CreateConnectorDefinitionRequest.builder()
                .applyMutation(createConnectorDefinitionRequest).build());
    }

    /**
     * Creates a version of a connector definition which has already been defined.
     *
     * @param createConnectorDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorDefinitionVersionResponse> createConnectorDefinitionVersion(
            CreateConnectorDefinitionVersionRequest createConnectorDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a connector definition which has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConnectorDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createConnectorDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorDefinitionVersionResponse> createConnectorDefinitionVersion(
            Consumer<CreateConnectorDefinitionVersionRequest.Builder> createConnectorDefinitionVersionRequest) {
        return createConnectorDefinitionVersion(CreateConnectorDefinitionVersionRequest.builder()
                .applyMutation(createConnectorDefinitionVersionRequest).build());
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
     *
     * @param createCoreDefinitionRequest
     *        Information needed to create a core definition.
     * @return A Java Future containing the result of the CreateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCoreDefinitionResponse> createCoreDefinition(
            CreateCoreDefinitionRequest createCoreDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoreDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param createCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCoreDefinitionRequest.Builder} to create a
     *        request. Information needed to create a core definition.
     * @return A Java Future containing the result of the CreateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCoreDefinitionResponse> createCoreDefinition(
            Consumer<CreateCoreDefinitionRequest.Builder> createCoreDefinitionRequest) {
        return createCoreDefinition(CreateCoreDefinitionRequest.builder().applyMutation(createCoreDefinitionRequest).build());
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.
     *
     * @param createCoreDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCoreDefinitionVersionResponse> createCoreDefinitionVersion(
            CreateCoreDefinitionVersionRequest createCoreDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoreDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCoreDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createCoreDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCoreDefinitionVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCoreDefinitionVersionResponse> createCoreDefinitionVersion(
            Consumer<CreateCoreDefinitionVersionRequest.Builder> createCoreDefinitionVersionRequest) {
        return createCoreDefinitionVersion(CreateCoreDefinitionVersionRequest.builder()
                .applyMutation(createCoreDefinitionVersionRequest).build());
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.
     *
     * @param createDeploymentRequest
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(
            Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.
     *
     * @param createDeviceDefinitionRequest
     * @return A Java Future containing the result of the CreateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceDefinitionResponse> createDeviceDefinition(
            CreateDeviceDefinitionRequest createDeviceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param createDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceDefinitionResponse> createDeviceDefinition(
            Consumer<CreateDeviceDefinitionRequest.Builder> createDeviceDefinitionRequest) {
        return createDeviceDefinition(CreateDeviceDefinitionRequest.builder().applyMutation(createDeviceDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a device definition that has already been defined.
     *
     * @param createDeviceDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateDeviceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceDefinitionVersionResponse> createDeviceDefinitionVersion(
            CreateDeviceDefinitionVersionRequest createDeviceDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a device definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDeviceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createDeviceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDeviceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeviceDefinitionVersionResponse> createDeviceDefinitionVersion(
            Consumer<CreateDeviceDefinitionVersionRequest.Builder> createDeviceDefinitionVersionRequest) {
        return createDeviceDefinitionVersion(CreateDeviceDefinitionVersionRequest.builder()
                .applyMutation(createDeviceDefinitionVersionRequest).build());
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
     *
     * @param createFunctionDefinitionRequest
     * @return A Java Future containing the result of the CreateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFunctionDefinitionResponse> createFunctionDefinition(
            CreateFunctionDefinitionRequest createFunctionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param createFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFunctionDefinitionResponse> createFunctionDefinition(
            Consumer<CreateFunctionDefinitionRequest.Builder> createFunctionDefinitionRequest) {
        return createFunctionDefinition(CreateFunctionDefinitionRequest.builder().applyMutation(createFunctionDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.
     *
     * @param createFunctionDefinitionVersionRequest
     *        Information needed to create a function definition version.
     * @return A Java Future containing the result of the CreateFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFunctionDefinitionVersionResponse> createFunctionDefinitionVersion(
            CreateFunctionDefinitionVersionRequest createFunctionDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFunctionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createFunctionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionDefinitionVersionRequest.Builder} to
     *        create a request. Information needed to create a function definition version.
     * @return A Java Future containing the result of the CreateFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFunctionDefinitionVersionResponse> createFunctionDefinitionVersion(
            Consumer<CreateFunctionDefinitionVersionRequest.Builder> createFunctionDefinitionVersionRequest) {
        return createFunctionDefinitionVersion(CreateFunctionDefinitionVersionRequest.builder()
                .applyMutation(createFunctionDefinitionVersionRequest).build());
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
     *
     * @param createGroupCertificateAuthorityRequest
     * @return A Java Future containing the result of the CreateGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupCertificateAuthorityResponse> createGroupCertificateAuthority(
            CreateGroupCertificateAuthorityRequest createGroupCertificateAuthorityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link CreateGroupCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param createGroupCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupCertificateAuthorityRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupCertificateAuthorityResponse> createGroupCertificateAuthority(
            Consumer<CreateGroupCertificateAuthorityRequest.Builder> createGroupCertificateAuthorityRequest) {
        return createGroupCertificateAuthority(CreateGroupCertificateAuthorityRequest.builder()
                .applyMutation(createGroupCertificateAuthorityRequest).build());
    }

    /**
     * Creates a version of a group which has already been defined.
     *
     * @param createGroupVersionRequest
     * @return A Java Future containing the result of the CreateGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupVersionResponse> createGroupVersion(CreateGroupVersionRequest createGroupVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a group which has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupVersionRequest#builder()}
     * </p>
     *
     * @param createGroupVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupVersionResponse> createGroupVersion(
            Consumer<CreateGroupVersionRequest.Builder> createGroupVersionRequest) {
        return createGroupVersion(CreateGroupVersionRequest.builder().applyMutation(createGroupVersionRequest).build());
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.
     *
     * @param createLoggerDefinitionRequest
     * @return A Java Future containing the result of the CreateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoggerDefinitionResponse> createLoggerDefinition(
            CreateLoggerDefinitionRequest createLoggerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param createLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoggerDefinitionResponse> createLoggerDefinition(
            Consumer<CreateLoggerDefinitionRequest.Builder> createLoggerDefinitionRequest) {
        return createLoggerDefinition(CreateLoggerDefinitionRequest.builder().applyMutation(createLoggerDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a logger definition that has already been defined.
     *
     * @param createLoggerDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateLoggerDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoggerDefinitionVersionResponse> createLoggerDefinitionVersion(
            CreateLoggerDefinitionVersionRequest createLoggerDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a logger definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoggerDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLoggerDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createLoggerDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoggerDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLoggerDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLoggerDefinitionVersionResponse> createLoggerDefinitionVersion(
            Consumer<CreateLoggerDefinitionVersionRequest.Builder> createLoggerDefinitionVersionRequest) {
        return createLoggerDefinitionVersion(CreateLoggerDefinitionVersionRequest.builder()
                .applyMutation(createLoggerDefinitionVersionRequest).build());
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
     *
     * @param createResourceDefinitionRequest
     * @return A Java Future containing the result of the CreateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceDefinitionResponse> createResourceDefinition(
            CreateResourceDefinitionRequest createResourceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param createResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceDefinitionResponse> createResourceDefinition(
            Consumer<CreateResourceDefinitionRequest.Builder> createResourceDefinitionRequest) {
        return createResourceDefinition(CreateResourceDefinitionRequest.builder().applyMutation(createResourceDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a resource definition that has already been defined.
     *
     * @param createResourceDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceDefinitionVersionResponse> createResourceDefinitionVersion(
            CreateResourceDefinitionVersionRequest createResourceDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a resource definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createResourceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceDefinitionVersionResponse> createResourceDefinitionVersion(
            Consumer<CreateResourceDefinitionVersionRequest.Builder> createResourceDefinitionVersionRequest) {
        return createResourceDefinitionVersion(CreateResourceDefinitionVersionRequest.builder()
                .applyMutation(createResourceDefinitionVersionRequest).build());
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.
     *
     * @param createSoftwareUpdateJobRequest
     * @return A Java Future containing the result of the CreateSoftwareUpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSoftwareUpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSoftwareUpdateJobResponse> createSoftwareUpdateJob(
            CreateSoftwareUpdateJobRequest createSoftwareUpdateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSoftwareUpdateJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSoftwareUpdateJobRequest#builder()}
     * </p>
     *
     * @param createSoftwareUpdateJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateSoftwareUpdateJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSoftwareUpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSoftwareUpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSoftwareUpdateJobResponse> createSoftwareUpdateJob(
            Consumer<CreateSoftwareUpdateJobRequest.Builder> createSoftwareUpdateJobRequest) {
        return createSoftwareUpdateJob(CreateSoftwareUpdateJobRequest.builder().applyMutation(createSoftwareUpdateJobRequest)
                .build());
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.
     *
     * @param createSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the CreateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionDefinitionResponse> createSubscriptionDefinition(
            CreateSubscriptionDefinitionRequest createSubscriptionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionDefinitionResponse> createSubscriptionDefinition(
            Consumer<CreateSubscriptionDefinitionRequest.Builder> createSubscriptionDefinitionRequest) {
        return createSubscriptionDefinition(CreateSubscriptionDefinitionRequest.builder()
                .applyMutation(createSubscriptionDefinitionRequest).build());
    }

    /**
     * Creates a version of a subscription definition which has already been defined.
     *
     * @param createSubscriptionDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionDefinitionVersionResponse> createSubscriptionDefinitionVersion(
            CreateSubscriptionDefinitionVersionRequest createSubscriptionDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a subscription definition which has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSubscriptionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionDefinitionVersionResponse> createSubscriptionDefinitionVersion(
            Consumer<CreateSubscriptionDefinitionVersionRequest.Builder> createSubscriptionDefinitionVersionRequest) {
        return createSubscriptionDefinitionVersion(CreateSubscriptionDefinitionVersionRequest.builder()
                .applyMutation(createSubscriptionDefinitionVersionRequest).build());
    }

    /**
     * Deletes a connector definition.
     *
     * @param deleteConnectorDefinitionRequest
     * @return A Java Future containing the result of the DeleteConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorDefinitionResponse> deleteConnectorDefinition(
            DeleteConnectorDefinitionRequest deleteConnectorDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a connector definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorDefinitionResponse> deleteConnectorDefinition(
            Consumer<DeleteConnectorDefinitionRequest.Builder> deleteConnectorDefinitionRequest) {
        return deleteConnectorDefinition(DeleteConnectorDefinitionRequest.builder()
                .applyMutation(deleteConnectorDefinitionRequest).build());
    }

    /**
     * Deletes a core definition.
     *
     * @param deleteCoreDefinitionRequest
     * @return A Java Future containing the result of the DeleteCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCoreDefinitionResponse> deleteCoreDefinition(
            DeleteCoreDefinitionRequest deleteCoreDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a core definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCoreDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCoreDefinitionResponse> deleteCoreDefinition(
            Consumer<DeleteCoreDefinitionRequest.Builder> deleteCoreDefinitionRequest) {
        return deleteCoreDefinition(DeleteCoreDefinitionRequest.builder().applyMutation(deleteCoreDefinitionRequest).build());
    }

    /**
     * Deletes a device definition.
     *
     * @param deleteDeviceDefinitionRequest
     * @return A Java Future containing the result of the DeleteDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceDefinitionResponse> deleteDeviceDefinition(
            DeleteDeviceDefinitionRequest deleteDeviceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceDefinitionResponse> deleteDeviceDefinition(
            Consumer<DeleteDeviceDefinitionRequest.Builder> deleteDeviceDefinitionRequest) {
        return deleteDeviceDefinition(DeleteDeviceDefinitionRequest.builder().applyMutation(deleteDeviceDefinitionRequest)
                .build());
    }

    /**
     * Deletes a Lambda function definition.
     *
     * @param deleteFunctionDefinitionRequest
     * @return A Java Future containing the result of the DeleteFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionDefinitionResponse> deleteFunctionDefinition(
            DeleteFunctionDefinitionRequest deleteFunctionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a Lambda function definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionDefinitionResponse> deleteFunctionDefinition(
            Consumer<DeleteFunctionDefinitionRequest.Builder> deleteFunctionDefinitionRequest) {
        return deleteFunctionDefinition(DeleteFunctionDefinitionRequest.builder().applyMutation(deleteFunctionDefinitionRequest)
                .build());
    }

    /**
     * Deletes a group.
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * Deletes a logger definition.
     *
     * @param deleteLoggerDefinitionRequest
     * @return A Java Future containing the result of the DeleteLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggerDefinitionResponse> deleteLoggerDefinition(
            DeleteLoggerDefinitionRequest deleteLoggerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggerDefinitionResponse> deleteLoggerDefinition(
            Consumer<DeleteLoggerDefinitionRequest.Builder> deleteLoggerDefinitionRequest) {
        return deleteLoggerDefinition(DeleteLoggerDefinitionRequest.builder().applyMutation(deleteLoggerDefinitionRequest)
                .build());
    }

    /**
     * Deletes a resource definition.
     *
     * @param deleteResourceDefinitionRequest
     * @return A Java Future containing the result of the DeleteResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceDefinitionResponse> deleteResourceDefinition(
            DeleteResourceDefinitionRequest deleteResourceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a resource definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceDefinitionResponse> deleteResourceDefinition(
            Consumer<DeleteResourceDefinitionRequest.Builder> deleteResourceDefinitionRequest) {
        return deleteResourceDefinition(DeleteResourceDefinitionRequest.builder().applyMutation(deleteResourceDefinitionRequest)
                .build());
    }

    /**
     * Deletes a subscription definition.
     *
     * @param deleteSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the DeleteSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionDefinitionResponse> deleteSubscriptionDefinition(
            DeleteSubscriptionDefinitionRequest deleteSubscriptionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubscriptionDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSubscriptionDefinitionResponse> deleteSubscriptionDefinition(
            Consumer<DeleteSubscriptionDefinitionRequest.Builder> deleteSubscriptionDefinitionRequest) {
        return deleteSubscriptionDefinition(DeleteSubscriptionDefinitionRequest.builder()
                .applyMutation(deleteSubscriptionDefinitionRequest).build());
    }

    /**
     * Disassociates the role from a group.
     *
     * @param disassociateRoleFromGroupRequest
     * @return A Java Future containing the result of the DisassociateRoleFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateRoleFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRoleFromGroupResponse> disassociateRoleFromGroup(
            DisassociateRoleFromGroupRequest disassociateRoleFromGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Disassociates the role from a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRoleFromGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateRoleFromGroupRequest#builder()}
     * </p>
     *
     * @param disassociateRoleFromGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateRoleFromGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateRoleFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateRoleFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRoleFromGroupResponse> disassociateRoleFromGroup(
            Consumer<DisassociateRoleFromGroupRequest.Builder> disassociateRoleFromGroupRequest) {
        return disassociateRoleFromGroup(DisassociateRoleFromGroupRequest.builder()
                .applyMutation(disassociateRoleFromGroupRequest).build());
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @param disassociateServiceRoleFromAccountRequest
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount(
            DisassociateServiceRoleFromAccountRequest disassociateServiceRoleFromAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateServiceRoleFromAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateServiceRoleFromAccountRequest#builder()}
     * </p>
     *
     * @param disassociateServiceRoleFromAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateServiceRoleFromAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount(
            Consumer<DisassociateServiceRoleFromAccountRequest.Builder> disassociateServiceRoleFromAccountRequest) {
        return disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.builder()
                .applyMutation(disassociateServiceRoleFromAccountRequest).build());
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount() {
        return disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.builder().build());
    }

    /**
     * Retrieves the role associated with a particular group.
     *
     * @param getAssociatedRoleRequest
     * @return A Java Future containing the result of the GetAssociatedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetAssociatedRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssociatedRoleResponse> getAssociatedRole(GetAssociatedRoleRequest getAssociatedRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the role associated with a particular group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssociatedRoleRequest.Builder} avoiding the need
     * to create one manually via {@link GetAssociatedRoleRequest#builder()}
     * </p>
     *
     * @param getAssociatedRoleRequest
     *        A {@link Consumer} that will call methods on {@link GetAssociatedRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAssociatedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetAssociatedRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssociatedRoleResponse> getAssociatedRole(
            Consumer<GetAssociatedRoleRequest.Builder> getAssociatedRoleRequest) {
        return getAssociatedRole(GetAssociatedRoleRequest.builder().applyMutation(getAssociatedRoleRequest).build());
    }

    /**
     * Returns the status of a bulk deployment.
     *
     * @param getBulkDeploymentStatusRequest
     * @return A Java Future containing the result of the GetBulkDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetBulkDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBulkDeploymentStatusResponse> getBulkDeploymentStatus(
            GetBulkDeploymentStatusRequest getBulkDeploymentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the status of a bulk deployment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBulkDeploymentStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetBulkDeploymentStatusRequest#builder()}
     * </p>
     *
     * @param getBulkDeploymentStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetBulkDeploymentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBulkDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetBulkDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBulkDeploymentStatusResponse> getBulkDeploymentStatus(
            Consumer<GetBulkDeploymentStatusRequest.Builder> getBulkDeploymentStatusRequest) {
        return getBulkDeploymentStatus(GetBulkDeploymentStatusRequest.builder().applyMutation(getBulkDeploymentStatusRequest)
                .build());
    }

    /**
     * Retrieves the connectivity information for a core.
     *
     * @param getConnectivityInfoRequest
     * @return A Java Future containing the result of the GetConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConnectivityInfoResponse> getConnectivityInfo(
            GetConnectivityInfoRequest getConnectivityInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the connectivity information for a core.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectivityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectivityInfoRequest#builder()}
     * </p>
     *
     * @param getConnectivityInfoRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectivityInfoRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetConnectivityInfoResponse> getConnectivityInfo(
            Consumer<GetConnectivityInfoRequest.Builder> getConnectivityInfoRequest) {
        return getConnectivityInfo(GetConnectivityInfoRequest.builder().applyMutation(getConnectivityInfoRequest).build());
    }

    /**
     * Retrieves information about a connector definition.
     *
     * @param getConnectorDefinitionRequest
     * @return A Java Future containing the result of the GetConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorDefinitionResponse> getConnectorDefinition(
            GetConnectorDefinitionRequest getConnectorDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a connector definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param getConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorDefinitionResponse> getConnectorDefinition(
            Consumer<GetConnectorDefinitionRequest.Builder> getConnectorDefinitionRequest) {
        return getConnectorDefinition(GetConnectorDefinitionRequest.builder().applyMutation(getConnectorDefinitionRequest)
                .build());
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.
     *
     * @param getConnectorDefinitionVersionRequest
     * @return A Java Future containing the result of the GetConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorDefinitionVersionResponse> getConnectorDefinitionVersion(
            GetConnectorDefinitionVersionRequest getConnectorDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetConnectorDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getConnectorDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectorDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorDefinitionVersionResponse> getConnectorDefinitionVersion(
            Consumer<GetConnectorDefinitionVersionRequest.Builder> getConnectorDefinitionVersionRequest) {
        return getConnectorDefinitionVersion(GetConnectorDefinitionVersionRequest.builder()
                .applyMutation(getConnectorDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionRequest
     * @return A Java Future containing the result of the GetCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCoreDefinitionResponse> getCoreDefinition(GetCoreDefinitionRequest getCoreDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a core definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreDefinitionRequest.Builder} avoiding the need
     * to create one manually via {@link GetCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param getCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreDefinitionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCoreDefinitionResponse> getCoreDefinition(
            Consumer<GetCoreDefinitionRequest.Builder> getCoreDefinitionRequest) {
        return getCoreDefinition(GetCoreDefinitionRequest.builder().applyMutation(getCoreDefinitionRequest).build());
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionVersionRequest
     * @return A Java Future containing the result of the GetCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreDefinitionVersionResponse> getCoreDefinitionVersion(
            GetCoreDefinitionVersionRequest getCoreDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a core definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreDefinitionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getCoreDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreDefinitionVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCoreDefinitionVersionResponse> getCoreDefinitionVersion(
            Consumer<GetCoreDefinitionVersionRequest.Builder> getCoreDefinitionVersionRequest) {
        return getCoreDefinitionVersion(GetCoreDefinitionVersionRequest.builder().applyMutation(getCoreDefinitionVersionRequest)
                .build());
    }

    /**
     * Returns the status of a deployment.
     *
     * @param getDeploymentStatusRequest
     * @return A Java Future containing the result of the GetDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentStatusResponse> getDeploymentStatus(
            GetDeploymentStatusRequest getDeploymentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the status of a deployment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentStatusRequest#builder()}
     * </p>
     *
     * @param getDeploymentStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentStatusResponse> getDeploymentStatus(
            Consumer<GetDeploymentStatusRequest.Builder> getDeploymentStatusRequest) {
        return getDeploymentStatus(GetDeploymentStatusRequest.builder().applyMutation(getDeploymentStatusRequest).build());
    }

    /**
     * Retrieves information about a device definition.
     *
     * @param getDeviceDefinitionRequest
     * @return A Java Future containing the result of the GetDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceDefinitionResponse> getDeviceDefinition(
            GetDeviceDefinitionRequest getDeviceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param getDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceDefinitionResponse> getDeviceDefinition(
            Consumer<GetDeviceDefinitionRequest.Builder> getDeviceDefinitionRequest) {
        return getDeviceDefinition(GetDeviceDefinitionRequest.builder().applyMutation(getDeviceDefinitionRequest).build());
    }

    /**
     * Retrieves information about a device definition version.
     *
     * @param getDeviceDefinitionVersionRequest
     * @return A Java Future containing the result of the GetDeviceDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeviceDefinitionVersionResponse> getDeviceDefinitionVersion(
            GetDeviceDefinitionVersionRequest getDeviceDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a device definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceDefinitionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetDeviceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getDeviceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceDefinitionVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeviceDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeviceDefinitionVersionResponse> getDeviceDefinitionVersion(
            Consumer<GetDeviceDefinitionVersionRequest.Builder> getDeviceDefinitionVersionRequest) {
        return getDeviceDefinitionVersion(GetDeviceDefinitionVersionRequest.builder()
                .applyMutation(getDeviceDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.
     *
     * @param getFunctionDefinitionRequest
     * @return A Java Future containing the result of the GetFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionDefinitionResponse> getFunctionDefinition(
            GetFunctionDefinitionRequest getFunctionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param getFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionDefinitionResponse> getFunctionDefinition(
            Consumer<GetFunctionDefinitionRequest.Builder> getFunctionDefinitionRequest) {
        return getFunctionDefinition(GetFunctionDefinitionRequest.builder().applyMutation(getFunctionDefinitionRequest).build());
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.
     *
     * @param getFunctionDefinitionVersionRequest
     * @return A Java Future containing the result of the GetFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionDefinitionVersionResponse> getFunctionDefinitionVersion(
            GetFunctionDefinitionVersionRequest getFunctionDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetFunctionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getFunctionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionDefinitionVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionDefinitionVersionResponse> getFunctionDefinitionVersion(
            Consumer<GetFunctionDefinitionVersionRequest.Builder> getFunctionDefinitionVersionRequest) {
        return getFunctionDefinitionVersion(GetFunctionDefinitionVersionRequest.builder()
                .applyMutation(getFunctionDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a group.
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.
     *
     * @param getGroupCertificateAuthorityRequest
     * @return A Java Future containing the result of the GetGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGroupCertificateAuthorityResponse> getGroupCertificateAuthority(
            GetGroupCertificateAuthorityRequest getGroupCertificateAuthorityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link GetGroupCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param getGroupCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupCertificateAuthorityRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGroupCertificateAuthorityResponse> getGroupCertificateAuthority(
            Consumer<GetGroupCertificateAuthorityRequest.Builder> getGroupCertificateAuthorityRequest) {
        return getGroupCertificateAuthority(GetGroupCertificateAuthorityRequest.builder()
                .applyMutation(getGroupCertificateAuthorityRequest).build());
    }

    /**
     * Retrieves the current configuration for the CA used by the group.
     *
     * @param getGroupCertificateConfigurationRequest
     * @return A Java Future containing the result of the GetGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGroupCertificateConfigurationResponse> getGroupCertificateConfiguration(
            GetGroupCertificateConfigurationRequest getGroupCertificateConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the current configuration for the CA used by the group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupCertificateConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetGroupCertificateConfigurationRequest#builder()}
     * </p>
     *
     * @param getGroupCertificateConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupCertificateConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGroupCertificateConfigurationResponse> getGroupCertificateConfiguration(
            Consumer<GetGroupCertificateConfigurationRequest.Builder> getGroupCertificateConfigurationRequest) {
        return getGroupCertificateConfiguration(GetGroupCertificateConfigurationRequest.builder()
                .applyMutation(getGroupCertificateConfigurationRequest).build());
    }

    /**
     * Retrieves information about a group version.
     *
     * @param getGroupVersionRequest
     * @return A Java Future containing the result of the GetGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupVersionResponse> getGroupVersion(GetGroupVersionRequest getGroupVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a group version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetGroupVersionRequest#builder()}
     * </p>
     *
     * @param getGroupVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupVersionResponse> getGroupVersion(
            Consumer<GetGroupVersionRequest.Builder> getGroupVersionRequest) {
        return getGroupVersion(GetGroupVersionRequest.builder().applyMutation(getGroupVersionRequest).build());
    }

    /**
     * Retrieves information about a logger definition.
     *
     * @param getLoggerDefinitionRequest
     * @return A Java Future containing the result of the GetLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLoggerDefinitionResponse> getLoggerDefinition(
            GetLoggerDefinitionRequest getLoggerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param getLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLoggerDefinitionResponse> getLoggerDefinition(
            Consumer<GetLoggerDefinitionRequest.Builder> getLoggerDefinitionRequest) {
        return getLoggerDefinition(GetLoggerDefinitionRequest.builder().applyMutation(getLoggerDefinitionRequest).build());
    }

    /**
     * Retrieves information about a logger definition version.
     *
     * @param getLoggerDefinitionVersionRequest
     * @return A Java Future containing the result of the GetLoggerDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoggerDefinitionVersionResponse> getLoggerDefinitionVersion(
            GetLoggerDefinitionVersionRequest getLoggerDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a logger definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggerDefinitionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoggerDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getLoggerDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggerDefinitionVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoggerDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLoggerDefinitionVersionResponse> getLoggerDefinitionVersion(
            Consumer<GetLoggerDefinitionVersionRequest.Builder> getLoggerDefinitionVersionRequest) {
        return getLoggerDefinitionVersion(GetLoggerDefinitionVersionRequest.builder()
                .applyMutation(getLoggerDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.
     *
     * @param getResourceDefinitionRequest
     * @return A Java Future containing the result of the GetResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceDefinitionResponse> getResourceDefinition(
            GetResourceDefinitionRequest getResourceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param getResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceDefinitionResponse> getResourceDefinition(
            Consumer<GetResourceDefinitionRequest.Builder> getResourceDefinitionRequest) {
        return getResourceDefinition(GetResourceDefinitionRequest.builder().applyMutation(getResourceDefinitionRequest).build());
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.
     *
     * @param getResourceDefinitionVersionRequest
     * @return A Java Future containing the result of the GetResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceDefinitionVersionResponse> getResourceDefinitionVersion(
            GetResourceDefinitionVersionRequest getResourceDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getResourceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceDefinitionVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceDefinitionVersionResponse> getResourceDefinitionVersion(
            Consumer<GetResourceDefinitionVersionRequest.Builder> getResourceDefinitionVersionRequest) {
        return getResourceDefinitionVersion(GetResourceDefinitionVersionRequest.builder()
                .applyMutation(getResourceDefinitionVersionRequest).build());
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @param getServiceRoleForAccountRequest
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetServiceRoleForAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount(
            GetServiceRoleForAccountRequest getServiceRoleForAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the service role that is attached to your account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRoleForAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetServiceRoleForAccountRequest#builder()}
     * </p>
     *
     * @param getServiceRoleForAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceRoleForAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetServiceRoleForAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount(
            Consumer<GetServiceRoleForAccountRequest.Builder> getServiceRoleForAccountRequest) {
        return getServiceRoleForAccount(GetServiceRoleForAccountRequest.builder().applyMutation(getServiceRoleForAccountRequest)
                .build());
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetServiceRoleForAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount() {
        return getServiceRoleForAccount(GetServiceRoleForAccountRequest.builder().build());
    }

    /**
     * Retrieves information about a subscription definition.
     *
     * @param getSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the GetSubscriptionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionDefinitionResponse> getSubscriptionDefinition(
            GetSubscriptionDefinitionRequest getSubscriptionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link GetSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionDefinitionResponse> getSubscriptionDefinition(
            Consumer<GetSubscriptionDefinitionRequest.Builder> getSubscriptionDefinitionRequest) {
        return getSubscriptionDefinition(GetSubscriptionDefinitionRequest.builder()
                .applyMutation(getSubscriptionDefinitionRequest).build());
    }

    /**
     * Retrieves information about a subscription definition version.
     *
     * @param getSubscriptionDefinitionVersionRequest
     * @return A Java Future containing the result of the GetSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionDefinitionVersionResponse> getSubscriptionDefinitionVersion(
            GetSubscriptionDefinitionVersionRequest getSubscriptionDefinitionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a subscription definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetSubscriptionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionDefinitionVersionResponse> getSubscriptionDefinitionVersion(
            Consumer<GetSubscriptionDefinitionVersionRequest.Builder> getSubscriptionDefinitionVersionRequest) {
        return getSubscriptionDefinitionVersion(GetSubscriptionDefinitionVersionRequest.builder()
                .applyMutation(getSubscriptionDefinitionVersionRequest).build());
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.
     *
     * @param listBulkDeploymentDetailedReportsRequest
     * @return A Java Future containing the result of the ListBulkDeploymentDetailedReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeploymentDetailedReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBulkDeploymentDetailedReportsResponse> listBulkDeploymentDetailedReports(
            ListBulkDeploymentDetailedReportsRequest listBulkDeploymentDetailedReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkDeploymentDetailedReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBulkDeploymentDetailedReportsRequest#builder()}
     * </p>
     *
     * @param listBulkDeploymentDetailedReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListBulkDeploymentDetailedReportsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListBulkDeploymentDetailedReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeploymentDetailedReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBulkDeploymentDetailedReportsResponse> listBulkDeploymentDetailedReports(
            Consumer<ListBulkDeploymentDetailedReportsRequest.Builder> listBulkDeploymentDetailedReportsRequest) {
        return listBulkDeploymentDetailedReports(ListBulkDeploymentDetailedReportsRequest.builder()
                .applyMutation(listBulkDeploymentDetailedReportsRequest).build());
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @param listBulkDeploymentsRequest
     * @return A Java Future containing the result of the ListBulkDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBulkDeploymentsResponse> listBulkDeployments(
            ListBulkDeploymentsRequest listBulkDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of bulk deployments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBulkDeploymentsRequest#builder()}
     * </p>
     *
     * @param listBulkDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBulkDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBulkDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBulkDeploymentsResponse> listBulkDeployments(
            Consumer<ListBulkDeploymentsRequest.Builder> listBulkDeploymentsRequest) {
        return listBulkDeployments(ListBulkDeploymentsRequest.builder().applyMutation(listBulkDeploymentsRequest).build());
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @return A Java Future containing the result of the ListBulkDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBulkDeploymentsResponse> listBulkDeployments() {
        return listBulkDeployments(ListBulkDeploymentsRequest.builder().build());
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.
     *
     * @param listConnectorDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListConnectorDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDefinitionVersionsResponse> listConnectorDefinitionVersions(
            ListConnectorDefinitionVersionsRequest listConnectorDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConnectorDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listConnectorDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListConnectorDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDefinitionVersionsResponse> listConnectorDefinitionVersions(
            Consumer<ListConnectorDefinitionVersionsRequest.Builder> listConnectorDefinitionVersionsRequest) {
        return listConnectorDefinitionVersions(ListConnectorDefinitionVersionsRequest.builder()
                .applyMutation(listConnectorDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @param listConnectorDefinitionsRequest
     * @return A Java Future containing the result of the ListConnectorDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDefinitionsResponse> listConnectorDefinitions(
            ListConnectorDefinitionsRequest listConnectorDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of connector definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConnectorDefinitionsRequest#builder()}
     * </p>
     *
     * @param listConnectorDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConnectorDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDefinitionsResponse> listConnectorDefinitions(
            Consumer<ListConnectorDefinitionsRequest.Builder> listConnectorDefinitionsRequest) {
        return listConnectorDefinitions(ListConnectorDefinitionsRequest.builder().applyMutation(listConnectorDefinitionsRequest)
                .build());
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @return A Java Future containing the result of the ListConnectorDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDefinitionsResponse> listConnectorDefinitions() {
        return listConnectorDefinitions(ListConnectorDefinitionsRequest.builder().build());
    }

    /**
     * Lists the versions of a core definition.
     *
     * @param listCoreDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListCoreDefinitionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoreDefinitionVersionsResponse> listCoreDefinitionVersions(
            ListCoreDefinitionVersionsRequest listCoreDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a core definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreDefinitionVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCoreDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listCoreDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreDefinitionVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCoreDefinitionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCoreDefinitionVersionsResponse> listCoreDefinitionVersions(
            Consumer<ListCoreDefinitionVersionsRequest.Builder> listCoreDefinitionVersionsRequest) {
        return listCoreDefinitionVersions(ListCoreDefinitionVersionsRequest.builder()
                .applyMutation(listCoreDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @param listCoreDefinitionsRequest
     * @return A Java Future containing the result of the ListCoreDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCoreDefinitionsResponse> listCoreDefinitions(
            ListCoreDefinitionsRequest listCoreDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of core definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoreDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCoreDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCoreDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCoreDefinitionsResponse> listCoreDefinitions(
            Consumer<ListCoreDefinitionsRequest.Builder> listCoreDefinitionsRequest) {
        return listCoreDefinitions(ListCoreDefinitionsRequest.builder().applyMutation(listCoreDefinitionsRequest).build());
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @return A Java Future containing the result of the ListCoreDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCoreDefinitionsResponse> listCoreDefinitions() {
        return listCoreDefinitions(ListCoreDefinitionsRequest.builder().build());
    }

    /**
     * Returns a history of deployments for the group.
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a history of deployments for the group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(
            Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * Lists the versions of a device definition.
     *
     * @param listDeviceDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListDeviceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDefinitionVersionsResponse> listDeviceDefinitionVersions(
            ListDeviceDefinitionVersionsRequest listDeviceDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeviceDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listDeviceDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceDefinitionVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListDeviceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDefinitionVersionsResponse> listDeviceDefinitionVersions(
            Consumer<ListDeviceDefinitionVersionsRequest.Builder> listDeviceDefinitionVersionsRequest) {
        return listDeviceDefinitionVersions(ListDeviceDefinitionVersionsRequest.builder()
                .applyMutation(listDeviceDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @param listDeviceDefinitionsRequest
     * @return A Java Future containing the result of the ListDeviceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDefinitionsResponse> listDeviceDefinitions(
            ListDeviceDefinitionsRequest listDeviceDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of device definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceDefinitionsRequest#builder()}
     * </p>
     *
     * @param listDeviceDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeviceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDefinitionsResponse> listDeviceDefinitions(
            Consumer<ListDeviceDefinitionsRequest.Builder> listDeviceDefinitionsRequest) {
        return listDeviceDefinitions(ListDeviceDefinitionsRequest.builder().applyMutation(listDeviceDefinitionsRequest).build());
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @return A Java Future containing the result of the ListDeviceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDefinitionsResponse> listDeviceDefinitions() {
        return listDeviceDefinitions(ListDeviceDefinitionsRequest.builder().build());
    }

    /**
     * Lists the versions of a Lambda function definition.
     *
     * @param listFunctionDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListFunctionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionDefinitionVersionsResponse> listFunctionDefinitionVersions(
            ListFunctionDefinitionVersionsRequest listFunctionDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a Lambda function definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listFunctionDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFunctionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionDefinitionVersionsResponse> listFunctionDefinitionVersions(
            Consumer<ListFunctionDefinitionVersionsRequest.Builder> listFunctionDefinitionVersionsRequest) {
        return listFunctionDefinitionVersions(ListFunctionDefinitionVersionsRequest.builder()
                .applyMutation(listFunctionDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @param listFunctionDefinitionsRequest
     * @return A Java Future containing the result of the ListFunctionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionDefinitionsResponse> listFunctionDefinitions(
            ListFunctionDefinitionsRequest listFunctionDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of Lambda function definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFunctionDefinitionsRequest#builder()}
     * </p>
     *
     * @param listFunctionDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFunctionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionDefinitionsResponse> listFunctionDefinitions(
            Consumer<ListFunctionDefinitionsRequest.Builder> listFunctionDefinitionsRequest) {
        return listFunctionDefinitions(ListFunctionDefinitionsRequest.builder().applyMutation(listFunctionDefinitionsRequest)
                .build());
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @return A Java Future containing the result of the ListFunctionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionDefinitionsResponse> listFunctionDefinitions() {
        return listFunctionDefinitions(ListFunctionDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves the current CAs for a group.
     *
     * @param listGroupCertificateAuthoritiesRequest
     * @return A Java Future containing the result of the ListGroupCertificateAuthorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupCertificateAuthoritiesResponse> listGroupCertificateAuthorities(
            ListGroupCertificateAuthoritiesRequest listGroupCertificateAuthoritiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the current CAs for a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupCertificateAuthoritiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listGroupCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupCertificateAuthoritiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGroupCertificateAuthorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupCertificateAuthoritiesResponse> listGroupCertificateAuthorities(
            Consumer<ListGroupCertificateAuthoritiesRequest.Builder> listGroupCertificateAuthoritiesRequest) {
        return listGroupCertificateAuthorities(ListGroupCertificateAuthoritiesRequest.builder()
                .applyMutation(listGroupCertificateAuthoritiesRequest).build());
    }

    /**
     * Lists the versions of a group.
     *
     * @param listGroupVersionsRequest
     * @return A Java Future containing the result of the ListGroupVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGroupVersionsResponse> listGroupVersions(ListGroupVersionsRequest listGroupVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupVersionsRequest#builder()}
     * </p>
     *
     * @param listGroupVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroupVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGroupVersionsResponse> listGroupVersions(
            Consumer<ListGroupVersionsRequest.Builder> listGroupVersionsRequest) {
        return listGroupVersions(ListGroupVersionsRequest.builder().applyMutation(listGroupVersionsRequest).build());
    }

    /**
     * Retrieves a list of groups.
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * Retrieves a list of groups.
     *
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups() {
        return listGroups(ListGroupsRequest.builder().build());
    }

    /**
     * Lists the versions of a logger definition.
     *
     * @param listLoggerDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListLoggerDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggerDefinitionVersionsResponse> listLoggerDefinitionVersions(
            ListLoggerDefinitionVersionsRequest listLoggerDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggerDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLoggerDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listLoggerDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggerDefinitionVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListLoggerDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggerDefinitionVersionsResponse> listLoggerDefinitionVersions(
            Consumer<ListLoggerDefinitionVersionsRequest.Builder> listLoggerDefinitionVersionsRequest) {
        return listLoggerDefinitionVersions(ListLoggerDefinitionVersionsRequest.builder()
                .applyMutation(listLoggerDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @param listLoggerDefinitionsRequest
     * @return A Java Future containing the result of the ListLoggerDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggerDefinitionsResponse> listLoggerDefinitions(
            ListLoggerDefinitionsRequest listLoggerDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of logger definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggerDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLoggerDefinitionsRequest#builder()}
     * </p>
     *
     * @param listLoggerDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggerDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLoggerDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggerDefinitionsResponse> listLoggerDefinitions(
            Consumer<ListLoggerDefinitionsRequest.Builder> listLoggerDefinitionsRequest) {
        return listLoggerDefinitions(ListLoggerDefinitionsRequest.builder().applyMutation(listLoggerDefinitionsRequest).build());
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @return A Java Future containing the result of the ListLoggerDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggerDefinitionsResponse> listLoggerDefinitions() {
        return listLoggerDefinitions(ListLoggerDefinitionsRequest.builder().build());
    }

    /**
     * Lists the versions of a resource definition.
     *
     * @param listResourceDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListResourceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDefinitionVersionsResponse> listResourceDefinitionVersions(
            ListResourceDefinitionVersionsRequest listResourceDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a resource definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listResourceDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListResourceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDefinitionVersionsResponse> listResourceDefinitionVersions(
            Consumer<ListResourceDefinitionVersionsRequest.Builder> listResourceDefinitionVersionsRequest) {
        return listResourceDefinitionVersions(ListResourceDefinitionVersionsRequest.builder()
                .applyMutation(listResourceDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @param listResourceDefinitionsRequest
     * @return A Java Future containing the result of the ListResourceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDefinitionsResponse> listResourceDefinitions(
            ListResourceDefinitionsRequest listResourceDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of resource definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceDefinitionsRequest#builder()}
     * </p>
     *
     * @param listResourceDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDefinitionsResponse> listResourceDefinitions(
            Consumer<ListResourceDefinitionsRequest.Builder> listResourceDefinitionsRequest) {
        return listResourceDefinitions(ListResourceDefinitionsRequest.builder().applyMutation(listResourceDefinitionsRequest)
                .build());
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @return A Java Future containing the result of the ListResourceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDefinitionsResponse> listResourceDefinitions() {
        return listResourceDefinitions(ListResourceDefinitionsRequest.builder().build());
    }

    /**
     * Lists the versions of a subscription definition.
     *
     * @param listSubscriptionDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListSubscriptionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionDefinitionVersionsResponse> listSubscriptionDefinitionVersions(
            ListSubscriptionDefinitionVersionsRequest listSubscriptionDefinitionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSubscriptionDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscriptionDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSubscriptionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionDefinitionVersionsResponse> listSubscriptionDefinitionVersions(
            Consumer<ListSubscriptionDefinitionVersionsRequest.Builder> listSubscriptionDefinitionVersionsRequest) {
        return listSubscriptionDefinitionVersions(ListSubscriptionDefinitionVersionsRequest.builder()
                .applyMutation(listSubscriptionDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @param listSubscriptionDefinitionsRequest
     * @return A Java Future containing the result of the ListSubscriptionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionDefinitionsResponse> listSubscriptionDefinitions(
            ListSubscriptionDefinitionsRequest listSubscriptionDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of subscription definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSubscriptionDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscriptionDefinitionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListSubscriptionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionDefinitionsResponse> listSubscriptionDefinitions(
            Consumer<ListSubscriptionDefinitionsRequest.Builder> listSubscriptionDefinitionsRequest) {
        return listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest.builder()
                .applyMutation(listSubscriptionDefinitionsRequest).build());
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @return A Java Future containing the result of the ListSubscriptionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionDefinitionsResponse> listSubscriptionDefinitions() {
        return listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest.builder().build());
    }

    /**
     * Resets a group's deployments.
     *
     * @param resetDeploymentsRequest
     *        Information needed to reset deployments.
     * @return A Java Future containing the result of the ResetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ResetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetDeploymentsResponse> resetDeployments(ResetDeploymentsRequest resetDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Resets a group's deployments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ResetDeploymentsRequest#builder()}
     * </p>
     *
     * @param resetDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ResetDeploymentsRequest.Builder} to create a request.
     *        Information needed to reset deployments.
     * @return A Java Future containing the result of the ResetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ResetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResetDeploymentsResponse> resetDeployments(
            Consumer<ResetDeploymentsRequest.Builder> resetDeploymentsRequest) {
        return resetDeployments(ResetDeploymentsRequest.builder().applyMutation(resetDeploymentsRequest).build());
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.
     *
     * @param startBulkDeploymentRequest
     * @return A Java Future containing the result of the StartBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StartBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartBulkDeploymentResponse> startBulkDeployment(
            StartBulkDeploymentRequest startBulkDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBulkDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StartBulkDeploymentRequest#builder()}
     * </p>
     *
     * @param startBulkDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StartBulkDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StartBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartBulkDeploymentResponse> startBulkDeployment(
            Consumer<StartBulkDeploymentRequest.Builder> startBulkDeploymentRequest) {
        return startBulkDeployment(StartBulkDeploymentRequest.builder().applyMutation(startBulkDeploymentRequest).build());
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.
     *
     * @param stopBulkDeploymentRequest
     * @return A Java Future containing the result of the StopBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StopBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopBulkDeploymentResponse> stopBulkDeployment(StopBulkDeploymentRequest stopBulkDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBulkDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StopBulkDeploymentRequest#builder()}
     * </p>
     *
     * @param stopBulkDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StopBulkDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StopBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopBulkDeploymentResponse> stopBulkDeployment(
            Consumer<StopBulkDeploymentRequest.Builder> stopBulkDeploymentRequest) {
        return stopBulkDeployment(StopBulkDeploymentRequest.builder().applyMutation(stopBulkDeploymentRequest).build());
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.
     *
     * @param updateConnectivityInfoRequest
     *        Connectivity information.
     * @return A Java Future containing the result of the UpdateConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectivityInfoResponse> updateConnectivityInfo(
            UpdateConnectivityInfoRequest updateConnectivityInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectivityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectivityInfoRequest#builder()}
     * </p>
     *
     * @param updateConnectivityInfoRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectivityInfoRequest.Builder} to create a
     *        request. Connectivity information.
     * @return A Java Future containing the result of the UpdateConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectivityInfoResponse> updateConnectivityInfo(
            Consumer<UpdateConnectivityInfoRequest.Builder> updateConnectivityInfoRequest) {
        return updateConnectivityInfo(UpdateConnectivityInfoRequest.builder().applyMutation(updateConnectivityInfoRequest)
                .build());
    }

    /**
     * Updates a connector definition.
     *
     * @param updateConnectorDefinitionRequest
     * @return A Java Future containing the result of the UpdateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorDefinitionResponse> updateConnectorDefinition(
            UpdateConnectorDefinitionRequest updateConnectorDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a connector definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param updateConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorDefinitionResponse> updateConnectorDefinition(
            Consumer<UpdateConnectorDefinitionRequest.Builder> updateConnectorDefinitionRequest) {
        return updateConnectorDefinition(UpdateConnectorDefinitionRequest.builder()
                .applyMutation(updateConnectorDefinitionRequest).build());
    }

    /**
     * Updates a core definition.
     *
     * @param updateCoreDefinitionRequest
     * @return A Java Future containing the result of the UpdateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCoreDefinitionResponse> updateCoreDefinition(
            UpdateCoreDefinitionRequest updateCoreDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a core definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCoreDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param updateCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCoreDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCoreDefinitionResponse> updateCoreDefinition(
            Consumer<UpdateCoreDefinitionRequest.Builder> updateCoreDefinitionRequest) {
        return updateCoreDefinition(UpdateCoreDefinitionRequest.builder().applyMutation(updateCoreDefinitionRequest).build());
    }

    /**
     * Updates a device definition.
     *
     * @param updateDeviceDefinitionRequest
     * @return A Java Future containing the result of the UpdateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceDefinitionResponse> updateDeviceDefinition(
            UpdateDeviceDefinitionRequest updateDeviceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param updateDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceDefinitionResponse> updateDeviceDefinition(
            Consumer<UpdateDeviceDefinitionRequest.Builder> updateDeviceDefinitionRequest) {
        return updateDeviceDefinition(UpdateDeviceDefinitionRequest.builder().applyMutation(updateDeviceDefinitionRequest)
                .build());
    }

    /**
     * Updates a Lambda function definition.
     *
     * @param updateFunctionDefinitionRequest
     * @return A Java Future containing the result of the UpdateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionDefinitionResponse> updateFunctionDefinition(
            UpdateFunctionDefinitionRequest updateFunctionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a Lambda function definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param updateFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionDefinitionResponse> updateFunctionDefinition(
            Consumer<UpdateFunctionDefinitionRequest.Builder> updateFunctionDefinitionRequest) {
        return updateFunctionDefinition(UpdateFunctionDefinitionRequest.builder().applyMutation(updateFunctionDefinitionRequest)
                .build());
    }

    /**
     * Updates a group.
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * Updates the Certificate expiry time for a group.
     *
     * @param updateGroupCertificateConfigurationRequest
     * @return A Java Future containing the result of the UpdateGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGroupCertificateConfigurationResponse> updateGroupCertificateConfiguration(
            UpdateGroupCertificateConfigurationRequest updateGroupCertificateConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the Certificate expiry time for a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupCertificateConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateGroupCertificateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateGroupCertificateConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupCertificateConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGroupCertificateConfigurationResponse> updateGroupCertificateConfiguration(
            Consumer<UpdateGroupCertificateConfigurationRequest.Builder> updateGroupCertificateConfigurationRequest) {
        return updateGroupCertificateConfiguration(UpdateGroupCertificateConfigurationRequest.builder()
                .applyMutation(updateGroupCertificateConfigurationRequest).build());
    }

    /**
     * Updates a logger definition.
     *
     * @param updateLoggerDefinitionRequest
     * @return A Java Future containing the result of the UpdateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoggerDefinitionResponse> updateLoggerDefinition(
            UpdateLoggerDefinitionRequest updateLoggerDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param updateLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoggerDefinitionResponse> updateLoggerDefinition(
            Consumer<UpdateLoggerDefinitionRequest.Builder> updateLoggerDefinitionRequest) {
        return updateLoggerDefinition(UpdateLoggerDefinitionRequest.builder().applyMutation(updateLoggerDefinitionRequest)
                .build());
    }

    /**
     * Updates a resource definition.
     *
     * @param updateResourceDefinitionRequest
     * @return A Java Future containing the result of the UpdateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceDefinitionResponse> updateResourceDefinition(
            UpdateResourceDefinitionRequest updateResourceDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a resource definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param updateResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceDefinitionResponse> updateResourceDefinition(
            Consumer<UpdateResourceDefinitionRequest.Builder> updateResourceDefinitionRequest) {
        return updateResourceDefinition(UpdateResourceDefinitionRequest.builder().applyMutation(updateResourceDefinitionRequest)
                .build());
    }

    /**
     * Updates a subscription definition.
     *
     * @param updateSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the UpdateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionDefinitionResponse> updateSubscriptionDefinition(
            UpdateSubscriptionDefinitionRequest updateSubscriptionDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriptionDefinitionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionDefinitionResponse> updateSubscriptionDefinition(
            Consumer<UpdateSubscriptionDefinitionRequest.Builder> updateSubscriptionDefinitionRequest) {
        return updateSubscriptionDefinition(UpdateSubscriptionDefinitionRequest.builder()
                .applyMutation(updateSubscriptionDefinitionRequest).build());
    }
}
