/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a Lambda function.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Function implements SdkPojo, Serializable, ToCopyableBuilder<Function.Builder, Function> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Function::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<FunctionConfiguration> FUNCTION_CONFIGURATION_FIELD = SdkField
            .<FunctionConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(Function::functionConfiguration))
            .setter(setter(Builder::functionConfiguration)).constructor(FunctionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionConfiguration").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Function::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            FUNCTION_CONFIGURATION_FIELD, ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionArn;

    private final FunctionConfiguration functionConfiguration;

    private final String id;

    private Function(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.functionConfiguration = builder.functionConfiguration;
        this.id = builder.id;
    }

    /**
     * The ARN of the Lambda function.
     * 
     * @return The ARN of the Lambda function.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * The configuration of the Lambda function.
     * 
     * @return The configuration of the Lambda function.
     */
    public FunctionConfiguration functionConfiguration() {
        return functionConfiguration;
    }

    /**
     * A descriptive or arbitrary ID for the function. This value must be unique within the function definition version.
     * Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     * 
     * @return A descriptive or arbitrary ID for the function. This value must be unique within the function definition
     *         version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function) obj;
        return Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(functionConfiguration(), other.functionConfiguration()) && Objects.equals(id(), other.id());
    }

    @Override
    public String toString() {
        return ToString.builder("Function").add("FunctionArn", functionArn())
                .add("FunctionConfiguration", functionConfiguration()).add("Id", id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "FunctionConfiguration":
            return Optional.ofNullable(clazz.cast(functionConfiguration()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<Function, T> g) {
        return obj -> g.apply((Function) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Function> {
        /**
         * The ARN of the Lambda function.
         * 
         * @param functionArn
         *        The ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * The configuration of the Lambda function.
         * 
         * @param functionConfiguration
         *        The configuration of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionConfiguration(FunctionConfiguration functionConfiguration);

        /**
         * The configuration of the Lambda function. This is a convenience that creates an instance of the
         * {@link FunctionConfiguration.Builder} avoiding the need to create one manually via
         * {@link FunctionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #functionConfiguration(FunctionConfiguration)}.
         * 
         * @param functionConfiguration
         *        a consumer that will call methods on {@link FunctionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionConfiguration(FunctionConfiguration)
         */
        default Builder functionConfiguration(Consumer<FunctionConfiguration.Builder> functionConfiguration) {
            return functionConfiguration(FunctionConfiguration.builder().applyMutation(functionConfiguration).build());
        }

        /**
         * A descriptive or arbitrary ID for the function. This value must be unique within the function definition
         * version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * 
         * @param id
         *        A descriptive or arbitrary ID for the function. This value must be unique within the function
         *        definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String functionArn;

        private FunctionConfiguration functionConfiguration;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(Function model) {
            functionArn(model.functionArn);
            functionConfiguration(model.functionConfiguration);
            id(model.id);
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final FunctionConfiguration.Builder getFunctionConfiguration() {
            return functionConfiguration != null ? functionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder functionConfiguration(FunctionConfiguration functionConfiguration) {
            this.functionConfiguration = functionConfiguration;
            return this;
        }

        public final void setFunctionConfiguration(FunctionConfiguration.BuilderImpl functionConfiguration) {
            this.functionConfiguration = functionConfiguration != null ? functionConfiguration.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public Function build() {
            return new Function(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
