/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a bulk deployment. You cannot start a new bulk deployment while another one is still running or in
 * a non-terminal state.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkDeployment implements SdkPojo, Serializable, ToCopyableBuilder<BulkDeployment.Builder, BulkDeployment> {
    private static final SdkField<String> BULK_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeployment::bulkDeploymentArn)).setter(setter(Builder::bulkDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentArn").build()).build();

    private static final SdkField<String> BULK_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeployment::bulkDeploymentId)).setter(setter(Builder::bulkDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeploymentId").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeployment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENT_ARN_FIELD,
            BULK_DEPLOYMENT_ID_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bulkDeploymentArn;

    private final String bulkDeploymentId;

    private final String createdAt;

    private BulkDeployment(BuilderImpl builder) {
        this.bulkDeploymentArn = builder.bulkDeploymentArn;
        this.bulkDeploymentId = builder.bulkDeploymentId;
        this.createdAt = builder.createdAt;
    }

    /**
     * The ARN of the bulk deployment.
     * 
     * @return The ARN of the bulk deployment.
     */
    public String bulkDeploymentArn() {
        return bulkDeploymentArn;
    }

    /**
     * The ID of the bulk deployment.
     * 
     * @return The ID of the bulk deployment.
     */
    public String bulkDeploymentId() {
        return bulkDeploymentId;
    }

    /**
     * The time, in ISO format, when the deployment was created.
     * 
     * @return The time, in ISO format, when the deployment was created.
     */
    public String createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkDeployment)) {
            return false;
        }
        BulkDeployment other = (BulkDeployment) obj;
        return Objects.equals(bulkDeploymentArn(), other.bulkDeploymentArn())
                && Objects.equals(bulkDeploymentId(), other.bulkDeploymentId()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BulkDeployment").add("BulkDeploymentArn", bulkDeploymentArn())
                .add("BulkDeploymentId", bulkDeploymentId()).add("CreatedAt", createdAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BulkDeploymentArn":
            return Optional.ofNullable(clazz.cast(bulkDeploymentArn()));
        case "BulkDeploymentId":
            return Optional.ofNullable(clazz.cast(bulkDeploymentId()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkDeployment, T> g) {
        return obj -> g.apply((BulkDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkDeployment> {
        /**
         * The ARN of the bulk deployment.
         * 
         * @param bulkDeploymentArn
         *        The ARN of the bulk deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeploymentArn(String bulkDeploymentArn);

        /**
         * The ID of the bulk deployment.
         * 
         * @param bulkDeploymentId
         *        The ID of the bulk deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeploymentId(String bulkDeploymentId);

        /**
         * The time, in ISO format, when the deployment was created.
         * 
         * @param createdAt
         *        The time, in ISO format, when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String bulkDeploymentArn;

        private String bulkDeploymentId;

        private String createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkDeployment model) {
            bulkDeploymentArn(model.bulkDeploymentArn);
            bulkDeploymentId(model.bulkDeploymentId);
            createdAt(model.createdAt);
        }

        public final String getBulkDeploymentArn() {
            return bulkDeploymentArn;
        }

        @Override
        public final Builder bulkDeploymentArn(String bulkDeploymentArn) {
            this.bulkDeploymentArn = bulkDeploymentArn;
            return this;
        }

        public final void setBulkDeploymentArn(String bulkDeploymentArn) {
            this.bulkDeploymentArn = bulkDeploymentArn;
        }

        public final String getBulkDeploymentId() {
            return bulkDeploymentId;
        }

        @Override
        public final Builder bulkDeploymentId(String bulkDeploymentId) {
            this.bulkDeploymentId = bulkDeploymentId;
            return this;
        }

        public final void setBulkDeploymentId(String bulkDeploymentId) {
            this.bulkDeploymentId = bulkDeploymentId;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public BulkDeployment build() {
            return new BulkDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
