/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about an individual group deployment in a bulk deployment operation.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkDeploymentResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BulkDeploymentResult.Builder, BulkDeploymentResult> {
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::deploymentArn)).setter(setter(Builder::deploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentArn").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::deploymentStatus)).setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::deploymentTypeAsString)).setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .getter(getter(BulkDeploymentResult::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BulkDeploymentResult::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEPLOYMENT_ARN_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_TYPE_FIELD, ERROR_DETAILS_FIELD,
            ERROR_MESSAGE_FIELD, GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createdAt;

    private final String deploymentArn;

    private final String deploymentId;

    private final String deploymentStatus;

    private final String deploymentType;

    private final List<ErrorDetail> errorDetails;

    private final String errorMessage;

    private final String groupArn;

    private BulkDeploymentResult(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deploymentArn = builder.deploymentArn;
        this.deploymentId = builder.deploymentId;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.groupArn = builder.groupArn;
    }

    /**
     * The time, in ISO format, when the deployment was created.
     * 
     * @return The time, in ISO format, when the deployment was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * The ARN of the group deployment.
     * 
     * @return The ARN of the group deployment.
     */
    public String deploymentArn() {
        return deploymentArn;
    }

    /**
     * The ID of the group deployment.
     * 
     * @return The ID of the group deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
     * 
     * @return The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
     */
    public String deploymentStatus() {
        return deploymentStatus;
    }

    /**
     * The type of the deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * The type of the deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * Details about the error.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details about the error.
     */
    public List<ErrorDetail> errorDetails() {
        return errorDetails;
    }

    /**
     * The error message for a failed deployment
     * 
     * @return The error message for a failed deployment
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * The ARN of the Greengrass group.
     * 
     * @return The ARN of the Greengrass group.
     */
    public String groupArn() {
        return groupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkDeploymentResult)) {
            return false;
        }
        BulkDeploymentResult other = (BulkDeploymentResult) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deploymentArn(), other.deploymentArn())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentStatus(), other.deploymentStatus())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(errorDetails(), other.errorDetails()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(groupArn(), other.groupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BulkDeploymentResult").add("CreatedAt", createdAt()).add("DeploymentArn", deploymentArn())
                .add("DeploymentId", deploymentId()).add("DeploymentStatus", deploymentStatus())
                .add("DeploymentType", deploymentTypeAsString()).add("ErrorDetails", errorDetails())
                .add("ErrorMessage", errorMessage()).add("GroupArn", groupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DeploymentArn":
            return Optional.ofNullable(clazz.cast(deploymentArn()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkDeploymentResult, T> g) {
        return obj -> g.apply((BulkDeploymentResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkDeploymentResult> {
        /**
         * The time, in ISO format, when the deployment was created.
         * 
         * @param createdAt
         *        The time, in ISO format, when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * The ARN of the group deployment.
         * 
         * @param deploymentArn
         *        The ARN of the group deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentArn(String deploymentArn);

        /**
         * The ID of the group deployment.
         * 
         * @param deploymentId
         *        The ID of the group deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
         * 
         * @param deploymentStatus
         *        The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * The type of the deployment.
         * 
         * @param deploymentType
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * The type of the deployment.
         * 
         * @param deploymentType
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * Details about the error.
         * 
         * @param errorDetails
         *        Details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(Collection<ErrorDetail> errorDetails);

        /**
         * Details about the error.
         * 
         * @param errorDetails
         *        Details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetail... errorDetails);

        /**
         * Details about the error. This is a convenience that creates an instance of the {@link List
         * <ErrorDetail>.Builder} avoiding the need to create one manually via {@link List<ErrorDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ErrorDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(List<ErrorDetail>)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link List<ErrorDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(List<ErrorDetail>)
         */
        Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails);

        /**
         * The error message for a failed deployment
         * 
         * @param errorMessage
         *        The error message for a failed deployment
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * The ARN of the Greengrass group.
         * 
         * @param groupArn
         *        The ARN of the Greengrass group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);
    }

    static final class BuilderImpl implements Builder {
        private String createdAt;

        private String deploymentArn;

        private String deploymentId;

        private String deploymentStatus;

        private String deploymentType;

        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private String groupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkDeploymentResult model) {
            createdAt(model.createdAt);
            deploymentArn(model.deploymentArn);
            deploymentId(model.deploymentId);
            deploymentStatus(model.deploymentStatus);
            deploymentType(model.deploymentType);
            errorDetails(model.errorDetails);
            errorMessage(model.errorMessage);
            groupArn(model.groupArn);
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDeploymentArn() {
            return deploymentArn;
        }

        @Override
        public final Builder deploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
            return this;
        }

        public final void setDeploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final String getDeploymentTypeAsString() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final Collection<ErrorDetail.Builder> getErrorDetails() {
            return errorDetails != null ? errorDetails.stream().map(ErrorDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail... errorDetails) {
            errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails) {
            errorDetails(Stream.of(errorDetails).map(c -> ErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getGroupArn() {
            return groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public BulkDeploymentResult build() {
            return new BulkDeploymentResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
