/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSoftwareUpdateJobRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateSoftwareUpdateJobRequest.Builder, CreateSoftwareUpdateJobRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSoftwareUpdateJobRequest::amznClientToken)).setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<String> S3_URL_SIGNER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSoftwareUpdateJobRequest::s3UrlSignerRole)).setter(setter(Builder::s3UrlSignerRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UrlSignerRole").build()).build();

    private static final SdkField<String> SOFTWARE_TO_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSoftwareUpdateJobRequest::softwareToUpdateAsString)).setter(setter(Builder::softwareToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareToUpdate").build()).build();

    private static final SdkField<String> UPDATE_AGENT_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSoftwareUpdateJobRequest::updateAgentLogLevelAsString))
            .setter(setter(Builder::updateAgentLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAgentLogLevel").build())
            .build();

    private static final SdkField<List<String>> UPDATE_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateSoftwareUpdateJobRequest::updateTargets))
            .setter(setter(Builder::updateTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TARGETS_ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSoftwareUpdateJobRequest::updateTargetsArchitectureAsString))
            .setter(setter(Builder::updateTargetsArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargetsArchitecture").build())
            .build();

    private static final SdkField<String> UPDATE_TARGETS_OPERATING_SYSTEM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSoftwareUpdateJobRequest::updateTargetsOperatingSystemAsString))
            .setter(setter(Builder::updateTargetsOperatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargetsOperatingSystem")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            S3_URL_SIGNER_ROLE_FIELD, SOFTWARE_TO_UPDATE_FIELD, UPDATE_AGENT_LOG_LEVEL_FIELD, UPDATE_TARGETS_FIELD,
            UPDATE_TARGETS_ARCHITECTURE_FIELD, UPDATE_TARGETS_OPERATING_SYSTEM_FIELD));

    private final String amznClientToken;

    private final String s3UrlSignerRole;

    private final String softwareToUpdate;

    private final String updateAgentLogLevel;

    private final List<String> updateTargets;

    private final String updateTargetsArchitecture;

    private final String updateTargetsOperatingSystem;

    private CreateSoftwareUpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.s3UrlSignerRole = builder.s3UrlSignerRole;
        this.softwareToUpdate = builder.softwareToUpdate;
        this.updateAgentLogLevel = builder.updateAgentLogLevel;
        this.updateTargets = builder.updateTargets;
        this.updateTargetsArchitecture = builder.updateTargetsArchitecture;
        this.updateTargetsOperatingSystem = builder.updateTargetsOperatingSystem;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public String amznClientToken() {
        return amznClientToken;
    }

    /**
     * Returns the value of the S3UrlSignerRole property for this object.
     * 
     * @return The value of the S3UrlSignerRole property for this object.
     */
    public String s3UrlSignerRole() {
        return s3UrlSignerRole;
    }

    /**
     * Returns the value of the SoftwareToUpdate property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #softwareToUpdate}
     * will return {@link SoftwareToUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #softwareToUpdateAsString}.
     * </p>
     * 
     * @return The value of the SoftwareToUpdate property for this object.
     * @see SoftwareToUpdate
     */
    public SoftwareToUpdate softwareToUpdate() {
        return SoftwareToUpdate.fromValue(softwareToUpdate);
    }

    /**
     * Returns the value of the SoftwareToUpdate property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #softwareToUpdate}
     * will return {@link SoftwareToUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #softwareToUpdateAsString}.
     * </p>
     * 
     * @return The value of the SoftwareToUpdate property for this object.
     * @see SoftwareToUpdate
     */
    public String softwareToUpdateAsString() {
        return softwareToUpdate;
    }

    /**
     * Returns the value of the UpdateAgentLogLevel property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateAgentLogLevel} will return {@link UpdateAgentLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #updateAgentLogLevelAsString}.
     * </p>
     * 
     * @return The value of the UpdateAgentLogLevel property for this object.
     * @see UpdateAgentLogLevel
     */
    public UpdateAgentLogLevel updateAgentLogLevel() {
        return UpdateAgentLogLevel.fromValue(updateAgentLogLevel);
    }

    /**
     * Returns the value of the UpdateAgentLogLevel property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateAgentLogLevel} will return {@link UpdateAgentLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #updateAgentLogLevelAsString}.
     * </p>
     * 
     * @return The value of the UpdateAgentLogLevel property for this object.
     * @see UpdateAgentLogLevel
     */
    public String updateAgentLogLevelAsString() {
        return updateAgentLogLevel;
    }

    /**
     * Returns the value of the UpdateTargets property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the UpdateTargets property for this object.
     */
    public List<String> updateTargets() {
        return updateTargets;
    }

    /**
     * Returns the value of the UpdateTargetsArchitecture property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateTargetsArchitecture} will return {@link UpdateTargetsArchitecture#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #updateTargetsArchitectureAsString}.
     * </p>
     * 
     * @return The value of the UpdateTargetsArchitecture property for this object.
     * @see UpdateTargetsArchitecture
     */
    public UpdateTargetsArchitecture updateTargetsArchitecture() {
        return UpdateTargetsArchitecture.fromValue(updateTargetsArchitecture);
    }

    /**
     * Returns the value of the UpdateTargetsArchitecture property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateTargetsArchitecture} will return {@link UpdateTargetsArchitecture#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #updateTargetsArchitectureAsString}.
     * </p>
     * 
     * @return The value of the UpdateTargetsArchitecture property for this object.
     * @see UpdateTargetsArchitecture
     */
    public String updateTargetsArchitectureAsString() {
        return updateTargetsArchitecture;
    }

    /**
     * Returns the value of the UpdateTargetsOperatingSystem property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateTargetsOperatingSystem} will return {@link UpdateTargetsOperatingSystem#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #updateTargetsOperatingSystemAsString}.
     * </p>
     * 
     * @return The value of the UpdateTargetsOperatingSystem property for this object.
     * @see UpdateTargetsOperatingSystem
     */
    public UpdateTargetsOperatingSystem updateTargetsOperatingSystem() {
        return UpdateTargetsOperatingSystem.fromValue(updateTargetsOperatingSystem);
    }

    /**
     * Returns the value of the UpdateTargetsOperatingSystem property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateTargetsOperatingSystem} will return {@link UpdateTargetsOperatingSystem#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #updateTargetsOperatingSystemAsString}.
     * </p>
     * 
     * @return The value of the UpdateTargetsOperatingSystem property for this object.
     * @see UpdateTargetsOperatingSystem
     */
    public String updateTargetsOperatingSystemAsString() {
        return updateTargetsOperatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(s3UrlSignerRole());
        hashCode = 31 * hashCode + Objects.hashCode(softwareToUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateAgentLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTargets());
        hashCode = 31 * hashCode + Objects.hashCode(updateTargetsArchitectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTargetsOperatingSystemAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSoftwareUpdateJobRequest)) {
            return false;
        }
        CreateSoftwareUpdateJobRequest other = (CreateSoftwareUpdateJobRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(s3UrlSignerRole(), other.s3UrlSignerRole())
                && Objects.equals(softwareToUpdateAsString(), other.softwareToUpdateAsString())
                && Objects.equals(updateAgentLogLevelAsString(), other.updateAgentLogLevelAsString())
                && Objects.equals(updateTargets(), other.updateTargets())
                && Objects.equals(updateTargetsArchitectureAsString(), other.updateTargetsArchitectureAsString())
                && Objects.equals(updateTargetsOperatingSystemAsString(), other.updateTargetsOperatingSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSoftwareUpdateJobRequest").add("AmznClientToken", amznClientToken())
                .add("S3UrlSignerRole", s3UrlSignerRole()).add("SoftwareToUpdate", softwareToUpdateAsString())
                .add("UpdateAgentLogLevel", updateAgentLogLevelAsString()).add("UpdateTargets", updateTargets())
                .add("UpdateTargetsArchitecture", updateTargetsArchitectureAsString())
                .add("UpdateTargetsOperatingSystem", updateTargetsOperatingSystemAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "S3UrlSignerRole":
            return Optional.ofNullable(clazz.cast(s3UrlSignerRole()));
        case "SoftwareToUpdate":
            return Optional.ofNullable(clazz.cast(softwareToUpdateAsString()));
        case "UpdateAgentLogLevel":
            return Optional.ofNullable(clazz.cast(updateAgentLogLevelAsString()));
        case "UpdateTargets":
            return Optional.ofNullable(clazz.cast(updateTargets()));
        case "UpdateTargetsArchitecture":
            return Optional.ofNullable(clazz.cast(updateTargetsArchitectureAsString()));
        case "UpdateTargetsOperatingSystem":
            return Optional.ofNullable(clazz.cast(updateTargetsOperatingSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSoftwareUpdateJobRequest, T> g) {
        return obj -> g.apply((CreateSoftwareUpdateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSoftwareUpdateJobRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * Sets the value of the S3UrlSignerRole property for this object.
         *
         * @param s3UrlSignerRole
         *        The new value for the S3UrlSignerRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3UrlSignerRole(String s3UrlSignerRole);

        /**
         * Sets the value of the SoftwareToUpdate property for this object.
         *
         * @param softwareToUpdate
         *        The new value for the SoftwareToUpdate property for this object.
         * @see SoftwareToUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareToUpdate
         */
        Builder softwareToUpdate(String softwareToUpdate);

        /**
         * Sets the value of the SoftwareToUpdate property for this object.
         *
         * @param softwareToUpdate
         *        The new value for the SoftwareToUpdate property for this object.
         * @see SoftwareToUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareToUpdate
         */
        Builder softwareToUpdate(SoftwareToUpdate softwareToUpdate);

        /**
         * Sets the value of the UpdateAgentLogLevel property for this object.
         *
         * @param updateAgentLogLevel
         *        The new value for the UpdateAgentLogLevel property for this object.
         * @see UpdateAgentLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateAgentLogLevel
         */
        Builder updateAgentLogLevel(String updateAgentLogLevel);

        /**
         * Sets the value of the UpdateAgentLogLevel property for this object.
         *
         * @param updateAgentLogLevel
         *        The new value for the UpdateAgentLogLevel property for this object.
         * @see UpdateAgentLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateAgentLogLevel
         */
        Builder updateAgentLogLevel(UpdateAgentLogLevel updateAgentLogLevel);

        /**
         * Sets the value of the UpdateTargets property for this object.
         *
         * @param updateTargets
         *        The new value for the UpdateTargets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTargets(Collection<String> updateTargets);

        /**
         * Sets the value of the UpdateTargets property for this object.
         *
         * @param updateTargets
         *        The new value for the UpdateTargets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTargets(String... updateTargets);

        /**
         * Sets the value of the UpdateTargetsArchitecture property for this object.
         *
         * @param updateTargetsArchitecture
         *        The new value for the UpdateTargetsArchitecture property for this object.
         * @see UpdateTargetsArchitecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateTargetsArchitecture
         */
        Builder updateTargetsArchitecture(String updateTargetsArchitecture);

        /**
         * Sets the value of the UpdateTargetsArchitecture property for this object.
         *
         * @param updateTargetsArchitecture
         *        The new value for the UpdateTargetsArchitecture property for this object.
         * @see UpdateTargetsArchitecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateTargetsArchitecture
         */
        Builder updateTargetsArchitecture(UpdateTargetsArchitecture updateTargetsArchitecture);

        /**
         * Sets the value of the UpdateTargetsOperatingSystem property for this object.
         *
         * @param updateTargetsOperatingSystem
         *        The new value for the UpdateTargetsOperatingSystem property for this object.
         * @see UpdateTargetsOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateTargetsOperatingSystem
         */
        Builder updateTargetsOperatingSystem(String updateTargetsOperatingSystem);

        /**
         * Sets the value of the UpdateTargetsOperatingSystem property for this object.
         *
         * @param updateTargetsOperatingSystem
         *        The new value for the UpdateTargetsOperatingSystem property for this object.
         * @see UpdateTargetsOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateTargetsOperatingSystem
         */
        Builder updateTargetsOperatingSystem(UpdateTargetsOperatingSystem updateTargetsOperatingSystem);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private String s3UrlSignerRole;

        private String softwareToUpdate;

        private String updateAgentLogLevel;

        private List<String> updateTargets = DefaultSdkAutoConstructList.getInstance();

        private String updateTargetsArchitecture;

        private String updateTargetsOperatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSoftwareUpdateJobRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            s3UrlSignerRole(model.s3UrlSignerRole);
            softwareToUpdate(model.softwareToUpdate);
            updateAgentLogLevel(model.updateAgentLogLevel);
            updateTargets(model.updateTargets);
            updateTargetsArchitecture(model.updateTargetsArchitecture);
            updateTargetsOperatingSystem(model.updateTargetsOperatingSystem);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getS3UrlSignerRole() {
            return s3UrlSignerRole;
        }

        @Override
        public final Builder s3UrlSignerRole(String s3UrlSignerRole) {
            this.s3UrlSignerRole = s3UrlSignerRole;
            return this;
        }

        public final void setS3UrlSignerRole(String s3UrlSignerRole) {
            this.s3UrlSignerRole = s3UrlSignerRole;
        }

        public final String getSoftwareToUpdateAsString() {
            return softwareToUpdate;
        }

        @Override
        public final Builder softwareToUpdate(String softwareToUpdate) {
            this.softwareToUpdate = softwareToUpdate;
            return this;
        }

        @Override
        public final Builder softwareToUpdate(SoftwareToUpdate softwareToUpdate) {
            this.softwareToUpdate(softwareToUpdate == null ? null : softwareToUpdate.toString());
            return this;
        }

        public final void setSoftwareToUpdate(String softwareToUpdate) {
            this.softwareToUpdate = softwareToUpdate;
        }

        public final String getUpdateAgentLogLevelAsString() {
            return updateAgentLogLevel;
        }

        @Override
        public final Builder updateAgentLogLevel(String updateAgentLogLevel) {
            this.updateAgentLogLevel = updateAgentLogLevel;
            return this;
        }

        @Override
        public final Builder updateAgentLogLevel(UpdateAgentLogLevel updateAgentLogLevel) {
            this.updateAgentLogLevel(updateAgentLogLevel == null ? null : updateAgentLogLevel.toString());
            return this;
        }

        public final void setUpdateAgentLogLevel(String updateAgentLogLevel) {
            this.updateAgentLogLevel = updateAgentLogLevel;
        }

        public final Collection<String> getUpdateTargets() {
            return updateTargets;
        }

        @Override
        public final Builder updateTargets(Collection<String> updateTargets) {
            this.updateTargets = UpdateTargetsCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(String... updateTargets) {
            updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        public final void setUpdateTargets(Collection<String> updateTargets) {
            this.updateTargets = UpdateTargetsCopier.copy(updateTargets);
        }

        public final String getUpdateTargetsArchitectureAsString() {
            return updateTargetsArchitecture;
        }

        @Override
        public final Builder updateTargetsArchitecture(String updateTargetsArchitecture) {
            this.updateTargetsArchitecture = updateTargetsArchitecture;
            return this;
        }

        @Override
        public final Builder updateTargetsArchitecture(UpdateTargetsArchitecture updateTargetsArchitecture) {
            this.updateTargetsArchitecture(updateTargetsArchitecture == null ? null : updateTargetsArchitecture.toString());
            return this;
        }

        public final void setUpdateTargetsArchitecture(String updateTargetsArchitecture) {
            this.updateTargetsArchitecture = updateTargetsArchitecture;
        }

        public final String getUpdateTargetsOperatingSystemAsString() {
            return updateTargetsOperatingSystem;
        }

        @Override
        public final Builder updateTargetsOperatingSystem(String updateTargetsOperatingSystem) {
            this.updateTargetsOperatingSystem = updateTargetsOperatingSystem;
            return this;
        }

        @Override
        public final Builder updateTargetsOperatingSystem(UpdateTargetsOperatingSystem updateTargetsOperatingSystem) {
            this.updateTargetsOperatingSystem(updateTargetsOperatingSystem == null ? null : updateTargetsOperatingSystem
                    .toString());
            return this;
        }

        public final void setUpdateTargetsOperatingSystem(String updateTargetsOperatingSystem) {
            this.updateTargetsOperatingSystem = updateTargetsOperatingSystem;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSoftwareUpdateJobRequest build() {
            return new CreateSoftwareUpdateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
