/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateServiceRoleFromAccountResponse extends GreengrassResponse implements
        ToCopyableBuilder<DisassociateServiceRoleFromAccountResponse.Builder, DisassociateServiceRoleFromAccountResponse> {
    private static final SdkField<String> DISASSOCIATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisassociatedAt").getter(getter(DisassociateServiceRoleFromAccountResponse::disassociatedAt))
            .setter(setter(Builder::disassociatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISASSOCIATED_AT_FIELD));

    private final String disassociatedAt;

    private DisassociateServiceRoleFromAccountResponse(BuilderImpl builder) {
        super(builder);
        this.disassociatedAt = builder.disassociatedAt;
    }

    /**
     * The time when the service role was disassociated from the account.
     * 
     * @return The time when the service role was disassociated from the account.
     */
    public String disassociatedAt() {
        return disassociatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(disassociatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateServiceRoleFromAccountResponse)) {
            return false;
        }
        DisassociateServiceRoleFromAccountResponse other = (DisassociateServiceRoleFromAccountResponse) obj;
        return Objects.equals(disassociatedAt(), other.disassociatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateServiceRoleFromAccountResponse").add("DisassociatedAt", disassociatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisassociatedAt":
            return Optional.ofNullable(clazz.cast(disassociatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateServiceRoleFromAccountResponse, T> g) {
        return obj -> g.apply((DisassociateServiceRoleFromAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateServiceRoleFromAccountResponse> {
        /**
         * The time when the service role was disassociated from the account.
         * 
         * @param disassociatedAt
         *        The time when the service role was disassociated from the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociatedAt(String disassociatedAt);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String disassociatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateServiceRoleFromAccountResponse model) {
            super(model);
            disassociatedAt(model.disassociatedAt);
        }

        public final String getDisassociatedAt() {
            return disassociatedAt;
        }

        @Override
        public final Builder disassociatedAt(String disassociatedAt) {
            this.disassociatedAt = disassociatedAt;
            return this;
        }

        public final void setDisassociatedAt(String disassociatedAt) {
            this.disassociatedAt = disassociatedAt;
        }

        @Override
        public DisassociateServiceRoleFromAccountResponse build() {
            return new DisassociateServiceRoleFromAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
