/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Runtime configuration for a thing.
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RuntimeConfiguration.Builder, RuntimeConfiguration> {
    private static final SdkField<TelemetryConfiguration> TELEMETRY_CONFIGURATION_FIELD = SdkField
            .<TelemetryConfiguration> builder(MarshallingType.SDK_POJO).memberName("TelemetryConfiguration")
            .getter(getter(RuntimeConfiguration::telemetryConfiguration)).setter(setter(Builder::telemetryConfiguration))
            .constructor(TelemetryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TELEMETRY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final TelemetryConfiguration telemetryConfiguration;

    private RuntimeConfiguration(BuilderImpl builder) {
        this.telemetryConfiguration = builder.telemetryConfiguration;
    }

    /**
     * Configuration for telemetry service.
     * 
     * @return Configuration for telemetry service.
     */
    public TelemetryConfiguration telemetryConfiguration() {
        return telemetryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(telemetryConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeConfiguration)) {
            return false;
        }
        RuntimeConfiguration other = (RuntimeConfiguration) obj;
        return Objects.equals(telemetryConfiguration(), other.telemetryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RuntimeConfiguration").add("TelemetryConfiguration", telemetryConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TelemetryConfiguration":
            return Optional.ofNullable(clazz.cast(telemetryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeConfiguration, T> g) {
        return obj -> g.apply((RuntimeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeConfiguration> {
        /**
         * Configuration for telemetry service.
         * 
         * @param telemetryConfiguration
         *        Configuration for telemetry service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryConfiguration(TelemetryConfiguration telemetryConfiguration);

        /**
         * Configuration for telemetry service. This is a convenience that creates an instance of the
         * {@link TelemetryConfiguration.Builder} avoiding the need to create one manually via
         * {@link TelemetryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TelemetryConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #telemetryConfiguration(TelemetryConfiguration)}.
         * 
         * @param telemetryConfiguration
         *        a consumer that will call methods on {@link TelemetryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryConfiguration(TelemetryConfiguration)
         */
        default Builder telemetryConfiguration(Consumer<TelemetryConfiguration.Builder> telemetryConfiguration) {
            return telemetryConfiguration(TelemetryConfiguration.builder().applyMutation(telemetryConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TelemetryConfiguration telemetryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeConfiguration model) {
            telemetryConfiguration(model.telemetryConfiguration);
        }

        public final TelemetryConfiguration.Builder getTelemetryConfiguration() {
            return telemetryConfiguration != null ? telemetryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder telemetryConfiguration(TelemetryConfiguration telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration;
            return this;
        }

        public final void setTelemetryConfiguration(TelemetryConfiguration.BuilderImpl telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration != null ? telemetryConfiguration.build() : null;
        }

        @Override
        public RuntimeConfiguration build() {
            return new RuntimeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
