/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLoggerDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<UpdateLoggerDefinitionRequest.Builder, UpdateLoggerDefinitionRequest> {
    private static final SdkField<String> LOGGER_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggerDefinitionId").getter(getter(UpdateLoggerDefinitionRequest::loggerDefinitionId))
            .setter(setter(Builder::loggerDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LoggerDefinitionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateLoggerDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGER_DEFINITION_ID_FIELD,
            NAME_FIELD));

    private final String loggerDefinitionId;

    private final String name;

    private UpdateLoggerDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.loggerDefinitionId = builder.loggerDefinitionId;
        this.name = builder.name;
    }

    /**
     * The ID of the logger definition.
     * 
     * @return The ID of the logger definition.
     */
    public String loggerDefinitionId() {
        return loggerDefinitionId;
    }

    /**
     * The name of the definition.
     * 
     * @return The name of the definition.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loggerDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLoggerDefinitionRequest)) {
            return false;
        }
        UpdateLoggerDefinitionRequest other = (UpdateLoggerDefinitionRequest) obj;
        return Objects.equals(loggerDefinitionId(), other.loggerDefinitionId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateLoggerDefinitionRequest").add("LoggerDefinitionId", loggerDefinitionId())
                .add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoggerDefinitionId":
            return Optional.ofNullable(clazz.cast(loggerDefinitionId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLoggerDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateLoggerDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLoggerDefinitionRequest> {
        /**
         * The ID of the logger definition.
         * 
         * @param loggerDefinitionId
         *        The ID of the logger definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggerDefinitionId(String loggerDefinitionId);

        /**
         * The name of the definition.
         * 
         * @param name
         *        The name of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String loggerDefinitionId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLoggerDefinitionRequest model) {
            super(model);
            loggerDefinitionId(model.loggerDefinitionId);
            name(model.name);
        }

        public final String getLoggerDefinitionId() {
            return loggerDefinitionId;
        }

        @Override
        public final Builder loggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
            return this;
        }

        public final void setLoggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLoggerDefinitionRequest build() {
            return new UpdateLoggerDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
