/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a logger definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggerDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggerDefinitionVersion.Builder, LoggerDefinitionVersion> {
    private static final SdkField<List<Logger>> LOGGERS_FIELD = SdkField
            .<List<Logger>> builder(MarshallingType.LIST)
            .memberName("Loggers")
            .getter(getter(LoggerDefinitionVersion::loggers))
            .setter(setter(Builder::loggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Loggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Logger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Logger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Logger> loggers;

    private LoggerDefinitionVersion(BuilderImpl builder) {
        this.loggers = builder.loggers;
    }

    /**
     * Returns true if the Loggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLoggers() {
        return loggers != null && !(loggers instanceof SdkAutoConstructList);
    }

    /**
     * A list of loggers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of loggers.
     */
    public List<Logger> loggers() {
        return loggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLoggers() ? loggers() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggerDefinitionVersion)) {
            return false;
        }
        LoggerDefinitionVersion other = (LoggerDefinitionVersion) obj;
        return hasLoggers() == other.hasLoggers() && Objects.equals(loggers(), other.loggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoggerDefinitionVersion").add("Loggers", hasLoggers() ? loggers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Loggers":
            return Optional.ofNullable(clazz.cast(loggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggerDefinitionVersion, T> g) {
        return obj -> g.apply((LoggerDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggerDefinitionVersion> {
        /**
         * A list of loggers.
         * 
         * @param loggers
         *        A list of loggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggers(Collection<Logger> loggers);

        /**
         * A list of loggers.
         * 
         * @param loggers
         *        A list of loggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggers(Logger... loggers);

        /**
         * A list of loggers. This is a convenience that creates an instance of the {@link List<Logger>.Builder}
         * avoiding the need to create one manually via {@link List<Logger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Logger>.Builder#build()} is called immediately and its
         * result is passed to {@link #loggers(List<Logger>)}.
         * 
         * @param loggers
         *        a consumer that will call methods on {@link List<Logger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggers(List<Logger>)
         */
        Builder loggers(Consumer<Logger.Builder>... loggers);
    }

    static final class BuilderImpl implements Builder {
        private List<Logger> loggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggerDefinitionVersion model) {
            loggers(model.loggers);
        }

        public final Collection<Logger.Builder> getLoggers() {
            if (loggers instanceof SdkAutoConstructList) {
                return null;
            }
            return loggers != null ? loggers.stream().map(Logger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loggers(Collection<Logger> loggers) {
            this.loggers = ___listOfLoggerCopier.copy(loggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Logger... loggers) {
            loggers(Arrays.asList(loggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Consumer<Logger.Builder>... loggers) {
            loggers(Stream.of(loggers).map(c -> Logger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoggers(Collection<Logger.BuilderImpl> loggers) {
            this.loggers = ___listOfLoggerCopier.copyFromBuilder(loggers);
        }

        @Override
        public LoggerDefinitionVersion build() {
            return new LoggerDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
