/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Resource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Resource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ResourceDataContainer> RESOURCE_DATA_CONTAINER_FIELD = SdkField
            .<ResourceDataContainer> builder(MarshallingType.SDK_POJO).memberName("ResourceDataContainer")
            .getter(getter(Resource::resourceDataContainer)).setter(setter(Builder::resourceDataContainer))
            .constructor(ResourceDataContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDataContainer").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            RESOURCE_DATA_CONTAINER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final ResourceDataContainer resourceDataContainer;

    private Resource(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.resourceDataContainer = builder.resourceDataContainer;
    }

    /**
     * The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128 characters
     * with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
     * 
     * @return The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128
     *         characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
     */
    public String id() {
        return id;
    }

    /**
     * The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128 characters
     * with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
     * 
     * @return The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128
     *         characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
     */
    public String name() {
        return name;
    }

    /**
     * A container of data for all resource types.
     * 
     * @return A container of data for all resource types.
     */
    public ResourceDataContainer resourceDataContainer() {
        return resourceDataContainer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDataContainer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(resourceDataContainer(), other.resourceDataContainer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Resource").add("Id", id()).add("Name", name())
                .add("ResourceDataContainer", resourceDataContainer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResourceDataContainer":
            return Optional.ofNullable(clazz.cast(resourceDataContainer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128
         * characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
         * 
         * @param id
         *        The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128
         *        characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128
         * characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
         * 
         * @param name
         *        The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128
         *        characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * A container of data for all resource types.
         * 
         * @param resourceDataContainer
         *        A container of data for all resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDataContainer(ResourceDataContainer resourceDataContainer);

        /**
         * A container of data for all resource types. This is a convenience that creates an instance of the
         * {@link ResourceDataContainer.Builder} avoiding the need to create one manually via
         * {@link ResourceDataContainer#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDataContainer.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceDataContainer(ResourceDataContainer)}.
         * 
         * @param resourceDataContainer
         *        a consumer that will call methods on {@link ResourceDataContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDataContainer(ResourceDataContainer)
         */
        default Builder resourceDataContainer(Consumer<ResourceDataContainer.Builder> resourceDataContainer) {
            return resourceDataContainer(ResourceDataContainer.builder().applyMutation(resourceDataContainer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private ResourceDataContainer resourceDataContainer;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            id(model.id);
            name(model.name);
            resourceDataContainer(model.resourceDataContainer);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ResourceDataContainer.Builder getResourceDataContainer() {
            return resourceDataContainer != null ? resourceDataContainer.toBuilder() : null;
        }

        @Override
        public final Builder resourceDataContainer(ResourceDataContainer resourceDataContainer) {
            this.resourceDataContainer = resourceDataContainer;
            return this;
        }

        public final void setResourceDataContainer(ResourceDataContainer.BuilderImpl resourceDataContainer) {
            this.resourceDataContainer = resourceDataContainer != null ? resourceDataContainer.build() : null;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
