/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The owner setting for downloaded machine learning resources.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDownloadOwnerSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDownloadOwnerSetting.Builder, ResourceDownloadOwnerSetting> {
    private static final SdkField<String> GROUP_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupOwner").getter(getter(ResourceDownloadOwnerSetting::groupOwner))
            .setter(setter(Builder::groupOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwner").build()).build();

    private static final SdkField<String> GROUP_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupPermission").getter(getter(ResourceDownloadOwnerSetting::groupPermissionAsString))
            .setter(setter(Builder::groupPermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupPermission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_OWNER_FIELD,
            GROUP_PERMISSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupOwner;

    private final String groupPermission;

    private ResourceDownloadOwnerSetting(BuilderImpl builder) {
        this.groupOwner = builder.groupOwner;
        this.groupPermission = builder.groupPermission;
    }

    /**
     * The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID. The
     * group's permissions are added to the Lambda process.
     * 
     * @return The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID.
     *         The group's permissions are added to the Lambda process.
     */
    public String groupOwner() {
        return groupOwner;
    }

    /**
     * The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro''
     * (read-only).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupPermission}
     * will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupPermissionAsString}.
     * </p>
     * 
     * @return The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro''
     *         (read-only).
     * @see Permission
     */
    public Permission groupPermission() {
        return Permission.fromValue(groupPermission);
    }

    /**
     * The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro''
     * (read-only).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupPermission}
     * will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupPermissionAsString}.
     * </p>
     * 
     * @return The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro''
     *         (read-only).
     * @see Permission
     */
    public String groupPermissionAsString() {
        return groupPermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupOwner());
        hashCode = 31 * hashCode + Objects.hashCode(groupPermissionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDownloadOwnerSetting)) {
            return false;
        }
        ResourceDownloadOwnerSetting other = (ResourceDownloadOwnerSetting) obj;
        return Objects.equals(groupOwner(), other.groupOwner())
                && Objects.equals(groupPermissionAsString(), other.groupPermissionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceDownloadOwnerSetting").add("GroupOwner", groupOwner())
                .add("GroupPermission", groupPermissionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupOwner":
            return Optional.ofNullable(clazz.cast(groupOwner()));
        case "GroupPermission":
            return Optional.ofNullable(clazz.cast(groupPermissionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDownloadOwnerSetting, T> g) {
        return obj -> g.apply((ResourceDownloadOwnerSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDownloadOwnerSetting> {
        /**
         * The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID. The
         * group's permissions are added to the Lambda process.
         * 
         * @param groupOwner
         *        The group owner of the resource. This is the name of an existing Linux OS group on the system or a
         *        GID. The group's permissions are added to the Lambda process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOwner(String groupOwner);

        /**
         * The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro''
         * (read-only).
         * 
         * @param groupPermission
         *        The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or
         *        ''ro'' (read-only).
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder groupPermission(String groupPermission);

        /**
         * The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro''
         * (read-only).
         * 
         * @param groupPermission
         *        The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or
         *        ''ro'' (read-only).
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder groupPermission(Permission groupPermission);
    }

    static final class BuilderImpl implements Builder {
        private String groupOwner;

        private String groupPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDownloadOwnerSetting model) {
            groupOwner(model.groupOwner);
            groupPermission(model.groupPermission);
        }

        public final String getGroupOwner() {
            return groupOwner;
        }

        @Override
        public final Builder groupOwner(String groupOwner) {
            this.groupOwner = groupOwner;
            return this;
        }

        public final void setGroupOwner(String groupOwner) {
            this.groupOwner = groupOwner;
        }

        public final String getGroupPermission() {
            return groupPermission;
        }

        @Override
        public final Builder groupPermission(String groupPermission) {
            this.groupPermission = groupPermission;
            return this;
        }

        @Override
        public final Builder groupPermission(Permission groupPermission) {
            this.groupPermission(groupPermission == null ? null : groupPermission.toString());
            return this;
        }

        public final void setGroupPermission(String groupPermission) {
            this.groupPermission = groupPermission;
        }

        @Override
        public ResourceDownloadOwnerSetting build() {
            return new ResourceDownloadOwnerSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
