/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration settings for running telemetry.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<TelemetryConfigurationUpdate.Builder, TelemetryConfigurationUpdate> {
    private static final SdkField<String> TELEMETRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telemetry").getter(getter(TelemetryConfigurationUpdate::telemetryAsString))
            .setter(setter(Builder::telemetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telemetry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String telemetry;

    private TelemetryConfigurationUpdate(BuilderImpl builder) {
        this.telemetry = builder.telemetry;
    }

    /**
     * Configure telemetry to be on or off.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telemetry} will
     * return {@link Telemetry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telemetryAsString}.
     * </p>
     * 
     * @return Configure telemetry to be on or off.
     * @see Telemetry
     */
    public Telemetry telemetry() {
        return Telemetry.fromValue(telemetry);
    }

    /**
     * Configure telemetry to be on or off.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telemetry} will
     * return {@link Telemetry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telemetryAsString}.
     * </p>
     * 
     * @return Configure telemetry to be on or off.
     * @see Telemetry
     */
    public String telemetryAsString() {
        return telemetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(telemetryAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryConfigurationUpdate)) {
            return false;
        }
        TelemetryConfigurationUpdate other = (TelemetryConfigurationUpdate) obj;
        return Objects.equals(telemetryAsString(), other.telemetryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TelemetryConfigurationUpdate").add("Telemetry", telemetryAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Telemetry":
            return Optional.ofNullable(clazz.cast(telemetryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TelemetryConfigurationUpdate, T> g) {
        return obj -> g.apply((TelemetryConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryConfigurationUpdate> {
        /**
         * Configure telemetry to be on or off.
         * 
         * @param telemetry
         *        Configure telemetry to be on or off.
         * @see Telemetry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Telemetry
         */
        Builder telemetry(String telemetry);

        /**
         * Configure telemetry to be on or off.
         * 
         * @param telemetry
         *        Configure telemetry to be on or off.
         * @see Telemetry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Telemetry
         */
        Builder telemetry(Telemetry telemetry);
    }

    static final class BuilderImpl implements Builder {
        private String telemetry;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryConfigurationUpdate model) {
            telemetry(model.telemetry);
        }

        public final String getTelemetry() {
            return telemetry;
        }

        @Override
        public final Builder telemetry(String telemetry) {
            this.telemetry = telemetry;
            return this;
        }

        @Override
        public final Builder telemetry(Telemetry telemetry) {
            this.telemetry(telemetry == null ? null : telemetry.toString());
            return this;
        }

        public final void setTelemetry(String telemetry) {
            this.telemetry = telemetry;
        }

        @Override
        public TelemetryConfigurationUpdate build() {
            return new TelemetryConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
