/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, CreateDeploymentResponse> {
    private static final SdkField<String> DEPLOYMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentArn").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::deploymentArn)).setter(CreateDeploymentResponse.setter(Builder::deploymentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentArn").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::deploymentId)).setter(CreateDeploymentResponse.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ARN_FIELD, DEPLOYMENT_ID_FIELD));
    private final String deploymentArn;
    private final String deploymentId;

    private CreateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentArn = builder.deploymentArn;
        this.deploymentId = builder.deploymentId;
    }

    public final String deploymentArn() {
        return this.deploymentArn;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse)((Object)obj);
        return Objects.equals(this.deploymentArn(), other.deploymentArn()) && Objects.equals(this.deploymentId(), other.deploymentId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentResponse").add("DeploymentArn", (Object)this.deploymentArn()).add("DeploymentId", (Object)this.deploymentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentArn": {
                return Optional.ofNullable(clazz.cast(this.deploymentArn()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentResponse, T> g) {
        return obj -> g.apply((CreateDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String deploymentArn;
        private String deploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            super(model);
            this.deploymentArn(model.deploymentArn);
            this.deploymentId(model.deploymentId);
        }

        public final String getDeploymentArn() {
            return this.deploymentArn;
        }

        @Override
        public final Builder deploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
            return this;
        }

        public final void setDeploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentResponse> {
        public Builder deploymentArn(String var1);

        public Builder deploymentId(String var1);
    }
}

