/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Relevant metrics on input records processed during bulk deployment.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkDeploymentMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<BulkDeploymentMetrics.Builder, BulkDeploymentMetrics> {
    private static final SdkField<Integer> INVALID_INPUT_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InvalidInputRecords").getter(getter(BulkDeploymentMetrics::invalidInputRecords))
            .setter(setter(Builder::invalidInputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidInputRecords").build())
            .build();

    private static final SdkField<Integer> RECORDS_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecordsProcessed").getter(getter(BulkDeploymentMetrics::recordsProcessed))
            .setter(setter(Builder::recordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()).build();

    private static final SdkField<Integer> RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryAttempts").getter(getter(BulkDeploymentMetrics::retryAttempts))
            .setter(setter(Builder::retryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttempts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_INPUT_RECORDS_FIELD,
            RECORDS_PROCESSED_FIELD, RETRY_ATTEMPTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer invalidInputRecords;

    private final Integer recordsProcessed;

    private final Integer retryAttempts;

    private BulkDeploymentMetrics(BuilderImpl builder) {
        this.invalidInputRecords = builder.invalidInputRecords;
        this.recordsProcessed = builder.recordsProcessed;
        this.retryAttempts = builder.retryAttempts;
    }

    /**
     * The total number of records that returned a non-retryable error. For example, this can occur if a group record
     * from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role
     * doesn't grant permission to deploy a group or group version.
     * 
     * @return The total number of records that returned a non-retryable error. For example, this can occur if a group
     *         record from the input file uses an invalid format or specifies a nonexistent group version, or if the
     *         execution role doesn't grant permission to deploy a group or group version.
     */
    public final Integer invalidInputRecords() {
        return invalidInputRecords;
    }

    /**
     * The total number of group records from the input file that have been processed so far, or attempted.
     * 
     * @return The total number of group records from the input file that have been processed so far, or attempted.
     */
    public final Integer recordsProcessed() {
        return recordsProcessed;
    }

    /**
     * The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the
     * attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to
     * five times.
     * 
     * @return The total number of deployment attempts that returned a retryable error. For example, a retry is
     *         triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a
     *         group deployment up to five times.
     */
    public final Integer retryAttempts() {
        return retryAttempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invalidInputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(retryAttempts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkDeploymentMetrics)) {
            return false;
        }
        BulkDeploymentMetrics other = (BulkDeploymentMetrics) obj;
        return Objects.equals(invalidInputRecords(), other.invalidInputRecords())
                && Objects.equals(recordsProcessed(), other.recordsProcessed())
                && Objects.equals(retryAttempts(), other.retryAttempts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BulkDeploymentMetrics").add("InvalidInputRecords", invalidInputRecords())
                .add("RecordsProcessed", recordsProcessed()).add("RetryAttempts", retryAttempts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvalidInputRecords":
            return Optional.ofNullable(clazz.cast(invalidInputRecords()));
        case "RecordsProcessed":
            return Optional.ofNullable(clazz.cast(recordsProcessed()));
        case "RetryAttempts":
            return Optional.ofNullable(clazz.cast(retryAttempts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkDeploymentMetrics, T> g) {
        return obj -> g.apply((BulkDeploymentMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkDeploymentMetrics> {
        /**
         * The total number of records that returned a non-retryable error. For example, this can occur if a group
         * record from the input file uses an invalid format or specifies a nonexistent group version, or if the
         * execution role doesn't grant permission to deploy a group or group version.
         * 
         * @param invalidInputRecords
         *        The total number of records that returned a non-retryable error. For example, this can occur if a
         *        group record from the input file uses an invalid format or specifies a nonexistent group version, or
         *        if the execution role doesn't grant permission to deploy a group or group version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidInputRecords(Integer invalidInputRecords);

        /**
         * The total number of group records from the input file that have been processed so far, or attempted.
         * 
         * @param recordsProcessed
         *        The total number of group records from the input file that have been processed so far, or attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsProcessed(Integer recordsProcessed);

        /**
         * The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if
         * the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment
         * up to five times.
         * 
         * @param retryAttempts
         *        The total number of deployment attempts that returned a retryable error. For example, a retry is
         *        triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries
         *        a group deployment up to five times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAttempts(Integer retryAttempts);
    }

    static final class BuilderImpl implements Builder {
        private Integer invalidInputRecords;

        private Integer recordsProcessed;

        private Integer retryAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkDeploymentMetrics model) {
            invalidInputRecords(model.invalidInputRecords);
            recordsProcessed(model.recordsProcessed);
            retryAttempts(model.retryAttempts);
        }

        public final Integer getInvalidInputRecords() {
            return invalidInputRecords;
        }

        @Override
        public final Builder invalidInputRecords(Integer invalidInputRecords) {
            this.invalidInputRecords = invalidInputRecords;
            return this;
        }

        public final void setInvalidInputRecords(Integer invalidInputRecords) {
            this.invalidInputRecords = invalidInputRecords;
        }

        public final Integer getRecordsProcessed() {
            return recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Integer recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final void setRecordsProcessed(Integer recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        public final Integer getRetryAttempts() {
            return retryAttempts;
        }

        @Override
        public final Builder retryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public final void setRetryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
        }

        @Override
        public BulkDeploymentMetrics build() {
            return new BulkDeploymentMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
