/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.Function;
import software.amazon.awssdk.services.greengrass.model.FunctionDefaultConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.___listOfFunctionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFunctionDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmznClientToken").getter(CreateFunctionDefinitionVersionRequest.getter(CreateFunctionDefinitionVersionRequest::amznClientToken)).setter(CreateFunctionDefinitionVersionRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<FunctionDefaultConfig> DEFAULT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultConfig").getter(CreateFunctionDefinitionVersionRequest.getter(CreateFunctionDefinitionVersionRequest::defaultConfig)).setter(CreateFunctionDefinitionVersionRequest.setter(Builder::defaultConfig)).constructor(FunctionDefaultConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConfig").build()}).build();
    private static final SdkField<String> FUNCTION_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionDefinitionId").getter(CreateFunctionDefinitionVersionRequest.getter(CreateFunctionDefinitionVersionRequest::functionDefinitionId)).setter(CreateFunctionDefinitionVersionRequest.setter(Builder::functionDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionDefinitionId").build()}).build();
    private static final SdkField<List<Function>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Functions").getter(CreateFunctionDefinitionVersionRequest.getter(CreateFunctionDefinitionVersionRequest::functions)).setter(CreateFunctionDefinitionVersionRequest.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Functions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Function::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, DEFAULT_CONFIG_FIELD, FUNCTION_DEFINITION_ID_FIELD, FUNCTIONS_FIELD));
    private final String amznClientToken;
    private final FunctionDefaultConfig defaultConfig;
    private final String functionDefinitionId;
    private final List<Function> functions;

    private CreateFunctionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.defaultConfig = builder.defaultConfig;
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functions = builder.functions;
    }

    public final String amznClientToken() {
        return this.amznClientToken;
    }

    public final FunctionDefaultConfig defaultConfig() {
        return this.defaultConfig;
    }

    public final String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructList);
    }

    public final List<Function> functions() {
        return this.functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionDefinitionVersionRequest)) {
            return false;
        }
        CreateFunctionDefinitionVersionRequest other = (CreateFunctionDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.defaultConfig(), other.defaultConfig()) && Objects.equals(this.functionDefinitionId(), other.functionDefinitionId()) && this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFunctionDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("DefaultConfig", (Object)this.defaultConfig()).add("FunctionDefinitionId", (Object)this.functionDefinitionId()).add("Functions", this.hasFunctions() ? this.functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "DefaultConfig": {
                return Optional.ofNullable(clazz.cast(this.defaultConfig()));
            }
            case "FunctionDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.functionDefinitionId()));
            }
            case "Functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<CreateFunctionDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateFunctionDefinitionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private FunctionDefaultConfig defaultConfig;
        private String functionDefinitionId;
        private List<Function> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.defaultConfig(model.defaultConfig);
            this.functionDefinitionId(model.functionDefinitionId);
            this.functions(model.functions);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final FunctionDefaultConfig.Builder getDefaultConfig() {
            return this.defaultConfig != null ? this.defaultConfig.toBuilder() : null;
        }

        @Override
        public final Builder defaultConfig(FunctionDefaultConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public final void setDefaultConfig(FunctionDefaultConfig.BuilderImpl defaultConfig) {
            this.defaultConfig = defaultConfig != null ? defaultConfig.build() : null;
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final Collection<Function.Builder> getFunctions() {
            if (this.functions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functions != null ? (Collection)this.functions.stream().map(Function::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ___listOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<Function.Builder> ... functions) {
            this.functions(Stream.of(functions).map(c -> (Function)((Function.Builder)Function.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            this.functions = ___listOfFunctionCopier.copyFromBuilder(functions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionDefinitionVersionRequest build() {
            return new CreateFunctionDefinitionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder defaultConfig(FunctionDefaultConfig var1);

        default public Builder defaultConfig(Consumer<FunctionDefaultConfig.Builder> defaultConfig) {
            return this.defaultConfig((FunctionDefaultConfig)((FunctionDefaultConfig.Builder)FunctionDefaultConfig.builder().applyMutation(defaultConfig)).build());
        }

        public Builder functionDefinitionId(String var1);

        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);

        public Builder functions(Consumer<Function.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

