/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateSubscriptionDefinitionRequest.Builder, CreateSubscriptionDefinitionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmznClientToken").getter(getter(CreateSubscriptionDefinitionRequest::amznClientToken))
            .setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<SubscriptionDefinitionVersion> INITIAL_VERSION_FIELD = SdkField
            .<SubscriptionDefinitionVersion> builder(MarshallingType.SDK_POJO).memberName("InitialVersion")
            .getter(getter(CreateSubscriptionDefinitionRequest::initialVersion)).setter(setter(Builder::initialVersion))
            .constructor(SubscriptionDefinitionVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSubscriptionDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSubscriptionDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            INITIAL_VERSION_FIELD, NAME_FIELD, TAGS_FIELD));

    private final String amznClientToken;

    private final SubscriptionDefinitionVersion initialVersion;

    private final String name;

    private final Map<String, String> tags;

    private CreateSubscriptionDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.initialVersion = builder.initialVersion;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public final String amznClientToken() {
        return amznClientToken;
    }

    /**
     * Information about the initial version of the subscription definition.
     * 
     * @return Information about the initial version of the subscription definition.
     */
    public final SubscriptionDefinitionVersion initialVersion() {
        return initialVersion;
    }

    /**
     * The name of the subscription definition.
     * 
     * @return The name of the subscription definition.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Tag(s) to add to the new resource.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tag(s) to add to the new resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(initialVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionDefinitionRequest)) {
            return false;
        }
        CreateSubscriptionDefinitionRequest other = (CreateSubscriptionDefinitionRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(initialVersion(), other.initialVersion()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionDefinitionRequest").add("AmznClientToken", amznClientToken())
                .add("InitialVersion", initialVersion()).add("Name", name()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "InitialVersion":
            return Optional.ofNullable(clazz.cast(initialVersion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionDefinitionRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSubscriptionDefinitionRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * Information about the initial version of the subscription definition.
         * 
         * @param initialVersion
         *        Information about the initial version of the subscription definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialVersion(SubscriptionDefinitionVersion initialVersion);

        /**
         * Information about the initial version of the subscription definition. This is a convenience that creates an
         * instance of the {@link SubscriptionDefinitionVersion.Builder} avoiding the need to create one manually via
         * {@link SubscriptionDefinitionVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubscriptionDefinitionVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #initialVersion(SubscriptionDefinitionVersion)}.
         * 
         * @param initialVersion
         *        a consumer that will call methods on {@link SubscriptionDefinitionVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialVersion(SubscriptionDefinitionVersion)
         */
        default Builder initialVersion(Consumer<SubscriptionDefinitionVersion.Builder> initialVersion) {
            return initialVersion(SubscriptionDefinitionVersion.builder().applyMutation(initialVersion).build());
        }

        /**
         * The name of the subscription definition.
         * 
         * @param name
         *        The name of the subscription definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Tag(s) to add to the new resource.
         * 
         * @param tags
         *        Tag(s) to add to the new resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private SubscriptionDefinitionVersion initialVersion;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionDefinitionRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            initialVersion(model.initialVersion);
            name(model.name);
            tags(model.tags);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final SubscriptionDefinitionVersion.Builder getInitialVersion() {
            return initialVersion != null ? initialVersion.toBuilder() : null;
        }

        @Override
        public final Builder initialVersion(SubscriptionDefinitionVersion initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        public final void setInitialVersion(SubscriptionDefinitionVersion.BuilderImpl initialVersion) {
            this.initialVersion = initialVersion != null ? initialVersion.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionDefinitionRequest build() {
            return new CreateSubscriptionDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
