/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Details about the error.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorDetail implements SdkPojo, Serializable, ToCopyableBuilder<ErrorDetail.Builder, ErrorDetail> {
    private static final SdkField<String> DETAILED_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedErrorCode").getter(getter(ErrorDetail::detailedErrorCode))
            .setter(setter(Builder::detailedErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedErrorCode").build()).build();

    private static final SdkField<String> DETAILED_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedErrorMessage").getter(getter(ErrorDetail::detailedErrorMessage))
            .setter(setter(Builder::detailedErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedErrorMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_ERROR_CODE_FIELD,
            DETAILED_ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailedErrorCode;

    private final String detailedErrorMessage;

    private ErrorDetail(BuilderImpl builder) {
        this.detailedErrorCode = builder.detailedErrorCode;
        this.detailedErrorMessage = builder.detailedErrorMessage;
    }

    /**
     * A detailed error code.
     * 
     * @return A detailed error code.
     */
    public final String detailedErrorCode() {
        return detailedErrorCode;
    }

    /**
     * A detailed error message.
     * 
     * @return A detailed error message.
     */
    public final String detailedErrorMessage() {
        return detailedErrorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(detailedErrorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetail)) {
            return false;
        }
        ErrorDetail other = (ErrorDetail) obj;
        return Objects.equals(detailedErrorCode(), other.detailedErrorCode())
                && Objects.equals(detailedErrorMessage(), other.detailedErrorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorDetail").add("DetailedErrorCode", detailedErrorCode())
                .add("DetailedErrorMessage", detailedErrorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailedErrorCode":
            return Optional.ofNullable(clazz.cast(detailedErrorCode()));
        case "DetailedErrorMessage":
            return Optional.ofNullable(clazz.cast(detailedErrorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorDetail, T> g) {
        return obj -> g.apply((ErrorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorDetail> {
        /**
         * A detailed error code.
         * 
         * @param detailedErrorCode
         *        A detailed error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedErrorCode(String detailedErrorCode);

        /**
         * A detailed error message.
         * 
         * @param detailedErrorMessage
         *        A detailed error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedErrorMessage(String detailedErrorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String detailedErrorCode;

        private String detailedErrorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorDetail model) {
            detailedErrorCode(model.detailedErrorCode);
            detailedErrorMessage(model.detailedErrorMessage);
        }

        public final String getDetailedErrorCode() {
            return detailedErrorCode;
        }

        @Override
        public final Builder detailedErrorCode(String detailedErrorCode) {
            this.detailedErrorCode = detailedErrorCode;
            return this;
        }

        public final void setDetailedErrorCode(String detailedErrorCode) {
            this.detailedErrorCode = detailedErrorCode;
        }

        public final String getDetailedErrorMessage() {
            return detailedErrorMessage;
        }

        @Override
        public final Builder detailedErrorMessage(String detailedErrorMessage) {
            this.detailedErrorMessage = detailedErrorMessage;
            return this;
        }

        public final void setDetailedErrorMessage(String detailedErrorMessage) {
            this.detailedErrorMessage = detailedErrorMessage;
        }

        @Override
        public ErrorDetail build() {
            return new ErrorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
