/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBulkDeploymentsResponse extends GreengrassResponse implements
        ToCopyableBuilder<ListBulkDeploymentsResponse.Builder, ListBulkDeploymentsResponse> {
    private static final SdkField<List<BulkDeployment>> BULK_DEPLOYMENTS_FIELD = SdkField
            .<List<BulkDeployment>> builder(MarshallingType.LIST)
            .memberName("BulkDeployments")
            .getter(getter(ListBulkDeploymentsResponse::bulkDeployments))
            .setter(setter(Builder::bulkDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkDeployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BulkDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(BulkDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBulkDeploymentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BulkDeployment> bulkDeployments;

    private final String nextToken;

    private ListBulkDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.bulkDeployments = builder.bulkDeployments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BulkDeployments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBulkDeployments() {
        return bulkDeployments != null && !(bulkDeployments instanceof SdkAutoConstructList);
    }

    /**
     * A list of bulk deployments.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBulkDeployments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of bulk deployments.
     */
    public final List<BulkDeployment> bulkDeployments() {
        return bulkDeployments;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBulkDeployments() ? bulkDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBulkDeploymentsResponse)) {
            return false;
        }
        ListBulkDeploymentsResponse other = (ListBulkDeploymentsResponse) obj;
        return hasBulkDeployments() == other.hasBulkDeployments() && Objects.equals(bulkDeployments(), other.bulkDeployments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBulkDeploymentsResponse")
                .add("BulkDeployments", hasBulkDeployments() ? bulkDeployments() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BulkDeployments":
            return Optional.ofNullable(clazz.cast(bulkDeployments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBulkDeploymentsResponse, T> g) {
        return obj -> g.apply((ListBulkDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBulkDeploymentsResponse> {
        /**
         * A list of bulk deployments.
         * 
         * @param bulkDeployments
         *        A list of bulk deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeployments(Collection<BulkDeployment> bulkDeployments);

        /**
         * A list of bulk deployments.
         * 
         * @param bulkDeployments
         *        A list of bulk deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeployments(BulkDeployment... bulkDeployments);

        /**
         * A list of bulk deployments. This is a convenience that creates an instance of the {@link List
         * <BulkDeployment>.Builder} avoiding the need to create one manually via {@link List<BulkDeployment>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<BulkDeployment>.Builder#build()} is called immediately and
         * its result is passed to {@link #bulkDeployments(List<BulkDeployment>)}.
         * 
         * @param bulkDeployments
         *        a consumer that will call methods on {@link List<BulkDeployment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bulkDeployments(List<BulkDeployment>)
         */
        Builder bulkDeployments(Consumer<BulkDeployment.Builder>... bulkDeployments);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private List<BulkDeployment> bulkDeployments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBulkDeploymentsResponse model) {
            super(model);
            bulkDeployments(model.bulkDeployments);
            nextToken(model.nextToken);
        }

        public final Collection<BulkDeployment.Builder> getBulkDeployments() {
            if (bulkDeployments instanceof SdkAutoConstructList) {
                return null;
            }
            return bulkDeployments != null ? bulkDeployments.stream().map(BulkDeployment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder bulkDeployments(Collection<BulkDeployment> bulkDeployments) {
            this.bulkDeployments = BulkDeploymentsCopier.copy(bulkDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkDeployments(BulkDeployment... bulkDeployments) {
            bulkDeployments(Arrays.asList(bulkDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkDeployments(Consumer<BulkDeployment.Builder>... bulkDeployments) {
            bulkDeployments(Stream.of(bulkDeployments).map(c -> BulkDeployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBulkDeployments(Collection<BulkDeployment.BuilderImpl> bulkDeployments) {
            this.bulkDeployments = BulkDeploymentsCopier.copyFromBuilder(bulkDeployments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBulkDeploymentsResponse build() {
            return new ListBulkDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
