/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration information that specifies how a Lambda function runs.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionExecutionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionExecutionConfig.Builder, FunctionExecutionConfig> {
    private static final SdkField<String> ISOLATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsolationMode").getter(getter(FunctionExecutionConfig::isolationModeAsString))
            .setter(setter(Builder::isolationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolationMode").build()).build();

    private static final SdkField<FunctionRunAsConfig> RUN_AS_FIELD = SdkField
            .<FunctionRunAsConfig> builder(MarshallingType.SDK_POJO).memberName("RunAs")
            .getter(getter(FunctionExecutionConfig::runAs)).setter(setter(Builder::runAs))
            .constructor(FunctionRunAsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISOLATION_MODE_FIELD,
            RUN_AS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String isolationMode;

    private final FunctionRunAsConfig runAs;

    private FunctionExecutionConfig(BuilderImpl builder) {
        this.isolationMode = builder.isolationMode;
        this.runAs = builder.runAs;
    }

    /**
     * Returns the value of the IsolationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isolationMode}
     * will return {@link FunctionIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #isolationModeAsString}.
     * </p>
     * 
     * @return The value of the IsolationMode property for this object.
     * @see FunctionIsolationMode
     */
    public final FunctionIsolationMode isolationMode() {
        return FunctionIsolationMode.fromValue(isolationMode);
    }

    /**
     * Returns the value of the IsolationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isolationMode}
     * will return {@link FunctionIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #isolationModeAsString}.
     * </p>
     * 
     * @return The value of the IsolationMode property for this object.
     * @see FunctionIsolationMode
     */
    public final String isolationModeAsString() {
        return isolationMode;
    }

    /**
     * Returns the value of the RunAs property for this object.
     * 
     * @return The value of the RunAs property for this object.
     */
    public final FunctionRunAsConfig runAs() {
        return runAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isolationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runAs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionExecutionConfig)) {
            return false;
        }
        FunctionExecutionConfig other = (FunctionExecutionConfig) obj;
        return Objects.equals(isolationModeAsString(), other.isolationModeAsString()) && Objects.equals(runAs(), other.runAs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionExecutionConfig").add("IsolationMode", isolationModeAsString()).add("RunAs", runAs())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsolationMode":
            return Optional.ofNullable(clazz.cast(isolationModeAsString()));
        case "RunAs":
            return Optional.ofNullable(clazz.cast(runAs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionExecutionConfig, T> g) {
        return obj -> g.apply((FunctionExecutionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionExecutionConfig> {
        /**
         * Sets the value of the IsolationMode property for this object.
         *
         * @param isolationMode
         *        The new value for the IsolationMode property for this object.
         * @see FunctionIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionIsolationMode
         */
        Builder isolationMode(String isolationMode);

        /**
         * Sets the value of the IsolationMode property for this object.
         *
         * @param isolationMode
         *        The new value for the IsolationMode property for this object.
         * @see FunctionIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionIsolationMode
         */
        Builder isolationMode(FunctionIsolationMode isolationMode);

        /**
         * Sets the value of the RunAs property for this object.
         *
         * @param runAs
         *        The new value for the RunAs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runAs(FunctionRunAsConfig runAs);

        /**
         * Sets the value of the RunAs property for this object.
         *
         * This is a convenience that creates an instance of the {@link FunctionRunAsConfig.Builder} avoiding the need
         * to create one manually via {@link FunctionRunAsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionRunAsConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #runAs(FunctionRunAsConfig)}.
         * 
         * @param runAs
         *        a consumer that will call methods on {@link FunctionRunAsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runAs(FunctionRunAsConfig)
         */
        default Builder runAs(Consumer<FunctionRunAsConfig.Builder> runAs) {
            return runAs(FunctionRunAsConfig.builder().applyMutation(runAs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String isolationMode;

        private FunctionRunAsConfig runAs;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionExecutionConfig model) {
            isolationMode(model.isolationMode);
            runAs(model.runAs);
        }

        public final String getIsolationMode() {
            return isolationMode;
        }

        @Override
        public final Builder isolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
            return this;
        }

        @Override
        public final Builder isolationMode(FunctionIsolationMode isolationMode) {
            this.isolationMode(isolationMode == null ? null : isolationMode.toString());
            return this;
        }

        public final void setIsolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
        }

        public final FunctionRunAsConfig.Builder getRunAs() {
            return runAs != null ? runAs.toBuilder() : null;
        }

        @Override
        public final Builder runAs(FunctionRunAsConfig runAs) {
            this.runAs = runAs;
            return this;
        }

        public final void setRunAs(FunctionRunAsConfig.BuilderImpl runAs) {
            this.runAs = runAs != null ? runAs.build() : null;
        }

        @Override
        public FunctionExecutionConfig build() {
            return new FunctionExecutionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
