/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a certificate authority for a group.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupCertificateAuthorityProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupCertificateAuthorityProperties.Builder, GroupCertificateAuthorityProperties> {
    private static final SdkField<String> GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupCertificateAuthorityArn")
            .getter(getter(GroupCertificateAuthorityProperties::groupCertificateAuthorityArn))
            .setter(setter(Builder::groupCertificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupCertificateAuthorityArn")
                    .build()).build();

    private static final SdkField<String> GROUP_CERTIFICATE_AUTHORITY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupCertificateAuthorityId")
            .getter(getter(GroupCertificateAuthorityProperties::groupCertificateAuthorityId))
            .setter(setter(Builder::groupCertificateAuthorityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupCertificateAuthorityId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD, GROUP_CERTIFICATE_AUTHORITY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupCertificateAuthorityArn;

    private final String groupCertificateAuthorityId;

    private GroupCertificateAuthorityProperties(BuilderImpl builder) {
        this.groupCertificateAuthorityArn = builder.groupCertificateAuthorityArn;
        this.groupCertificateAuthorityId = builder.groupCertificateAuthorityId;
    }

    /**
     * The ARN of the certificate authority for the group.
     * 
     * @return The ARN of the certificate authority for the group.
     */
    public final String groupCertificateAuthorityArn() {
        return groupCertificateAuthorityArn;
    }

    /**
     * The ID of the certificate authority for the group.
     * 
     * @return The ID of the certificate authority for the group.
     */
    public final String groupCertificateAuthorityId() {
        return groupCertificateAuthorityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupCertificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(groupCertificateAuthorityId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupCertificateAuthorityProperties)) {
            return false;
        }
        GroupCertificateAuthorityProperties other = (GroupCertificateAuthorityProperties) obj;
        return Objects.equals(groupCertificateAuthorityArn(), other.groupCertificateAuthorityArn())
                && Objects.equals(groupCertificateAuthorityId(), other.groupCertificateAuthorityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupCertificateAuthorityProperties")
                .add("GroupCertificateAuthorityArn", groupCertificateAuthorityArn())
                .add("GroupCertificateAuthorityId", groupCertificateAuthorityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupCertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(groupCertificateAuthorityArn()));
        case "GroupCertificateAuthorityId":
            return Optional.ofNullable(clazz.cast(groupCertificateAuthorityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupCertificateAuthorityProperties, T> g) {
        return obj -> g.apply((GroupCertificateAuthorityProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupCertificateAuthorityProperties> {
        /**
         * The ARN of the certificate authority for the group.
         * 
         * @param groupCertificateAuthorityArn
         *        The ARN of the certificate authority for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorityArn(String groupCertificateAuthorityArn);

        /**
         * The ID of the certificate authority for the group.
         * 
         * @param groupCertificateAuthorityId
         *        The ID of the certificate authority for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorityId(String groupCertificateAuthorityId);
    }

    static final class BuilderImpl implements Builder {
        private String groupCertificateAuthorityArn;

        private String groupCertificateAuthorityId;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupCertificateAuthorityProperties model) {
            groupCertificateAuthorityArn(model.groupCertificateAuthorityArn);
            groupCertificateAuthorityId(model.groupCertificateAuthorityId);
        }

        public final String getGroupCertificateAuthorityArn() {
            return groupCertificateAuthorityArn;
        }

        @Override
        public final Builder groupCertificateAuthorityArn(String groupCertificateAuthorityArn) {
            this.groupCertificateAuthorityArn = groupCertificateAuthorityArn;
            return this;
        }

        public final void setGroupCertificateAuthorityArn(String groupCertificateAuthorityArn) {
            this.groupCertificateAuthorityArn = groupCertificateAuthorityArn;
        }

        public final String getGroupCertificateAuthorityId() {
            return groupCertificateAuthorityId;
        }

        @Override
        public final Builder groupCertificateAuthorityId(String groupCertificateAuthorityId) {
            this.groupCertificateAuthorityId = groupCertificateAuthorityId;
            return this;
        }

        public final void setGroupCertificateAuthorityId(String groupCertificateAuthorityId) {
            this.groupCertificateAuthorityId = groupCertificateAuthorityId;
        }

        @Override
        public GroupCertificateAuthorityProperties build() {
            return new GroupCertificateAuthorityProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
