/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateConnectorDefinitionVersionRequest.Builder, CreateConnectorDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmznClientToken").getter(getter(CreateConnectorDefinitionVersionRequest::amznClientToken))
            .setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<String> CONNECTOR_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDefinitionId").getter(getter(CreateConnectorDefinitionVersionRequest::connectorDefinitionId))
            .setter(setter(Builder::connectorDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorDefinitionId").build())
            .build();

    private static final SdkField<List<Connector>> CONNECTORS_FIELD = SdkField
            .<List<Connector>> builder(MarshallingType.LIST)
            .memberName("Connectors")
            .getter(getter(CreateConnectorDefinitionVersionRequest::connectors))
            .setter(setter(Builder::connectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Connector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Connector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            CONNECTOR_DEFINITION_ID_FIELD, CONNECTORS_FIELD));

    private final String amznClientToken;

    private final String connectorDefinitionId;

    private final List<Connector> connectors;

    private CreateConnectorDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.connectorDefinitionId = builder.connectorDefinitionId;
        this.connectors = builder.connectors;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public final String amznClientToken() {
        return amznClientToken;
    }

    /**
     * The ID of the connector definition.
     * 
     * @return The ID of the connector definition.
     */
    public final String connectorDefinitionId() {
        return connectorDefinitionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConnectors() {
        return connectors != null && !(connectors instanceof SdkAutoConstructList);
    }

    /**
     * A list of references to connectors in this version, with their corresponding configuration settings.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectors} method.
     * </p>
     * 
     * @return A list of references to connectors in this version, with their corresponding configuration settings.
     */
    public final List<Connector> connectors() {
        return connectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectors() ? connectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorDefinitionVersionRequest)) {
            return false;
        }
        CreateConnectorDefinitionVersionRequest other = (CreateConnectorDefinitionVersionRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(connectorDefinitionId(), other.connectorDefinitionId())
                && hasConnectors() == other.hasConnectors() && Objects.equals(connectors(), other.connectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorDefinitionVersionRequest").add("AmznClientToken", amznClientToken())
                .add("ConnectorDefinitionId", connectorDefinitionId()).add("Connectors", hasConnectors() ? connectors() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "ConnectorDefinitionId":
            return Optional.ofNullable(clazz.cast(connectorDefinitionId()));
        case "Connectors":
            return Optional.ofNullable(clazz.cast(connectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateConnectorDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConnectorDefinitionVersionRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * The ID of the connector definition.
         * 
         * @param connectorDefinitionId
         *        The ID of the connector definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDefinitionId(String connectorDefinitionId);

        /**
         * A list of references to connectors in this version, with their corresponding configuration settings.
         * 
         * @param connectors
         *        A list of references to connectors in this version, with their corresponding configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Collection<Connector> connectors);

        /**
         * A list of references to connectors in this version, with their corresponding configuration settings.
         * 
         * @param connectors
         *        A list of references to connectors in this version, with their corresponding configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Connector... connectors);

        /**
         * A list of references to connectors in this version, with their corresponding configuration settings. This is
         * a convenience method that creates an instance of the {@link List<Connector>.Builder} avoiding the need to
         * create one manually via {@link List<Connector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Connector>.Builder#build()} is called immediately and its
         * result is passed to {@link #connectors(List<Connector>)}.
         * 
         * @param connectors
         *        a consumer that will call methods on {@link List<Connector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectors(List<Connector>)
         */
        Builder connectors(Consumer<Connector.Builder>... connectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private String connectorDefinitionId;

        private List<Connector> connectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorDefinitionVersionRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            connectorDefinitionId(model.connectorDefinitionId);
            connectors(model.connectors);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final String getConnectorDefinitionId() {
            return connectorDefinitionId;
        }

        public final void setConnectorDefinitionId(String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
        }

        @Override
        public final Builder connectorDefinitionId(String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
            return this;
        }

        public final List<Connector.Builder> getConnectors() {
            List<Connector.Builder> result = ___listOfConnectorCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<Connector.BuilderImpl> connectors) {
            this.connectors = ___listOfConnectorCopier.copyFromBuilder(connectors);
        }

        @Override
        public final Builder connectors(Collection<Connector> connectors) {
            this.connectors = ___listOfConnectorCopier.copy(connectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Connector... connectors) {
            connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Consumer<Connector.Builder>... connectors) {
            connectors(Stream.of(connectors).map(c -> Connector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorDefinitionVersionRequest build() {
            return new CreateConnectorDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
