/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateResourceDefinitionVersionRequest.Builder, CreateResourceDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmznClientToken").getter(getter(CreateResourceDefinitionVersionRequest::amznClientToken))
            .setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<String> RESOURCE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceDefinitionId").getter(getter(CreateResourceDefinitionVersionRequest::resourceDefinitionId))
            .setter(setter(Builder::resourceDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceDefinitionId").build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(CreateResourceDefinitionVersionRequest::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            RESOURCE_DEFINITION_ID_FIELD, RESOURCES_FIELD));

    private final String amznClientToken;

    private final String resourceDefinitionId;

    private final List<Resource> resources;

    private CreateResourceDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.resourceDefinitionId = builder.resourceDefinitionId;
        this.resources = builder.resources;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public final String amznClientToken() {
        return amznClientToken;
    }

    /**
     * The ID of the resource definition.
     * 
     * @return The ID of the resource definition.
     */
    public final String resourceDefinitionId() {
        return resourceDefinitionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * A list of resources.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A list of resources.
     */
    public final List<Resource> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDefinitionVersionRequest)) {
            return false;
        }
        CreateResourceDefinitionVersionRequest other = (CreateResourceDefinitionVersionRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(resourceDefinitionId(), other.resourceDefinitionId()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceDefinitionVersionRequest").add("AmznClientToken", amznClientToken())
                .add("ResourceDefinitionId", resourceDefinitionId()).add("Resources", hasResources() ? resources() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "ResourceDefinitionId":
            return Optional.ofNullable(clazz.cast(resourceDefinitionId()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateResourceDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceDefinitionVersionRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * The ID of the resource definition.
         * 
         * @param resourceDefinitionId
         *        The ID of the resource definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDefinitionId(String resourceDefinitionId);

        /**
         * A list of resources.
         * 
         * @param resources
         *        A list of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * A list of resources.
         * 
         * @param resources
         *        A list of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * A list of resources. This is a convenience method that creates an instance of the {@link List
         * <Resource>.Builder} avoiding the need to create one manually via {@link List<Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resource>.Builder#build()} is called immediately and its
         * result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private String resourceDefinitionId;

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDefinitionVersionRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            resourceDefinitionId(model.resourceDefinitionId);
            resources(model.resources);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final String getResourceDefinitionId() {
            return resourceDefinitionId;
        }

        public final void setResourceDefinitionId(String resourceDefinitionId) {
            this.resourceDefinitionId = resourceDefinitionId;
        }

        @Override
        public final Builder resourceDefinitionId(String resourceDefinitionId) {
            this.resourceDefinitionId = resourceDefinitionId;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ___listOfResourceCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ___listOfResourceCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ___listOfResourceCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceDefinitionVersionRequest build() {
            return new CreateResourceDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
