/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentStatusResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetDeploymentStatusResponse.Builder, GetDeploymentStatusResponse> {
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(GetDeploymentStatusResponse::deploymentStatus))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(GetDeploymentStatusResponse::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .memberName("ErrorDetails")
            .getter(getter(GetDeploymentStatusResponse::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(GetDeploymentStatusResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(GetDeploymentStatusResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STATUS_FIELD,
            DEPLOYMENT_TYPE_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, UPDATED_AT_FIELD));

    private final String deploymentStatus;

    private final String deploymentType;

    private final List<ErrorDetail> errorDetails;

    private final String errorMessage;

    private final String updatedAt;

    private GetDeploymentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * The status of the deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
     * 
     * @return The status of the deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
     */
    public final String deploymentStatus() {
        return deploymentStatus;
    }

    /**
     * The type of the deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * The type of the deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorDetails() {
        return errorDetails != null && !(errorDetails instanceof SdkAutoConstructList);
    }

    /**
     * Error details
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorDetails} method.
     * </p>
     * 
     * @return Error details
     */
    public final List<ErrorDetail> errorDetails() {
        return errorDetails;
    }

    /**
     * Error message
     * 
     * @return Error message
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * The time, in milliseconds since the epoch, when the deployment status was updated.
     * 
     * @return The time, in milliseconds since the epoch, when the deployment status was updated.
     */
    public final String updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorDetails() ? errorDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentStatusResponse)) {
            return false;
        }
        GetDeploymentStatusResponse other = (GetDeploymentStatusResponse) obj;
        return Objects.equals(deploymentStatus(), other.deploymentStatus())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && hasErrorDetails() == other.hasErrorDetails() && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentStatusResponse").add("DeploymentStatus", deploymentStatus())
                .add("DeploymentType", deploymentTypeAsString()).add("ErrorDetails", hasErrorDetails() ? errorDetails() : null)
                .add("ErrorMessage", errorMessage()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentStatusResponse, T> g) {
        return obj -> g.apply((GetDeploymentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentStatusResponse> {
        /**
         * The status of the deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
         * 
         * @param deploymentStatus
         *        The status of the deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * The type of the deployment.
         * 
         * @param deploymentType
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * The type of the deployment.
         * 
         * @param deploymentType
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * Error details
         * 
         * @param errorDetails
         *        Error details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(Collection<ErrorDetail> errorDetails);

        /**
         * Error details
         * 
         * @param errorDetails
         *        Error details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetail... errorDetails);

        /**
         * Error details This is a convenience method that creates an instance of the {@link List<ErrorDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ErrorDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ErrorDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(List<ErrorDetail>)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link List<ErrorDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(List<ErrorDetail>)
         */
        Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails);

        /**
         * Error message
         * 
         * @param errorMessage
         *        Error message
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * The time, in milliseconds since the epoch, when the deployment status was updated.
         * 
         * @param updatedAt
         *        The time, in milliseconds since the epoch, when the deployment status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String deploymentStatus;

        private String deploymentType;

        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private String errorMessage;

        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentStatusResponse model) {
            super(model);
            deploymentStatus(model.deploymentStatus);
            deploymentType(model.deploymentType);
            errorDetails(model.errorDetails);
            errorMessage(model.errorMessage);
            updatedAt(model.updatedAt);
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetails() {
            List<ErrorDetail.Builder> result = ErrorDetailsCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail... errorDetails) {
            errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails) {
            errorDetails(Stream.of(errorDetails).map(c -> ErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDeploymentStatusResponse build() {
            return new GetDeploymentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
