/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a logger definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggerDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggerDefinitionVersion.Builder, LoggerDefinitionVersion> {
    private static final SdkField<List<Logger>> LOGGERS_FIELD = SdkField
            .<List<Logger>> builder(MarshallingType.LIST)
            .memberName("Loggers")
            .getter(getter(LoggerDefinitionVersion::loggers))
            .setter(setter(Builder::loggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Loggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Logger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Logger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Logger> loggers;

    private LoggerDefinitionVersion(BuilderImpl builder) {
        this.loggers = builder.loggers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Loggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLoggers() {
        return loggers != null && !(loggers instanceof SdkAutoConstructList);
    }

    /**
     * A list of loggers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoggers} method.
     * </p>
     * 
     * @return A list of loggers.
     */
    public final List<Logger> loggers() {
        return loggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLoggers() ? loggers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggerDefinitionVersion)) {
            return false;
        }
        LoggerDefinitionVersion other = (LoggerDefinitionVersion) obj;
        return hasLoggers() == other.hasLoggers() && Objects.equals(loggers(), other.loggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggerDefinitionVersion").add("Loggers", hasLoggers() ? loggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Loggers":
            return Optional.ofNullable(clazz.cast(loggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggerDefinitionVersion, T> g) {
        return obj -> g.apply((LoggerDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggerDefinitionVersion> {
        /**
         * A list of loggers.
         * 
         * @param loggers
         *        A list of loggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggers(Collection<Logger> loggers);

        /**
         * A list of loggers.
         * 
         * @param loggers
         *        A list of loggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggers(Logger... loggers);

        /**
         * A list of loggers. This is a convenience method that creates an instance of the {@link List<Logger>.Builder}
         * avoiding the need to create one manually via {@link List<Logger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Logger>.Builder#build()} is called immediately and its
         * result is passed to {@link #loggers(List<Logger>)}.
         * 
         * @param loggers
         *        a consumer that will call methods on {@link List<Logger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggers(List<Logger>)
         */
        Builder loggers(Consumer<Logger.Builder>... loggers);
    }

    static final class BuilderImpl implements Builder {
        private List<Logger> loggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggerDefinitionVersion model) {
            loggers(model.loggers);
        }

        public final List<Logger.Builder> getLoggers() {
            List<Logger.Builder> result = ___listOfLoggerCopier.copyToBuilder(this.loggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoggers(Collection<Logger.BuilderImpl> loggers) {
            this.loggers = ___listOfLoggerCopier.copyFromBuilder(loggers);
        }

        @Override
        public final Builder loggers(Collection<Logger> loggers) {
            this.loggers = ___listOfLoggerCopier.copy(loggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Logger... loggers) {
            loggers(Arrays.asList(loggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Consumer<Logger.Builder>... loggers) {
            loggers(Stream.of(loggers).map(c -> Logger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LoggerDefinitionVersion build() {
            return new LoggerDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
