/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a device definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceDefinitionVersion.Builder, DeviceDefinitionVersion> {
    private static final SdkField<List<Device>> DEVICES_FIELD = SdkField
            .<List<Device>> builder(MarshallingType.LIST)
            .memberName("Devices")
            .getter(getter(DeviceDefinitionVersion::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Device> builder(MarshallingType.SDK_POJO)
                                            .constructor(Device::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Device> devices;

    private DeviceDefinitionVersion(BuilderImpl builder) {
        this.devices = builder.devices;
    }

    /**
     * For responses, this returns true if the service returned a value for the Devices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * A list of devices in the definition version.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevices} method.
     * </p>
     * 
     * @return A list of devices in the definition version.
     */
    public final List<Device> devices() {
        return devices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDefinitionVersion)) {
            return false;
        }
        DeviceDefinitionVersion other = (DeviceDefinitionVersion) obj;
        return hasDevices() == other.hasDevices() && Objects.equals(devices(), other.devices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceDefinitionVersion").add("Devices", hasDevices() ? devices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Devices":
            return Optional.ofNullable(clazz.cast(devices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceDefinitionVersion, T> g) {
        return obj -> g.apply((DeviceDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceDefinitionVersion> {
        /**
         * A list of devices in the definition version.
         * 
         * @param devices
         *        A list of devices in the definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<Device> devices);

        /**
         * A list of devices in the definition version.
         * 
         * @param devices
         *        A list of devices in the definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Device... devices);

        /**
         * A list of devices in the definition version. This is a convenience that creates an instance of the
         * {@link List<Device>.Builder} avoiding the need to create one manually via {@link List<Device>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Device>.Builder#build()} is called immediately and its
         * result is passed to {@link #devices(List<Device>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<Device>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<Device>)
         */
        Builder devices(Consumer<Device.Builder>... devices);
    }

    static final class BuilderImpl implements Builder {
        private List<Device> devices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDefinitionVersion model) {
            devices(model.devices);
        }

        public final List<Device.Builder> getDevices() {
            List<Device.Builder> result = ___listOfDeviceCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = ___listOfDeviceCopier.copyFromBuilder(devices);
        }

        @Override
        @Transient
        public final Builder devices(Collection<Device> devices) {
            this.devices = ___listOfDeviceCopier.copy(devices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder devices(Device... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder devices(Consumer<Device.Builder>... devices) {
            devices(Stream.of(devices).map(c -> Device.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeviceDefinitionVersion build() {
            return new DeviceDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
