/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information needed to create a function definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFunctionDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateFunctionDefinitionVersionRequest.Builder, CreateFunctionDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmznClientToken").getter(getter(CreateFunctionDefinitionVersionRequest::amznClientToken))
            .setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<FunctionDefaultConfig> DEFAULT_CONFIG_FIELD = SdkField
            .<FunctionDefaultConfig> builder(MarshallingType.SDK_POJO).memberName("DefaultConfig")
            .getter(getter(CreateFunctionDefinitionVersionRequest::defaultConfig)).setter(setter(Builder::defaultConfig))
            .constructor(FunctionDefaultConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConfig").build()).build();

    private static final SdkField<String> FUNCTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionDefinitionId").getter(getter(CreateFunctionDefinitionVersionRequest::functionDefinitionId))
            .setter(setter(Builder::functionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionDefinitionId").build()).build();

    private static final SdkField<List<Function>> FUNCTIONS_FIELD = SdkField
            .<List<Function>> builder(MarshallingType.LIST)
            .memberName("Functions")
            .getter(getter(CreateFunctionDefinitionVersionRequest::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Functions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Function> builder(MarshallingType.SDK_POJO)
                                            .constructor(Function::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            DEFAULT_CONFIG_FIELD, FUNCTION_DEFINITION_ID_FIELD, FUNCTIONS_FIELD));

    private final String amznClientToken;

    private final FunctionDefaultConfig defaultConfig;

    private final String functionDefinitionId;

    private final List<Function> functions;

    private CreateFunctionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.defaultConfig = builder.defaultConfig;
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functions = builder.functions;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public final String amznClientToken() {
        return amznClientToken;
    }

    /**
     * The default configuration that applies to all Lambda functions in this function definition version. Individual
     * Lambda functions can override these settings.
     * 
     * @return The default configuration that applies to all Lambda functions in this function definition version.
     *         Individual Lambda functions can override these settings.
     */
    public final FunctionDefaultConfig defaultConfig() {
        return defaultConfig;
    }

    /**
     * The ID of the Lambda function definition.
     * 
     * @return The ID of the Lambda function definition.
     */
    public final String functionDefinitionId() {
        return functionDefinitionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructList);
    }

    /**
     * A list of Lambda functions in this function definition version.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return A list of Lambda functions in this function definition version.
     */
    public final List<Function> functions() {
        return functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(defaultConfig());
        hashCode = 31 * hashCode + Objects.hashCode(functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionDefinitionVersionRequest)) {
            return false;
        }
        CreateFunctionDefinitionVersionRequest other = (CreateFunctionDefinitionVersionRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(defaultConfig(), other.defaultConfig())
                && Objects.equals(functionDefinitionId(), other.functionDefinitionId()) && hasFunctions() == other.hasFunctions()
                && Objects.equals(functions(), other.functions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFunctionDefinitionVersionRequest").add("AmznClientToken", amznClientToken())
                .add("DefaultConfig", defaultConfig()).add("FunctionDefinitionId", functionDefinitionId())
                .add("Functions", hasFunctions() ? functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "DefaultConfig":
            return Optional.ofNullable(clazz.cast(defaultConfig()));
        case "FunctionDefinitionId":
            return Optional.ofNullable(clazz.cast(functionDefinitionId()));
        case "Functions":
            return Optional.ofNullable(clazz.cast(functions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> java.util.function.Function<Object, T> getter(
            java.util.function.Function<CreateFunctionDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateFunctionDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * The default configuration that applies to all Lambda functions in this function definition version.
         * Individual Lambda functions can override these settings.
         * 
         * @param defaultConfig
         *        The default configuration that applies to all Lambda functions in this function definition version.
         *        Individual Lambda functions can override these settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultConfig(FunctionDefaultConfig defaultConfig);

        /**
         * The default configuration that applies to all Lambda functions in this function definition version.
         * Individual Lambda functions can override these settings. This is a convenience that creates an instance of
         * the {@link FunctionDefaultConfig.Builder} avoiding the need to create one manually via
         * {@link FunctionDefaultConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionDefaultConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultConfig(FunctionDefaultConfig)}.
         * 
         * @param defaultConfig
         *        a consumer that will call methods on {@link FunctionDefaultConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultConfig(FunctionDefaultConfig)
         */
        default Builder defaultConfig(Consumer<FunctionDefaultConfig.Builder> defaultConfig) {
            return defaultConfig(FunctionDefaultConfig.builder().applyMutation(defaultConfig).build());
        }

        /**
         * The ID of the Lambda function definition.
         * 
         * @param functionDefinitionId
         *        The ID of the Lambda function definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionDefinitionId(String functionDefinitionId);

        /**
         * A list of Lambda functions in this function definition version.
         * 
         * @param functions
         *        A list of Lambda functions in this function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Collection<Function> functions);

        /**
         * A list of Lambda functions in this function definition version.
         * 
         * @param functions
         *        A list of Lambda functions in this function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Function... functions);

        /**
         * A list of Lambda functions in this function definition version. This is a convenience that creates an
         * instance of the {@link List<Function>.Builder} avoiding the need to create one manually via {@link List
         * <Function>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Function>.Builder#build()} is called immediately and its
         * result is passed to {@link #functions(List<Function>)}.
         * 
         * @param functions
         *        a consumer that will call methods on {@link List<Function>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functions(List<Function>)
         */
        Builder functions(Consumer<Function.Builder>... functions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private FunctionDefaultConfig defaultConfig;

        private String functionDefinitionId;

        private List<Function> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionDefinitionVersionRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            defaultConfig(model.defaultConfig);
            functionDefinitionId(model.functionDefinitionId);
            functions(model.functions);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        @Override
        @Transient
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final FunctionDefaultConfig.Builder getDefaultConfig() {
            return defaultConfig != null ? defaultConfig.toBuilder() : null;
        }

        public final void setDefaultConfig(FunctionDefaultConfig.BuilderImpl defaultConfig) {
            this.defaultConfig = defaultConfig != null ? defaultConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultConfig(FunctionDefaultConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public final String getFunctionDefinitionId() {
            return functionDefinitionId;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        @Override
        @Transient
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final List<Function.Builder> getFunctions() {
            List<Function.Builder> result = ___listOfFunctionCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            this.functions = ___listOfFunctionCopier.copyFromBuilder(functions);
        }

        @Override
        @Transient
        public final Builder functions(Collection<Function> functions) {
            this.functions = ___listOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder functions(Function... functions) {
            functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder functions(Consumer<Function.Builder>... functions) {
            functions(Stream.of(functions).map(c -> Function.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionDefinitionVersionRequest build() {
            return new CreateFunctionDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
