/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetResourceDefinitionRequest.Builder, GetResourceDefinitionRequest> {
    private static final SdkField<String> RESOURCE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceDefinitionId").getter(getter(GetResourceDefinitionRequest::resourceDefinitionId))
            .setter(setter(Builder::resourceDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceDefinitionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DEFINITION_ID_FIELD));

    private final String resourceDefinitionId;

    private GetResourceDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceDefinitionId = builder.resourceDefinitionId;
    }

    /**
     * The ID of the resource definition.
     * 
     * @return The ID of the resource definition.
     */
    public final String resourceDefinitionId() {
        return resourceDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceDefinitionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceDefinitionRequest)) {
            return false;
        }
        GetResourceDefinitionRequest other = (GetResourceDefinitionRequest) obj;
        return Objects.equals(resourceDefinitionId(), other.resourceDefinitionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceDefinitionRequest").add("ResourceDefinitionId", resourceDefinitionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceDefinitionId":
            return Optional.ofNullable(clazz.cast(resourceDefinitionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceDefinitionRequest, T> g) {
        return obj -> g.apply((GetResourceDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceDefinitionRequest> {
        /**
         * The ID of the resource definition.
         * 
         * @param resourceDefinitionId
         *        The ID of the resource definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDefinitionId(String resourceDefinitionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String resourceDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceDefinitionRequest model) {
            super(model);
            resourceDefinitionId(model.resourceDefinitionId);
        }

        public final String getResourceDefinitionId() {
            return resourceDefinitionId;
        }

        public final void setResourceDefinitionId(String resourceDefinitionId) {
            this.resourceDefinitionId = resourceDefinitionId;
        }

        @Override
        @Transient
        public final Builder resourceDefinitionId(String resourceDefinitionId) {
            this.resourceDefinitionId = resourceDefinitionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceDefinitionRequest build() {
            return new GetResourceDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
