/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateSubscriptionDefinitionVersionRequest.Builder, CreateSubscriptionDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmznClientToken").getter(getter(CreateSubscriptionDefinitionVersionRequest::amznClientToken))
            .setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionDefinitionId")
            .getter(getter(CreateSubscriptionDefinitionVersionRequest::subscriptionDefinitionId))
            .setter(setter(Builder::subscriptionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscriptionDefinitionId").build())
            .build();

    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .memberName("Subscriptions")
            .getter(getter(CreateSubscriptionDefinitionVersionRequest::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            SUBSCRIPTION_DEFINITION_ID_FIELD, SUBSCRIPTIONS_FIELD));

    private final String amznClientToken;

    private final String subscriptionDefinitionId;

    private final List<Subscription> subscriptions;

    private CreateSubscriptionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.subscriptionDefinitionId = builder.subscriptionDefinitionId;
        this.subscriptions = builder.subscriptions;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public final String amznClientToken() {
        return amznClientToken;
    }

    /**
     * The ID of the subscription definition.
     * 
     * @return The ID of the subscription definition.
     */
    public final String subscriptionDefinitionId() {
        return subscriptionDefinitionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * A list of subscriptions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptions} method.
     * </p>
     * 
     * @return A list of subscriptions.
     */
    public final List<Subscription> subscriptions() {
        return subscriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptions() ? subscriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionDefinitionVersionRequest)) {
            return false;
        }
        CreateSubscriptionDefinitionVersionRequest other = (CreateSubscriptionDefinitionVersionRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(subscriptionDefinitionId(), other.subscriptionDefinitionId())
                && hasSubscriptions() == other.hasSubscriptions() && Objects.equals(subscriptions(), other.subscriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionDefinitionVersionRequest").add("AmznClientToken", amznClientToken())
                .add("SubscriptionDefinitionId", subscriptionDefinitionId())
                .add("Subscriptions", hasSubscriptions() ? subscriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "SubscriptionDefinitionId":
            return Optional.ofNullable(clazz.cast(subscriptionDefinitionId()));
        case "Subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * The ID of the subscription definition.
         * 
         * @param subscriptionDefinitionId
         *        The ID of the subscription definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionDefinitionId(String subscriptionDefinitionId);

        /**
         * A list of subscriptions.
         * 
         * @param subscriptions
         *        A list of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * A list of subscriptions.
         * 
         * @param subscriptions
         *        A list of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Subscription... subscriptions);

        /**
         * A list of subscriptions. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrass.model.Subscription.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.greengrass.model.Subscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrass.model.Subscription.Builder#build()} is called immediately
         * and its result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrass.model.Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(java.util.Collection<Subscription>)
         */
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private String subscriptionDefinitionId;

        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionDefinitionVersionRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            subscriptionDefinitionId(model.subscriptionDefinitionId);
            subscriptions(model.subscriptions);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final String getSubscriptionDefinitionId() {
            return subscriptionDefinitionId;
        }

        public final void setSubscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
        }

        @Override
        public final Builder subscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = ___listOfSubscriptionCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = ___listOfSubscriptionCopier.copyFromBuilder(subscriptions);
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ___listOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionDefinitionVersionRequest build() {
            return new CreateSubscriptionDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
