/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThingRuntimeConfigurationRequest extends GreengrassRequest implements
        ToCopyableBuilder<UpdateThingRuntimeConfigurationRequest.Builder, UpdateThingRuntimeConfigurationRequest> {
    private static final SdkField<TelemetryConfigurationUpdate> TELEMETRY_CONFIGURATION_FIELD = SdkField
            .<TelemetryConfigurationUpdate> builder(MarshallingType.SDK_POJO).memberName("TelemetryConfiguration")
            .getter(getter(UpdateThingRuntimeConfigurationRequest::telemetryConfiguration))
            .setter(setter(Builder::telemetryConfiguration)).constructor(TelemetryConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfiguration").build())
            .build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThingName").getter(getter(UpdateThingRuntimeConfigurationRequest::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_CONFIGURATION_FIELD,
            THING_NAME_FIELD));

    private final TelemetryConfigurationUpdate telemetryConfiguration;

    private final String thingName;

    private UpdateThingRuntimeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.telemetryConfiguration = builder.telemetryConfiguration;
        this.thingName = builder.thingName;
    }

    /**
     * Configuration for telemetry service.
     * 
     * @return Configuration for telemetry service.
     */
    public final TelemetryConfigurationUpdate telemetryConfiguration() {
        return telemetryConfiguration;
    }

    /**
     * The thing name.
     * 
     * @return The thing name.
     */
    public final String thingName() {
        return thingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(telemetryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingRuntimeConfigurationRequest)) {
            return false;
        }
        UpdateThingRuntimeConfigurationRequest other = (UpdateThingRuntimeConfigurationRequest) obj;
        return Objects.equals(telemetryConfiguration(), other.telemetryConfiguration())
                && Objects.equals(thingName(), other.thingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateThingRuntimeConfigurationRequest").add("TelemetryConfiguration", telemetryConfiguration())
                .add("ThingName", thingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TelemetryConfiguration":
            return Optional.ofNullable(clazz.cast(telemetryConfiguration()));
        case "ThingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThingRuntimeConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateThingRuntimeConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateThingRuntimeConfigurationRequest> {
        /**
         * Configuration for telemetry service.
         * 
         * @param telemetryConfiguration
         *        Configuration for telemetry service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryConfiguration(TelemetryConfigurationUpdate telemetryConfiguration);

        /**
         * Configuration for telemetry service. This is a convenience method that creates an instance of the
         * {@link TelemetryConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link TelemetryConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #telemetryConfiguration(TelemetryConfigurationUpdate)}.
         * 
         * @param telemetryConfiguration
         *        a consumer that will call methods on {@link TelemetryConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryConfiguration(TelemetryConfigurationUpdate)
         */
        default Builder telemetryConfiguration(Consumer<TelemetryConfigurationUpdate.Builder> telemetryConfiguration) {
            return telemetryConfiguration(TelemetryConfigurationUpdate.builder().applyMutation(telemetryConfiguration).build());
        }

        /**
         * The thing name.
         * 
         * @param thingName
         *        The thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private TelemetryConfigurationUpdate telemetryConfiguration;

        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingRuntimeConfigurationRequest model) {
            super(model);
            telemetryConfiguration(model.telemetryConfiguration);
            thingName(model.thingName);
        }

        public final TelemetryConfigurationUpdate.Builder getTelemetryConfiguration() {
            return telemetryConfiguration != null ? telemetryConfiguration.toBuilder() : null;
        }

        public final void setTelemetryConfiguration(TelemetryConfigurationUpdate.BuilderImpl telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration != null ? telemetryConfiguration.build() : null;
        }

        @Override
        public final Builder telemetryConfiguration(TelemetryConfigurationUpdate telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingRuntimeConfigurationRequest build() {
            return new UpdateThingRuntimeConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
