/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The configuration of the Lambda function.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionConfiguration.Builder, FunctionConfiguration> {
    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodingType").getter(getter(FunctionConfiguration::encodingTypeAsString))
            .setter(setter(Builder::encodingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType").build()).build();

    private static final SdkField<FunctionConfigurationEnvironment> ENVIRONMENT_FIELD = SdkField
            .<FunctionConfigurationEnvironment> builder(MarshallingType.SDK_POJO).memberName("Environment")
            .getter(getter(FunctionConfiguration::environment)).setter(setter(Builder::environment))
            .constructor(FunctionConfigurationEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> EXEC_ARGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecArgs").getter(getter(FunctionConfiguration::execArgs)).setter(setter(Builder::execArgs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecArgs").build()).build();

    private static final SdkField<String> EXECUTABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Executable").getter(getter(FunctionConfiguration::executable)).setter(setter(Builder::executable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Executable").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemorySize").getter(getter(FunctionConfiguration::memorySize)).setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()).build();

    private static final SdkField<Boolean> PINNED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Pinned").getter(getter(FunctionConfiguration::pinned)).setter(setter(Builder::pinned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pinned").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(FunctionConfiguration::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<String> FUNCTION_RUNTIME_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionRuntimeOverride").getter(getter(FunctionConfiguration::functionRuntimeOverride))
            .setter(setter(Builder::functionRuntimeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionRuntimeOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_TYPE_FIELD,
            ENVIRONMENT_FIELD, EXEC_ARGS_FIELD, EXECUTABLE_FIELD, MEMORY_SIZE_FIELD, PINNED_FIELD, TIMEOUT_FIELD,
            FUNCTION_RUNTIME_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encodingType;

    private final FunctionConfigurationEnvironment environment;

    private final String execArgs;

    private final String executable;

    private final Integer memorySize;

    private final Boolean pinned;

    private final Integer timeout;

    private final String functionRuntimeOverride;

    private FunctionConfiguration(BuilderImpl builder) {
        this.encodingType = builder.encodingType;
        this.environment = builder.environment;
        this.execArgs = builder.execArgs;
        this.executable = builder.executable;
        this.memorySize = builder.memorySize;
        this.pinned = builder.pinned;
        this.timeout = builder.timeout;
        this.functionRuntimeOverride = builder.functionRuntimeOverride;
    }

    /**
     * The expected encoding type of the input payload for the function. The default is ''json''.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return The expected encoding type of the input payload for the function. The default is ''json''.
     * @see EncodingType
     */
    public final EncodingType encodingType() {
        return EncodingType.fromValue(encodingType);
    }

    /**
     * The expected encoding type of the input payload for the function. The default is ''json''.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return The expected encoding type of the input payload for the function. The default is ''json''.
     * @see EncodingType
     */
    public final String encodingTypeAsString() {
        return encodingType;
    }

    /**
     * The environment configuration of the function.
     * 
     * @return The environment configuration of the function.
     */
    public final FunctionConfigurationEnvironment environment() {
        return environment;
    }

    /**
     * The execution arguments.
     * 
     * @return The execution arguments.
     */
    public final String execArgs() {
        return execArgs;
    }

    /**
     * The name of the function executable.
     * 
     * @return The name of the function executable.
     */
    public final String executable() {
        return executable;
    }

    /**
     * The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when
     * you run the Lambda function without containerization.
     * 
     * @return The memory size, in KB, which the function requires. This setting is not applicable and should be cleared
     *         when you run the Lambda function without containerization.
     */
    public final Integer memorySize() {
        return memorySize;
    }

    /**
     * True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
     * 
     * @return True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
     */
    public final Boolean pinned() {
        return pinned;
    }

    /**
     * The allowed function execution time, after which Lambda should terminate the function. This timeout still applies
     * to pinned Lambda functions for each request.
     * 
     * @return The allowed function execution time, after which Lambda should terminate the function. This timeout still
     *         applies to pinned Lambda functions for each request.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * The Lambda runtime supported by Greengrass which is to be used instead of the one specified in the Lambda
     * function.
     * 
     * @return The Lambda runtime supported by Greengrass which is to be used instead of the one specified in the Lambda
     *         function.
     */
    public final String functionRuntimeOverride() {
        return functionRuntimeOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(execArgs());
        hashCode = 31 * hashCode + Objects.hashCode(executable());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(pinned());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(functionRuntimeOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfiguration)) {
            return false;
        }
        FunctionConfiguration other = (FunctionConfiguration) obj;
        return Objects.equals(encodingTypeAsString(), other.encodingTypeAsString())
                && Objects.equals(environment(), other.environment()) && Objects.equals(execArgs(), other.execArgs())
                && Objects.equals(executable(), other.executable()) && Objects.equals(memorySize(), other.memorySize())
                && Objects.equals(pinned(), other.pinned()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(functionRuntimeOverride(), other.functionRuntimeOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionConfiguration").add("EncodingType", encodingTypeAsString())
                .add("Environment", environment()).add("ExecArgs", execArgs()).add("Executable", executable())
                .add("MemorySize", memorySize()).add("Pinned", pinned()).add("Timeout", timeout())
                .add("FunctionRuntimeOverride", functionRuntimeOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncodingType":
            return Optional.ofNullable(clazz.cast(encodingTypeAsString()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "ExecArgs":
            return Optional.ofNullable(clazz.cast(execArgs()));
        case "Executable":
            return Optional.ofNullable(clazz.cast(executable()));
        case "MemorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "Pinned":
            return Optional.ofNullable(clazz.cast(pinned()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "FunctionRuntimeOverride":
            return Optional.ofNullable(clazz.cast(functionRuntimeOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfiguration, T> g) {
        return obj -> g.apply((FunctionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionConfiguration> {
        /**
         * The expected encoding type of the input payload for the function. The default is ''json''.
         * 
         * @param encodingType
         *        The expected encoding type of the input payload for the function. The default is ''json''.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * The expected encoding type of the input payload for the function. The default is ''json''.
         * 
         * @param encodingType
         *        The expected encoding type of the input payload for the function. The default is ''json''.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);

        /**
         * The environment configuration of the function.
         * 
         * @param environment
         *        The environment configuration of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(FunctionConfigurationEnvironment environment);

        /**
         * The environment configuration of the function. This is a convenience method that creates an instance of the
         * {@link FunctionConfigurationEnvironment.Builder} avoiding the need to create one manually via
         * {@link FunctionConfigurationEnvironment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionConfigurationEnvironment.Builder#build()} is called
         * immediately and its result is passed to {@link #environment(FunctionConfigurationEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link FunctionConfigurationEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(FunctionConfigurationEnvironment)
         */
        default Builder environment(Consumer<FunctionConfigurationEnvironment.Builder> environment) {
            return environment(FunctionConfigurationEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * The execution arguments.
         * 
         * @param execArgs
         *        The execution arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execArgs(String execArgs);

        /**
         * The name of the function executable.
         * 
         * @param executable
         *        The name of the function executable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executable(String executable);

        /**
         * The memory size, in KB, which the function requires. This setting is not applicable and should be cleared
         * when you run the Lambda function without containerization.
         * 
         * @param memorySize
         *        The memory size, in KB, which the function requires. This setting is not applicable and should be
         *        cleared when you run the Lambda function without containerization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
         * 
         * @param pinned
         *        True if the function is pinned. Pinned means the function is long-lived and starts when the core
         *        starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinned(Boolean pinned);

        /**
         * The allowed function execution time, after which Lambda should terminate the function. This timeout still
         * applies to pinned Lambda functions for each request.
         * 
         * @param timeout
         *        The allowed function execution time, after which Lambda should terminate the function. This timeout
         *        still applies to pinned Lambda functions for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * The Lambda runtime supported by Greengrass which is to be used instead of the one specified in the Lambda
         * function.
         * 
         * @param functionRuntimeOverride
         *        The Lambda runtime supported by Greengrass which is to be used instead of the one specified in the
         *        Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionRuntimeOverride(String functionRuntimeOverride);
    }

    static final class BuilderImpl implements Builder {
        private String encodingType;

        private FunctionConfigurationEnvironment environment;

        private String execArgs;

        private String executable;

        private Integer memorySize;

        private Boolean pinned;

        private Integer timeout;

        private String functionRuntimeOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfiguration model) {
            encodingType(model.encodingType);
            environment(model.environment);
            execArgs(model.execArgs);
            executable(model.executable);
            memorySize(model.memorySize);
            pinned(model.pinned);
            timeout(model.timeout);
            functionRuntimeOverride(model.functionRuntimeOverride);
        }

        public final String getEncodingType() {
            return encodingType;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType == null ? null : encodingType.toString());
            return this;
        }

        public final FunctionConfigurationEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(FunctionConfigurationEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(FunctionConfigurationEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getExecArgs() {
            return execArgs;
        }

        public final void setExecArgs(String execArgs) {
            this.execArgs = execArgs;
        }

        @Override
        public final Builder execArgs(String execArgs) {
            this.execArgs = execArgs;
            return this;
        }

        public final String getExecutable() {
            return executable;
        }

        public final void setExecutable(String executable) {
            this.executable = executable;
        }

        @Override
        public final Builder executable(String executable) {
            this.executable = executable;
            return this;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final Boolean getPinned() {
            return pinned;
        }

        public final void setPinned(Boolean pinned) {
            this.pinned = pinned;
        }

        @Override
        public final Builder pinned(Boolean pinned) {
            this.pinned = pinned;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getFunctionRuntimeOverride() {
            return functionRuntimeOverride;
        }

        public final void setFunctionRuntimeOverride(String functionRuntimeOverride) {
            this.functionRuntimeOverride = functionRuntimeOverride;
        }

        @Override
        public final Builder functionRuntimeOverride(String functionRuntimeOverride) {
            this.functionRuntimeOverride = functionRuntimeOverride;
            return this;
        }

        @Override
        public FunctionConfiguration build() {
            return new FunctionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
