/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupResponse;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountResponse;
import software.amazon.awssdk.services.greengrass.model.BadRequestException;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleRequest;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleResponse;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountRequest;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetThingRuntimeConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetThingRuntimeConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GreengrassException;
import software.amazon.awssdk.services.greengrass.model.InternalServerErrorException;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsResponse;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.greengrass.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.TagResourceRequest;
import software.amazon.awssdk.services.greengrass.model.TagResourceResponse;
import software.amazon.awssdk.services.greengrass.model.UntagResourceRequest;
import software.amazon.awssdk.services.greengrass.model.UntagResourceResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateThingRuntimeConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateThingRuntimeConfigurationResponse;

/**
 * Service client for accessing AWS Greengrass. This can be created using the static {@link #builder()} method.
 *
 * AWS IoT Greengrass seamlessly extends AWS onto physical devices so they can act locally on the data they generate,
 * while still using the cloud for management, analytics, and durable storage. AWS IoT Greengrass ensures your devices
 * can respond quickly to local events and operate with intermittent connectivity. AWS IoT Greengrass minimizes the cost
 * of transmitting data to the cloud by allowing you to author AWS Lambda functions that execute locally.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GreengrassClient extends SdkClient {
    String SERVICE_NAME = "greengrass";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "greengrass";

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
     *
     * @param associateRoleToGroupRequest
     * @return Result of the AssociateRoleToGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.AssociateRoleToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateRoleToGroupResponse associateRoleToGroup(AssociateRoleToGroupRequest associateRoleToGroupRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRoleToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateRoleToGroupRequest#builder()}
     * </p>
     *
     * @param associateRoleToGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateRoleToGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateRoleToGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.AssociateRoleToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateRoleToGroupResponse associateRoleToGroup(
            Consumer<AssociateRoleToGroupRequest.Builder> associateRoleToGroupRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return associateRoleToGroup(AssociateRoleToGroupRequest.builder().applyMutation(associateRoleToGroupRequest).build());
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.
     *
     * @param associateServiceRoleToAccountRequest
     * @return Result of the AssociateServiceRoleToAccount operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.AssociateServiceRoleToAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateServiceRoleToAccountResponse associateServiceRoleToAccount(
            AssociateServiceRoleToAccountRequest associateServiceRoleToAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateServiceRoleToAccountRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateServiceRoleToAccountRequest#builder()}
     * </p>
     *
     * @param associateServiceRoleToAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateServiceRoleToAccountRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateServiceRoleToAccount operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.AssociateServiceRoleToAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateServiceRoleToAccountResponse associateServiceRoleToAccount(
            Consumer<AssociateServiceRoleToAccountRequest.Builder> associateServiceRoleToAccountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest.builder()
                .applyMutation(associateServiceRoleToAccountRequest).build());
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.
     *
     * @param createConnectorDefinitionRequest
     * @return Result of the CreateConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorDefinitionResponse createConnectorDefinition(
            CreateConnectorDefinitionRequest createConnectorDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param createConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorDefinitionResponse createConnectorDefinition(
            Consumer<CreateConnectorDefinitionRequest.Builder> createConnectorDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createConnectorDefinition(CreateConnectorDefinitionRequest.builder()
                .applyMutation(createConnectorDefinitionRequest).build());
    }

    /**
     * Creates a version of a connector definition which has already been defined.
     *
     * @param createConnectorDefinitionVersionRequest
     * @return Result of the CreateConnectorDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateConnectorDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorDefinitionVersionResponse createConnectorDefinitionVersion(
            CreateConnectorDefinitionVersionRequest createConnectorDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a connector definition which has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConnectorDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createConnectorDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateConnectorDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateConnectorDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorDefinitionVersionResponse createConnectorDefinitionVersion(
            Consumer<CreateConnectorDefinitionVersionRequest.Builder> createConnectorDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createConnectorDefinitionVersion(CreateConnectorDefinitionVersionRequest.builder()
                .applyMutation(createConnectorDefinitionVersionRequest).build());
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
     *
     * @param createCoreDefinitionRequest
     *        Information needed to create a core definition.
     * @return Result of the CreateCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCoreDefinitionResponse createCoreDefinition(CreateCoreDefinitionRequest createCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoreDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param createCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCoreDefinitionRequest.Builder} to create a
     *        request. Information needed to create a core definition.
     * @return Result of the CreateCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCoreDefinitionResponse createCoreDefinition(
            Consumer<CreateCoreDefinitionRequest.Builder> createCoreDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createCoreDefinition(CreateCoreDefinitionRequest.builder().applyMutation(createCoreDefinitionRequest).build());
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.
     *
     * @param createCoreDefinitionVersionRequest
     * @return Result of the CreateCoreDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateCoreDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCoreDefinitionVersionResponse createCoreDefinitionVersion(
            CreateCoreDefinitionVersionRequest createCoreDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoreDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCoreDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createCoreDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCoreDefinitionVersionRequest.Builder} to create
     *        a request.
     * @return Result of the CreateCoreDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateCoreDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCoreDefinitionVersionResponse createCoreDefinitionVersion(
            Consumer<CreateCoreDefinitionVersionRequest.Builder> createCoreDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createCoreDefinitionVersion(CreateCoreDefinitionVersionRequest.builder()
                .applyMutation(createCoreDefinitionVersionRequest).build());
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.
     *
     * @param createDeploymentRequest
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentRequest.Builder} to create a request.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.
     *
     * @param createDeviceDefinitionRequest
     * @return Result of the CreateDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceDefinitionResponse createDeviceDefinition(CreateDeviceDefinitionRequest createDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param createDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceDefinitionResponse createDeviceDefinition(
            Consumer<CreateDeviceDefinitionRequest.Builder> createDeviceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createDeviceDefinition(CreateDeviceDefinitionRequest.builder().applyMutation(createDeviceDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a device definition that has already been defined.
     *
     * @param createDeviceDefinitionVersionRequest
     * @return Result of the CreateDeviceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeviceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceDefinitionVersionResponse createDeviceDefinitionVersion(
            CreateDeviceDefinitionVersionRequest createDeviceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a device definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDeviceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createDeviceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeviceDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDeviceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeviceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeviceDefinitionVersionResponse createDeviceDefinitionVersion(
            Consumer<CreateDeviceDefinitionVersionRequest.Builder> createDeviceDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createDeviceDefinitionVersion(CreateDeviceDefinitionVersionRequest.builder()
                .applyMutation(createDeviceDefinitionVersionRequest).build());
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
     *
     * @param createFunctionDefinitionRequest
     * @return Result of the CreateFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFunctionDefinitionResponse createFunctionDefinition(
            CreateFunctionDefinitionRequest createFunctionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param createFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFunctionDefinitionResponse createFunctionDefinition(
            Consumer<CreateFunctionDefinitionRequest.Builder> createFunctionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createFunctionDefinition(CreateFunctionDefinitionRequest.builder().applyMutation(createFunctionDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.
     *
     * @param createFunctionDefinitionVersionRequest
     *        Information needed to create a function definition version.
     * @return Result of the CreateFunctionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateFunctionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFunctionDefinitionVersionResponse createFunctionDefinitionVersion(
            CreateFunctionDefinitionVersionRequest createFunctionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFunctionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createFunctionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionDefinitionVersionRequest.Builder} to
     *        create a request. Information needed to create a function definition version.
     * @return Result of the CreateFunctionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateFunctionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFunctionDefinitionVersionResponse createFunctionDefinitionVersion(
            Consumer<CreateFunctionDefinitionVersionRequest.Builder> createFunctionDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createFunctionDefinitionVersion(CreateFunctionDefinitionVersionRequest.builder()
                .applyMutation(createFunctionDefinitionVersionRequest).build());
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
     *
     * @param createGroupCertificateAuthorityRequest
     * @return Result of the CreateGroupCertificateAuthority operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroupCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGroupCertificateAuthorityResponse createGroupCertificateAuthority(
            CreateGroupCertificateAuthorityRequest createGroupCertificateAuthorityRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link CreateGroupCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param createGroupCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupCertificateAuthorityRequest.Builder} to
     *        create a request.
     * @return Result of the CreateGroupCertificateAuthority operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroupCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGroupCertificateAuthorityResponse createGroupCertificateAuthority(
            Consumer<CreateGroupCertificateAuthorityRequest.Builder> createGroupCertificateAuthorityRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return createGroupCertificateAuthority(CreateGroupCertificateAuthorityRequest.builder()
                .applyMutation(createGroupCertificateAuthorityRequest).build());
    }

    /**
     * Creates a version of a group which has already been defined.
     *
     * @param createGroupVersionRequest
     * @return Result of the CreateGroupVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGroupVersionResponse createGroupVersion(CreateGroupVersionRequest createGroupVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a group which has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupVersionRequest#builder()}
     * </p>
     *
     * @param createGroupVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGroupVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGroupVersionResponse createGroupVersion(Consumer<CreateGroupVersionRequest.Builder> createGroupVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createGroupVersion(CreateGroupVersionRequest.builder().applyMutation(createGroupVersionRequest).build());
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.
     *
     * @param createLoggerDefinitionRequest
     * @return Result of the CreateLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoggerDefinitionResponse createLoggerDefinition(CreateLoggerDefinitionRequest createLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param createLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoggerDefinitionResponse createLoggerDefinition(
            Consumer<CreateLoggerDefinitionRequest.Builder> createLoggerDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createLoggerDefinition(CreateLoggerDefinitionRequest.builder().applyMutation(createLoggerDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a logger definition that has already been defined.
     *
     * @param createLoggerDefinitionVersionRequest
     * @return Result of the CreateLoggerDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateLoggerDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoggerDefinitionVersionResponse createLoggerDefinitionVersion(
            CreateLoggerDefinitionVersionRequest createLoggerDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a logger definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoggerDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLoggerDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createLoggerDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLoggerDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLoggerDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateLoggerDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoggerDefinitionVersionResponse createLoggerDefinitionVersion(
            Consumer<CreateLoggerDefinitionVersionRequest.Builder> createLoggerDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createLoggerDefinitionVersion(CreateLoggerDefinitionVersionRequest.builder()
                .applyMutation(createLoggerDefinitionVersionRequest).build());
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
     *
     * @param createResourceDefinitionRequest
     * @return Result of the CreateResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceDefinitionResponse createResourceDefinition(
            CreateResourceDefinitionRequest createResourceDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param createResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceDefinitionResponse createResourceDefinition(
            Consumer<CreateResourceDefinitionRequest.Builder> createResourceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return createResourceDefinition(CreateResourceDefinitionRequest.builder().applyMutation(createResourceDefinitionRequest)
                .build());
    }

    /**
     * Creates a version of a resource definition that has already been defined.
     *
     * @param createResourceDefinitionVersionRequest
     * @return Result of the CreateResourceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateResourceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceDefinitionVersionResponse createResourceDefinitionVersion(
            CreateResourceDefinitionVersionRequest createResourceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a resource definition that has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createResourceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateResourceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateResourceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceDefinitionVersionResponse createResourceDefinitionVersion(
            Consumer<CreateResourceDefinitionVersionRequest.Builder> createResourceDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createResourceDefinitionVersion(CreateResourceDefinitionVersionRequest.builder()
                .applyMutation(createResourceDefinitionVersionRequest).build());
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.
     *
     * @param createSoftwareUpdateJobRequest
     * @return Result of the CreateSoftwareUpdateJob operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSoftwareUpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSoftwareUpdateJobResponse createSoftwareUpdateJob(CreateSoftwareUpdateJobRequest createSoftwareUpdateJobRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSoftwareUpdateJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSoftwareUpdateJobRequest#builder()}
     * </p>
     *
     * @param createSoftwareUpdateJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateSoftwareUpdateJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSoftwareUpdateJob operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSoftwareUpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSoftwareUpdateJobResponse createSoftwareUpdateJob(
            Consumer<CreateSoftwareUpdateJobRequest.Builder> createSoftwareUpdateJobRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return createSoftwareUpdateJob(CreateSoftwareUpdateJobRequest.builder().applyMutation(createSoftwareUpdateJobRequest)
                .build());
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.
     *
     * @param createSubscriptionDefinitionRequest
     * @return Result of the CreateSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionDefinitionResponse createSubscriptionDefinition(
            CreateSubscriptionDefinitionRequest createSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionDefinitionRequest.Builder} to create
     *        a request.
     * @return Result of the CreateSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionDefinitionResponse createSubscriptionDefinition(
            Consumer<CreateSubscriptionDefinitionRequest.Builder> createSubscriptionDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createSubscriptionDefinition(CreateSubscriptionDefinitionRequest.builder()
                .applyMutation(createSubscriptionDefinitionRequest).build());
    }

    /**
     * Creates a version of a subscription definition which has already been defined.
     *
     * @param createSubscriptionDefinitionVersionRequest
     * @return Result of the CreateSubscriptionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSubscriptionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionDefinitionVersionResponse createSubscriptionDefinitionVersion(
            CreateSubscriptionDefinitionVersionRequest createSubscriptionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a version of a subscription definition which has already been defined.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSubscriptionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSubscriptionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSubscriptionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubscriptionDefinitionVersionResponse createSubscriptionDefinitionVersion(
            Consumer<CreateSubscriptionDefinitionVersionRequest.Builder> createSubscriptionDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return createSubscriptionDefinitionVersion(CreateSubscriptionDefinitionVersionRequest.builder()
                .applyMutation(createSubscriptionDefinitionVersionRequest).build());
    }

    /**
     * Deletes a connector definition.
     *
     * @param deleteConnectorDefinitionRequest
     * @return Result of the DeleteConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorDefinitionResponse deleteConnectorDefinition(
            DeleteConnectorDefinitionRequest deleteConnectorDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a connector definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorDefinitionResponse deleteConnectorDefinition(
            Consumer<DeleteConnectorDefinitionRequest.Builder> deleteConnectorDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteConnectorDefinition(DeleteConnectorDefinitionRequest.builder()
                .applyMutation(deleteConnectorDefinitionRequest).build());
    }

    /**
     * Deletes a core definition.
     *
     * @param deleteCoreDefinitionRequest
     * @return Result of the DeleteCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCoreDefinitionResponse deleteCoreDefinition(DeleteCoreDefinitionRequest deleteCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a core definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCoreDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCoreDefinitionResponse deleteCoreDefinition(
            Consumer<DeleteCoreDefinitionRequest.Builder> deleteCoreDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteCoreDefinition(DeleteCoreDefinitionRequest.builder().applyMutation(deleteCoreDefinitionRequest).build());
    }

    /**
     * Deletes a device definition.
     *
     * @param deleteDeviceDefinitionRequest
     * @return Result of the DeleteDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceDefinitionResponse deleteDeviceDefinition(DeleteDeviceDefinitionRequest deleteDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceDefinitionResponse deleteDeviceDefinition(
            Consumer<DeleteDeviceDefinitionRequest.Builder> deleteDeviceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteDeviceDefinition(DeleteDeviceDefinitionRequest.builder().applyMutation(deleteDeviceDefinitionRequest)
                .build());
    }

    /**
     * Deletes a Lambda function definition.
     *
     * @param deleteFunctionDefinitionRequest
     * @return Result of the DeleteFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionDefinitionResponse deleteFunctionDefinition(
            DeleteFunctionDefinitionRequest deleteFunctionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a Lambda function definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionDefinitionResponse deleteFunctionDefinition(
            Consumer<DeleteFunctionDefinitionRequest.Builder> deleteFunctionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteFunctionDefinition(DeleteFunctionDefinitionRequest.builder().applyMutation(deleteFunctionDefinitionRequest)
                .build());
    }

    /**
     * Deletes a group.
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * Deletes a logger definition.
     *
     * @param deleteLoggerDefinitionRequest
     * @return Result of the DeleteLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoggerDefinitionResponse deleteLoggerDefinition(DeleteLoggerDefinitionRequest deleteLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoggerDefinitionResponse deleteLoggerDefinition(
            Consumer<DeleteLoggerDefinitionRequest.Builder> deleteLoggerDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteLoggerDefinition(DeleteLoggerDefinitionRequest.builder().applyMutation(deleteLoggerDefinitionRequest)
                .build());
    }

    /**
     * Deletes a resource definition.
     *
     * @param deleteResourceDefinitionRequest
     * @return Result of the DeleteResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceDefinitionResponse deleteResourceDefinition(
            DeleteResourceDefinitionRequest deleteResourceDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a resource definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceDefinitionResponse deleteResourceDefinition(
            Consumer<DeleteResourceDefinitionRequest.Builder> deleteResourceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return deleteResourceDefinition(DeleteResourceDefinitionRequest.builder().applyMutation(deleteResourceDefinitionRequest)
                .build());
    }

    /**
     * Deletes a subscription definition.
     *
     * @param deleteSubscriptionDefinitionRequest
     * @return Result of the DeleteSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionDefinitionResponse deleteSubscriptionDefinition(
            DeleteSubscriptionDefinitionRequest deleteSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriptionDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubscriptionDefinitionRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubscriptionDefinitionResponse deleteSubscriptionDefinition(
            Consumer<DeleteSubscriptionDefinitionRequest.Builder> deleteSubscriptionDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return deleteSubscriptionDefinition(DeleteSubscriptionDefinitionRequest.builder()
                .applyMutation(deleteSubscriptionDefinitionRequest).build());
    }

    /**
     * Disassociates the role from a group.
     *
     * @param disassociateRoleFromGroupRequest
     * @return Result of the DisassociateRoleFromGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateRoleFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRoleFromGroupResponse disassociateRoleFromGroup(
            DisassociateRoleFromGroupRequest disassociateRoleFromGroupRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Disassociates the role from a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRoleFromGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateRoleFromGroupRequest#builder()}
     * </p>
     *
     * @param disassociateRoleFromGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateRoleFromGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateRoleFromGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateRoleFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRoleFromGroupResponse disassociateRoleFromGroup(
            Consumer<DisassociateRoleFromGroupRequest.Builder> disassociateRoleFromGroupRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return disassociateRoleFromGroup(DisassociateRoleFromGroupRequest.builder()
                .applyMutation(disassociateRoleFromGroupRequest).build());
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @return Result of the DisassociateServiceRoleFromAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateServiceRoleFromAccount
     * @see #disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceRoleFromAccountResponse disassociateServiceRoleFromAccount() throws InternalServerErrorException,
            AwsServiceException, SdkClientException, GreengrassException {
        return disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.builder().build());
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @param disassociateServiceRoleFromAccountRequest
     * @return Result of the DisassociateServiceRoleFromAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateServiceRoleFromAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceRoleFromAccountResponse disassociateServiceRoleFromAccount(
            DisassociateServiceRoleFromAccountRequest disassociateServiceRoleFromAccountRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateServiceRoleFromAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateServiceRoleFromAccountRequest#builder()}
     * </p>
     *
     * @param disassociateServiceRoleFromAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateServiceRoleFromAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateServiceRoleFromAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateServiceRoleFromAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceRoleFromAccountResponse disassociateServiceRoleFromAccount(
            Consumer<DisassociateServiceRoleFromAccountRequest.Builder> disassociateServiceRoleFromAccountRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.builder()
                .applyMutation(disassociateServiceRoleFromAccountRequest).build());
    }

    /**
     * Retrieves the role associated with a particular group.
     *
     * @param getAssociatedRoleRequest
     * @return Result of the GetAssociatedRole operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetAssociatedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAssociatedRoleResponse getAssociatedRole(GetAssociatedRoleRequest getAssociatedRoleRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the role associated with a particular group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssociatedRoleRequest.Builder} avoiding the need
     * to create one manually via {@link GetAssociatedRoleRequest#builder()}
     * </p>
     *
     * @param getAssociatedRoleRequest
     *        A {@link Consumer} that will call methods on {@link GetAssociatedRoleRequest.Builder} to create a request.
     * @return Result of the GetAssociatedRole operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetAssociatedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAssociatedRoleResponse getAssociatedRole(Consumer<GetAssociatedRoleRequest.Builder> getAssociatedRoleRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return getAssociatedRole(GetAssociatedRoleRequest.builder().applyMutation(getAssociatedRoleRequest).build());
    }

    /**
     * Returns the status of a bulk deployment.
     *
     * @param getBulkDeploymentStatusRequest
     * @return Result of the GetBulkDeploymentStatus operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetBulkDeploymentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBulkDeploymentStatusResponse getBulkDeploymentStatus(GetBulkDeploymentStatusRequest getBulkDeploymentStatusRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the status of a bulk deployment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBulkDeploymentStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetBulkDeploymentStatusRequest#builder()}
     * </p>
     *
     * @param getBulkDeploymentStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetBulkDeploymentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetBulkDeploymentStatus operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetBulkDeploymentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBulkDeploymentStatusResponse getBulkDeploymentStatus(
            Consumer<GetBulkDeploymentStatusRequest.Builder> getBulkDeploymentStatusRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getBulkDeploymentStatus(GetBulkDeploymentStatusRequest.builder().applyMutation(getBulkDeploymentStatusRequest)
                .build());
    }

    /**
     * Retrieves the connectivity information for a core.
     *
     * @param getConnectivityInfoRequest
     * @return Result of the GetConnectivityInfo operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectivityInfoResponse getConnectivityInfo(GetConnectivityInfoRequest getConnectivityInfoRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the connectivity information for a core.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectivityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectivityInfoRequest#builder()}
     * </p>
     *
     * @param getConnectivityInfoRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectivityInfoRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnectivityInfo operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectivityInfoResponse getConnectivityInfo(
            Consumer<GetConnectivityInfoRequest.Builder> getConnectivityInfoRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return getConnectivityInfo(GetConnectivityInfoRequest.builder().applyMutation(getConnectivityInfoRequest).build());
    }

    /**
     * Retrieves information about a connector definition.
     *
     * @param getConnectorDefinitionRequest
     * @return Result of the GetConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectorDefinitionResponse getConnectorDefinition(GetConnectorDefinitionRequest getConnectorDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a connector definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param getConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectorDefinitionResponse getConnectorDefinition(
            Consumer<GetConnectorDefinitionRequest.Builder> getConnectorDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getConnectorDefinition(GetConnectorDefinitionRequest.builder().applyMutation(getConnectorDefinitionRequest)
                .build());
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.
     *
     * @param getConnectorDefinitionVersionRequest
     * @return Result of the GetConnectorDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectorDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectorDefinitionVersionResponse getConnectorDefinitionVersion(
            GetConnectorDefinitionVersionRequest getConnectorDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetConnectorDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getConnectorDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectorDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the GetConnectorDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectorDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectorDefinitionVersionResponse getConnectorDefinitionVersion(
            Consumer<GetConnectorDefinitionVersionRequest.Builder> getConnectorDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return getConnectorDefinitionVersion(GetConnectorDefinitionVersionRequest.builder()
                .applyMutation(getConnectorDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionRequest
     * @return Result of the GetCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCoreDefinitionResponse getCoreDefinition(GetCoreDefinitionRequest getCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a core definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreDefinitionRequest.Builder} avoiding the need
     * to create one manually via {@link GetCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param getCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreDefinitionRequest.Builder} to create a request.
     * @return Result of the GetCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCoreDefinitionResponse getCoreDefinition(Consumer<GetCoreDefinitionRequest.Builder> getCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return getCoreDefinition(GetCoreDefinitionRequest.builder().applyMutation(getCoreDefinitionRequest).build());
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionVersionRequest
     * @return Result of the GetCoreDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetCoreDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreDefinitionVersionResponse getCoreDefinitionVersion(
            GetCoreDefinitionVersionRequest getCoreDefinitionVersionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a core definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreDefinitionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCoreDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getCoreDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetCoreDefinitionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetCoreDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetCoreDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCoreDefinitionVersionResponse getCoreDefinitionVersion(
            Consumer<GetCoreDefinitionVersionRequest.Builder> getCoreDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getCoreDefinitionVersion(GetCoreDefinitionVersionRequest.builder().applyMutation(getCoreDefinitionVersionRequest)
                .build());
    }

    /**
     * Returns the status of a deployment.
     *
     * @param getDeploymentStatusRequest
     * @return Result of the GetDeploymentStatus operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeploymentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentStatusResponse getDeploymentStatus(GetDeploymentStatusRequest getDeploymentStatusRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the status of a deployment.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeploymentStatusRequest#builder()}
     * </p>
     *
     * @param getDeploymentStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeploymentStatus operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeploymentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentStatusResponse getDeploymentStatus(
            Consumer<GetDeploymentStatusRequest.Builder> getDeploymentStatusRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getDeploymentStatus(GetDeploymentStatusRequest.builder().applyMutation(getDeploymentStatusRequest).build());
    }

    /**
     * Retrieves information about a device definition.
     *
     * @param getDeviceDefinitionRequest
     * @return Result of the GetDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceDefinitionResponse getDeviceDefinition(GetDeviceDefinitionRequest getDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param getDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceDefinitionResponse getDeviceDefinition(
            Consumer<GetDeviceDefinitionRequest.Builder> getDeviceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getDeviceDefinition(GetDeviceDefinitionRequest.builder().applyMutation(getDeviceDefinitionRequest).build());
    }

    /**
     * Retrieves information about a device definition version.
     *
     * @param getDeviceDefinitionVersionRequest
     * @return Result of the GetDeviceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeviceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceDefinitionVersionResponse getDeviceDefinitionVersion(
            GetDeviceDefinitionVersionRequest getDeviceDefinitionVersionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a device definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceDefinitionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetDeviceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getDeviceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceDefinitionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeviceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeviceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceDefinitionVersionResponse getDeviceDefinitionVersion(
            Consumer<GetDeviceDefinitionVersionRequest.Builder> getDeviceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getDeviceDefinitionVersion(GetDeviceDefinitionVersionRequest.builder()
                .applyMutation(getDeviceDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.
     *
     * @param getFunctionDefinitionRequest
     * @return Result of the GetFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionDefinitionResponse getFunctionDefinition(GetFunctionDefinitionRequest getFunctionDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param getFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionDefinitionResponse getFunctionDefinition(
            Consumer<GetFunctionDefinitionRequest.Builder> getFunctionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getFunctionDefinition(GetFunctionDefinitionRequest.builder().applyMutation(getFunctionDefinitionRequest).build());
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.
     *
     * @param getFunctionDefinitionVersionRequest
     * @return Result of the GetFunctionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetFunctionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionDefinitionVersionResponse getFunctionDefinitionVersion(
            GetFunctionDefinitionVersionRequest getFunctionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetFunctionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getFunctionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionDefinitionVersionRequest.Builder} to create
     *        a request.
     * @return Result of the GetFunctionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetFunctionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionDefinitionVersionResponse getFunctionDefinitionVersion(
            Consumer<GetFunctionDefinitionVersionRequest.Builder> getFunctionDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return getFunctionDefinitionVersion(GetFunctionDefinitionVersionRequest.builder()
                .applyMutation(getFunctionDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a group.
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupRequest.Builder} to create a request.
     * @return Result of the GetGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.
     *
     * @param getGroupCertificateAuthorityRequest
     * @return Result of the GetGroupCertificateAuthority operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGroupCertificateAuthorityResponse getGroupCertificateAuthority(
            GetGroupCertificateAuthorityRequest getGroupCertificateAuthorityRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link GetGroupCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param getGroupCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupCertificateAuthorityRequest.Builder} to create
     *        a request.
     * @return Result of the GetGroupCertificateAuthority operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGroupCertificateAuthorityResponse getGroupCertificateAuthority(
            Consumer<GetGroupCertificateAuthorityRequest.Builder> getGroupCertificateAuthorityRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return getGroupCertificateAuthority(GetGroupCertificateAuthorityRequest.builder()
                .applyMutation(getGroupCertificateAuthorityRequest).build());
    }

    /**
     * Retrieves the current configuration for the CA used by the group.
     *
     * @param getGroupCertificateConfigurationRequest
     * @return Result of the GetGroupCertificateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupCertificateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGroupCertificateConfigurationResponse getGroupCertificateConfiguration(
            GetGroupCertificateConfigurationRequest getGroupCertificateConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the current configuration for the CA used by the group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupCertificateConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetGroupCertificateConfigurationRequest#builder()}
     * </p>
     *
     * @param getGroupCertificateConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupCertificateConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetGroupCertificateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupCertificateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGroupCertificateConfigurationResponse getGroupCertificateConfiguration(
            Consumer<GetGroupCertificateConfigurationRequest.Builder> getGroupCertificateConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return getGroupCertificateConfiguration(GetGroupCertificateConfigurationRequest.builder()
                .applyMutation(getGroupCertificateConfigurationRequest).build());
    }

    /**
     * Retrieves information about a group version.
     *
     * @param getGroupVersionRequest
     * @return Result of the GetGroupVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGroupVersionResponse getGroupVersion(GetGroupVersionRequest getGroupVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a group version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetGroupVersionRequest#builder()}
     * </p>
     *
     * @param getGroupVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupVersionRequest.Builder} to create a request.
     * @return Result of the GetGroupVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGroupVersionResponse getGroupVersion(Consumer<GetGroupVersionRequest.Builder> getGroupVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return getGroupVersion(GetGroupVersionRequest.builder().applyMutation(getGroupVersionRequest).build());
    }

    /**
     * Retrieves information about a logger definition.
     *
     * @param getLoggerDefinitionRequest
     * @return Result of the GetLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoggerDefinitionResponse getLoggerDefinition(GetLoggerDefinitionRequest getLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param getLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoggerDefinitionResponse getLoggerDefinition(
            Consumer<GetLoggerDefinitionRequest.Builder> getLoggerDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getLoggerDefinition(GetLoggerDefinitionRequest.builder().applyMutation(getLoggerDefinitionRequest).build());
    }

    /**
     * Retrieves information about a logger definition version.
     *
     * @param getLoggerDefinitionVersionRequest
     * @return Result of the GetLoggerDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetLoggerDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoggerDefinitionVersionResponse getLoggerDefinitionVersion(
            GetLoggerDefinitionVersionRequest getLoggerDefinitionVersionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a logger definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggerDefinitionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoggerDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getLoggerDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggerDefinitionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetLoggerDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetLoggerDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoggerDefinitionVersionResponse getLoggerDefinitionVersion(
            Consumer<GetLoggerDefinitionVersionRequest.Builder> getLoggerDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getLoggerDefinitionVersion(GetLoggerDefinitionVersionRequest.builder()
                .applyMutation(getLoggerDefinitionVersionRequest).build());
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.
     *
     * @param getResourceDefinitionRequest
     * @return Result of the GetResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceDefinitionResponse getResourceDefinition(GetResourceDefinitionRequest getResourceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param getResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceDefinitionResponse getResourceDefinition(
            Consumer<GetResourceDefinitionRequest.Builder> getResourceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getResourceDefinition(GetResourceDefinitionRequest.builder().applyMutation(getResourceDefinitionRequest).build());
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.
     *
     * @param getResourceDefinitionVersionRequest
     * @return Result of the GetResourceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetResourceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceDefinitionVersionResponse getResourceDefinitionVersion(
            GetResourceDefinitionVersionRequest getResourceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getResourceDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceDefinitionVersionRequest.Builder} to create
     *        a request.
     * @return Result of the GetResourceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetResourceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceDefinitionVersionResponse getResourceDefinitionVersion(
            Consumer<GetResourceDefinitionVersionRequest.Builder> getResourceDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return getResourceDefinitionVersion(GetResourceDefinitionVersionRequest.builder()
                .applyMutation(getResourceDefinitionVersionRequest).build());
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @return Result of the GetServiceRoleForAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetServiceRoleForAccount
     * @see #getServiceRoleForAccount(GetServiceRoleForAccountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceRoleForAccountResponse getServiceRoleForAccount() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, GreengrassException {
        return getServiceRoleForAccount(GetServiceRoleForAccountRequest.builder().build());
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @param getServiceRoleForAccountRequest
     * @return Result of the GetServiceRoleForAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetServiceRoleForAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceRoleForAccountResponse getServiceRoleForAccount(
            GetServiceRoleForAccountRequest getServiceRoleForAccountRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the service role that is attached to your account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRoleForAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetServiceRoleForAccountRequest#builder()}
     * </p>
     *
     * @param getServiceRoleForAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceRoleForAccountRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceRoleForAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetServiceRoleForAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceRoleForAccountResponse getServiceRoleForAccount(
            Consumer<GetServiceRoleForAccountRequest.Builder> getServiceRoleForAccountRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return getServiceRoleForAccount(GetServiceRoleForAccountRequest.builder().applyMutation(getServiceRoleForAccountRequest)
                .build());
    }

    /**
     * Retrieves information about a subscription definition.
     *
     * @param getSubscriptionDefinitionRequest
     * @return Result of the GetSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionDefinitionResponse getSubscriptionDefinition(
            GetSubscriptionDefinitionRequest getSubscriptionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link GetSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the GetSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionDefinitionResponse getSubscriptionDefinition(
            Consumer<GetSubscriptionDefinitionRequest.Builder> getSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return getSubscriptionDefinition(GetSubscriptionDefinitionRequest.builder()
                .applyMutation(getSubscriptionDefinitionRequest).build());
    }

    /**
     * Retrieves information about a subscription definition version.
     *
     * @param getSubscriptionDefinitionVersionRequest
     * @return Result of the GetSubscriptionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetSubscriptionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionDefinitionVersionResponse getSubscriptionDefinitionVersion(
            GetSubscriptionDefinitionVersionRequest getSubscriptionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves information about a subscription definition version.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionDefinitionVersionRequest.Builder}
     * avoiding the need to create one manually via {@link GetSubscriptionDefinitionVersionRequest#builder()}
     * </p>
     *
     * @param getSubscriptionDefinitionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionDefinitionVersionRequest.Builder} to
     *        create a request.
     * @return Result of the GetSubscriptionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetSubscriptionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSubscriptionDefinitionVersionResponse getSubscriptionDefinitionVersion(
            Consumer<GetSubscriptionDefinitionVersionRequest.Builder> getSubscriptionDefinitionVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return getSubscriptionDefinitionVersion(GetSubscriptionDefinitionVersionRequest.builder()
                .applyMutation(getSubscriptionDefinitionVersionRequest).build());
    }

    /**
     * Get the runtime configuration of a thing.
     *
     * @param getThingRuntimeConfigurationRequest
     * @return Result of the GetThingRuntimeConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetThingRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetThingRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetThingRuntimeConfigurationResponse getThingRuntimeConfiguration(
            GetThingRuntimeConfigurationRequest getThingRuntimeConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the runtime configuration of a thing.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThingRuntimeConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetThingRuntimeConfigurationRequest#builder()}
     * </p>
     *
     * @param getThingRuntimeConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetThingRuntimeConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetThingRuntimeConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetThingRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetThingRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetThingRuntimeConfigurationResponse getThingRuntimeConfiguration(
            Consumer<GetThingRuntimeConfigurationRequest.Builder> getThingRuntimeConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return getThingRuntimeConfiguration(GetThingRuntimeConfigurationRequest.builder()
                .applyMutation(getThingRuntimeConfigurationRequest).build());
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.
     *
     * @param listBulkDeploymentDetailedReportsRequest
     * @return Result of the ListBulkDeploymentDetailedReports operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeploymentDetailedReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkDeploymentDetailedReportsResponse listBulkDeploymentDetailedReports(
            ListBulkDeploymentDetailedReportsRequest listBulkDeploymentDetailedReportsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkDeploymentDetailedReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBulkDeploymentDetailedReportsRequest#builder()}
     * </p>
     *
     * @param listBulkDeploymentDetailedReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListBulkDeploymentDetailedReportsRequest.Builder} to
     *        create a request.
     * @return Result of the ListBulkDeploymentDetailedReports operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeploymentDetailedReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkDeploymentDetailedReportsResponse listBulkDeploymentDetailedReports(
            Consumer<ListBulkDeploymentDetailedReportsRequest.Builder> listBulkDeploymentDetailedReportsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listBulkDeploymentDetailedReports(ListBulkDeploymentDetailedReportsRequest.builder()
                .applyMutation(listBulkDeploymentDetailedReportsRequest).build());
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @return Result of the ListBulkDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeployments
     * @see #listBulkDeployments(ListBulkDeploymentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkDeploymentsResponse listBulkDeployments() throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        return listBulkDeployments(ListBulkDeploymentsRequest.builder().build());
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @param listBulkDeploymentsRequest
     * @return Result of the ListBulkDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkDeploymentsResponse listBulkDeployments(ListBulkDeploymentsRequest listBulkDeploymentsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of bulk deployments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBulkDeploymentsRequest#builder()}
     * </p>
     *
     * @param listBulkDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBulkDeploymentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBulkDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkDeploymentsResponse listBulkDeployments(
            Consumer<ListBulkDeploymentsRequest.Builder> listBulkDeploymentsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return listBulkDeployments(ListBulkDeploymentsRequest.builder().applyMutation(listBulkDeploymentsRequest).build());
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.
     *
     * @param listConnectorDefinitionVersionsRequest
     * @return Result of the ListConnectorDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDefinitionVersionsResponse listConnectorDefinitionVersions(
            ListConnectorDefinitionVersionsRequest listConnectorDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConnectorDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listConnectorDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListConnectorDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDefinitionVersionsResponse listConnectorDefinitionVersions(
            Consumer<ListConnectorDefinitionVersionsRequest.Builder> listConnectorDefinitionVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listConnectorDefinitionVersions(ListConnectorDefinitionVersionsRequest.builder()
                .applyMutation(listConnectorDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @return Result of the ListConnectorDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitions
     * @see #listConnectorDefinitions(ListConnectorDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDefinitionsResponse listConnectorDefinitions() throws AwsServiceException, SdkClientException,
            GreengrassException {
        return listConnectorDefinitions(ListConnectorDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @param listConnectorDefinitionsRequest
     * @return Result of the ListConnectorDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDefinitionsResponse listConnectorDefinitions(
            ListConnectorDefinitionsRequest listConnectorDefinitionsRequest) throws AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of connector definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConnectorDefinitionsRequest#builder()}
     * </p>
     *
     * @param listConnectorDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConnectorDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDefinitionsResponse listConnectorDefinitions(
            Consumer<ListConnectorDefinitionsRequest.Builder> listConnectorDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listConnectorDefinitions(ListConnectorDefinitionsRequest.builder().applyMutation(listConnectorDefinitionsRequest)
                .build());
    }

    /**
     * Lists the versions of a core definition.
     *
     * @param listCoreDefinitionVersionsRequest
     * @return Result of the ListCoreDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreDefinitionVersionsResponse listCoreDefinitionVersions(
            ListCoreDefinitionVersionsRequest listCoreDefinitionVersionsRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a core definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreDefinitionVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCoreDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listCoreDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreDefinitionVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCoreDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreDefinitionVersionsResponse listCoreDefinitionVersions(
            Consumer<ListCoreDefinitionVersionsRequest.Builder> listCoreDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return listCoreDefinitionVersions(ListCoreDefinitionVersionsRequest.builder()
                .applyMutation(listCoreDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @return Result of the ListCoreDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitions
     * @see #listCoreDefinitions(ListCoreDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreDefinitionsResponse listCoreDefinitions() throws AwsServiceException, SdkClientException, GreengrassException {
        return listCoreDefinitions(ListCoreDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @param listCoreDefinitionsRequest
     * @return Result of the ListCoreDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreDefinitionsResponse listCoreDefinitions(ListCoreDefinitionsRequest listCoreDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of core definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCoreDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCoreDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCoreDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCoreDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCoreDefinitionsResponse listCoreDefinitions(
            Consumer<ListCoreDefinitionsRequest.Builder> listCoreDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listCoreDefinitions(ListCoreDefinitionsRequest.builder().applyMutation(listCoreDefinitionsRequest).build());
    }

    /**
     * Returns a history of deployments for the group.
     *
     * @param listDeploymentsRequest
     * @return Result of the ListDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(ListDeploymentsRequest listDeploymentsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a history of deployments for the group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsRequest.Builder} to create a request.
     * @return Result of the ListDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * Lists the versions of a device definition.
     *
     * @param listDeviceDefinitionVersionsRequest
     * @return Result of the ListDeviceDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDefinitionVersionsResponse listDeviceDefinitionVersions(
            ListDeviceDefinitionVersionsRequest listDeviceDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeviceDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listDeviceDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceDefinitionVersionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListDeviceDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDefinitionVersionsResponse listDeviceDefinitionVersions(
            Consumer<ListDeviceDefinitionVersionsRequest.Builder> listDeviceDefinitionVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listDeviceDefinitionVersions(ListDeviceDefinitionVersionsRequest.builder()
                .applyMutation(listDeviceDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @return Result of the ListDeviceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitions
     * @see #listDeviceDefinitions(ListDeviceDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDefinitionsResponse listDeviceDefinitions() throws AwsServiceException, SdkClientException,
            GreengrassException {
        return listDeviceDefinitions(ListDeviceDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @param listDeviceDefinitionsRequest
     * @return Result of the ListDeviceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDefinitionsResponse listDeviceDefinitions(ListDeviceDefinitionsRequest listDeviceDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of device definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceDefinitionsRequest#builder()}
     * </p>
     *
     * @param listDeviceDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeviceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDefinitionsResponse listDeviceDefinitions(
            Consumer<ListDeviceDefinitionsRequest.Builder> listDeviceDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listDeviceDefinitions(ListDeviceDefinitionsRequest.builder().applyMutation(listDeviceDefinitionsRequest).build());
    }

    /**
     * Lists the versions of a Lambda function definition.
     *
     * @param listFunctionDefinitionVersionsRequest
     * @return Result of the ListFunctionDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionDefinitionVersionsResponse listFunctionDefinitionVersions(
            ListFunctionDefinitionVersionsRequest listFunctionDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a Lambda function definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listFunctionDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFunctionDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionDefinitionVersionsResponse listFunctionDefinitionVersions(
            Consumer<ListFunctionDefinitionVersionsRequest.Builder> listFunctionDefinitionVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listFunctionDefinitionVersions(ListFunctionDefinitionVersionsRequest.builder()
                .applyMutation(listFunctionDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @return Result of the ListFunctionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitions
     * @see #listFunctionDefinitions(ListFunctionDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionDefinitionsResponse listFunctionDefinitions() throws AwsServiceException, SdkClientException,
            GreengrassException {
        return listFunctionDefinitions(ListFunctionDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @param listFunctionDefinitionsRequest
     * @return Result of the ListFunctionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionDefinitionsResponse listFunctionDefinitions(ListFunctionDefinitionsRequest listFunctionDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of Lambda function definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFunctionDefinitionsRequest#builder()}
     * </p>
     *
     * @param listFunctionDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFunctionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionDefinitionsResponse listFunctionDefinitions(
            Consumer<ListFunctionDefinitionsRequest.Builder> listFunctionDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listFunctionDefinitions(ListFunctionDefinitionsRequest.builder().applyMutation(listFunctionDefinitionsRequest)
                .build());
    }

    /**
     * Retrieves the current CAs for a group.
     *
     * @param listGroupCertificateAuthoritiesRequest
     * @return Result of the ListGroupCertificateAuthorities operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroupCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupCertificateAuthoritiesResponse listGroupCertificateAuthorities(
            ListGroupCertificateAuthoritiesRequest listGroupCertificateAuthoritiesRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the current CAs for a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupCertificateAuthoritiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListGroupCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listGroupCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupCertificateAuthoritiesRequest.Builder} to
     *        create a request.
     * @return Result of the ListGroupCertificateAuthorities operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroupCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupCertificateAuthoritiesResponse listGroupCertificateAuthorities(
            Consumer<ListGroupCertificateAuthoritiesRequest.Builder> listGroupCertificateAuthoritiesRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return listGroupCertificateAuthorities(ListGroupCertificateAuthoritiesRequest.builder()
                .applyMutation(listGroupCertificateAuthoritiesRequest).build());
    }

    /**
     * Lists the versions of a group.
     *
     * @param listGroupVersionsRequest
     * @return Result of the ListGroupVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroupVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGroupVersionsResponse listGroupVersions(ListGroupVersionsRequest listGroupVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupVersionsRequest#builder()}
     * </p>
     *
     * @param listGroupVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupVersionsRequest.Builder} to create a request.
     * @return Result of the ListGroupVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroupVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGroupVersionsResponse listGroupVersions(Consumer<ListGroupVersionsRequest.Builder> listGroupVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listGroupVersions(ListGroupVersionsRequest.builder().applyMutation(listGroupVersionsRequest).build());
    }

    /**
     * Retrieves a list of groups.
     *
     * @return Result of the ListGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroups
     * @see #listGroups(ListGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups() throws AwsServiceException, SdkClientException, GreengrassException {
        return listGroups(ListGroupsRequest.builder().build());
    }

    /**
     * Retrieves a list of groups.
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * Lists the versions of a logger definition.
     *
     * @param listLoggerDefinitionVersionsRequest
     * @return Result of the ListLoggerDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggerDefinitionVersionsResponse listLoggerDefinitionVersions(
            ListLoggerDefinitionVersionsRequest listLoggerDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggerDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLoggerDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listLoggerDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggerDefinitionVersionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListLoggerDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggerDefinitionVersionsResponse listLoggerDefinitionVersions(
            Consumer<ListLoggerDefinitionVersionsRequest.Builder> listLoggerDefinitionVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listLoggerDefinitionVersions(ListLoggerDefinitionVersionsRequest.builder()
                .applyMutation(listLoggerDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @return Result of the ListLoggerDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitions
     * @see #listLoggerDefinitions(ListLoggerDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggerDefinitionsResponse listLoggerDefinitions() throws AwsServiceException, SdkClientException,
            GreengrassException {
        return listLoggerDefinitions(ListLoggerDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @param listLoggerDefinitionsRequest
     * @return Result of the ListLoggerDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggerDefinitionsResponse listLoggerDefinitions(ListLoggerDefinitionsRequest listLoggerDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of logger definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggerDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLoggerDefinitionsRequest#builder()}
     * </p>
     *
     * @param listLoggerDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggerDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLoggerDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLoggerDefinitionsResponse listLoggerDefinitions(
            Consumer<ListLoggerDefinitionsRequest.Builder> listLoggerDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listLoggerDefinitions(ListLoggerDefinitionsRequest.builder().applyMutation(listLoggerDefinitionsRequest).build());
    }

    /**
     * Lists the versions of a resource definition.
     *
     * @param listResourceDefinitionVersionsRequest
     * @return Result of the ListResourceDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDefinitionVersionsResponse listResourceDefinitionVersions(
            ListResourceDefinitionVersionsRequest listResourceDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a resource definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listResourceDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListResourceDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDefinitionVersionsResponse listResourceDefinitionVersions(
            Consumer<ListResourceDefinitionVersionsRequest.Builder> listResourceDefinitionVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listResourceDefinitionVersions(ListResourceDefinitionVersionsRequest.builder()
                .applyMutation(listResourceDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @return Result of the ListResourceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitions
     * @see #listResourceDefinitions(ListResourceDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDefinitionsResponse listResourceDefinitions() throws AwsServiceException, SdkClientException,
            GreengrassException {
        return listResourceDefinitions(ListResourceDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @param listResourceDefinitionsRequest
     * @return Result of the ListResourceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDefinitionsResponse listResourceDefinitions(ListResourceDefinitionsRequest listResourceDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of resource definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceDefinitionsRequest#builder()}
     * </p>
     *
     * @param listResourceDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDefinitionsResponse listResourceDefinitions(
            Consumer<ListResourceDefinitionsRequest.Builder> listResourceDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listResourceDefinitions(ListResourceDefinitionsRequest.builder().applyMutation(listResourceDefinitionsRequest)
                .build());
    }

    /**
     * Lists the versions of a subscription definition.
     *
     * @param listSubscriptionDefinitionVersionsRequest
     * @return Result of the ListSubscriptionDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionDefinitionVersionsResponse listSubscriptionDefinitionVersions(
            ListSubscriptionDefinitionVersionsRequest listSubscriptionDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the versions of a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionDefinitionVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSubscriptionDefinitionVersionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionDefinitionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscriptionDefinitionVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSubscriptionDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionDefinitionVersionsResponse listSubscriptionDefinitionVersions(
            Consumer<ListSubscriptionDefinitionVersionsRequest.Builder> listSubscriptionDefinitionVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return listSubscriptionDefinitionVersions(ListSubscriptionDefinitionVersionsRequest.builder()
                .applyMutation(listSubscriptionDefinitionVersionsRequest).build());
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @return Result of the ListSubscriptionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitions
     * @see #listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionDefinitionsResponse listSubscriptionDefinitions() throws AwsServiceException, SdkClientException,
            GreengrassException {
        return listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest.builder().build());
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @param listSubscriptionDefinitionsRequest
     * @return Result of the ListSubscriptionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionDefinitionsResponse listSubscriptionDefinitions(
            ListSubscriptionDefinitionsRequest listSubscriptionDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of subscription definitions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSubscriptionDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscriptionDefinitionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListSubscriptionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscriptionDefinitionsResponse listSubscriptionDefinitions(
            Consumer<ListSubscriptionDefinitionsRequest.Builder> listSubscriptionDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        return listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest.builder()
                .applyMutation(listSubscriptionDefinitionsRequest).build());
    }

    /**
     * Retrieves a list of resource tags for a resource arn.
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves a list of resource tags for a resource arn.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Resets a group's deployments.
     *
     * @param resetDeploymentsRequest
     *        Information needed to reset deployments.
     * @return Result of the ResetDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ResetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetDeploymentsResponse resetDeployments(ResetDeploymentsRequest resetDeploymentsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Resets a group's deployments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ResetDeploymentsRequest#builder()}
     * </p>
     *
     * @param resetDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ResetDeploymentsRequest.Builder} to create a request.
     *        Information needed to reset deployments.
     * @return Result of the ResetDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ResetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetDeploymentsResponse resetDeployments(Consumer<ResetDeploymentsRequest.Builder> resetDeploymentsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return resetDeployments(ResetDeploymentsRequest.builder().applyMutation(resetDeploymentsRequest).build());
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.
     *
     * @param startBulkDeploymentRequest
     * @return Result of the StartBulkDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.StartBulkDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBulkDeploymentResponse startBulkDeployment(StartBulkDeploymentRequest startBulkDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBulkDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StartBulkDeploymentRequest#builder()}
     * </p>
     *
     * @param startBulkDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StartBulkDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the StartBulkDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.StartBulkDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBulkDeploymentResponse startBulkDeployment(
            Consumer<StartBulkDeploymentRequest.Builder> startBulkDeploymentRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return startBulkDeployment(StartBulkDeploymentRequest.builder().applyMutation(startBulkDeploymentRequest).build());
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.
     *
     * @param stopBulkDeploymentRequest
     * @return Result of the StopBulkDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.StopBulkDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default StopBulkDeploymentResponse stopBulkDeployment(StopBulkDeploymentRequest stopBulkDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBulkDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StopBulkDeploymentRequest#builder()}
     * </p>
     *
     * @param stopBulkDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StopBulkDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the StopBulkDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.StopBulkDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default StopBulkDeploymentResponse stopBulkDeployment(Consumer<StopBulkDeploymentRequest.Builder> stopBulkDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return stopBulkDeployment(StopBulkDeploymentRequest.builder().applyMutation(stopBulkDeploymentRequest).build());
    }

    /**
     * Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition', 'CoreDefinition',
     * 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition', 'SubscriptionDefinition', 'ResourceDefinition', and
     * 'BulkDeployment'.
     *
     * @param tagResourceRequest
     *        A map of the key-value pairs for the resource tag.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition', 'CoreDefinition',
     * 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition', 'SubscriptionDefinition', 'ResourceDefinition', and
     * 'BulkDeployment'.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. A map
     *        of the key-value pairs for the resource tag.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * Remove resource tags from a Greengrass Resource.
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Remove resource tags from a Greengrass Resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.
     *
     * @param updateConnectivityInfoRequest
     *        Connectivity information.
     * @return Result of the UpdateConnectivityInfo operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectivityInfoResponse updateConnectivityInfo(UpdateConnectivityInfoRequest updateConnectivityInfoRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectivityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectivityInfoRequest#builder()}
     * </p>
     *
     * @param updateConnectivityInfoRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectivityInfoRequest.Builder} to create a
     *        request. Connectivity information.
     * @return Result of the UpdateConnectivityInfo operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectivityInfoResponse updateConnectivityInfo(
            Consumer<UpdateConnectivityInfoRequest.Builder> updateConnectivityInfoRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        return updateConnectivityInfo(UpdateConnectivityInfoRequest.builder().applyMutation(updateConnectivityInfoRequest)
                .build());
    }

    /**
     * Updates a connector definition.
     *
     * @param updateConnectorDefinitionRequest
     * @return Result of the UpdateConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectorDefinitionResponse updateConnectorDefinition(
            UpdateConnectorDefinitionRequest updateConnectorDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a connector definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConnectorDefinitionRequest#builder()}
     * </p>
     *
     * @param updateConnectorDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectorDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectorDefinitionResponse updateConnectorDefinition(
            Consumer<UpdateConnectorDefinitionRequest.Builder> updateConnectorDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateConnectorDefinition(UpdateConnectorDefinitionRequest.builder()
                .applyMutation(updateConnectorDefinitionRequest).build());
    }

    /**
     * Updates a core definition.
     *
     * @param updateCoreDefinitionRequest
     * @return Result of the UpdateCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCoreDefinitionResponse updateCoreDefinition(UpdateCoreDefinitionRequest updateCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a core definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCoreDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCoreDefinitionRequest#builder()}
     * </p>
     *
     * @param updateCoreDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCoreDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCoreDefinitionResponse updateCoreDefinition(
            Consumer<UpdateCoreDefinitionRequest.Builder> updateCoreDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateCoreDefinition(UpdateCoreDefinitionRequest.builder().applyMutation(updateCoreDefinitionRequest).build());
    }

    /**
     * Updates a device definition.
     *
     * @param updateDeviceDefinitionRequest
     * @return Result of the UpdateDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeviceDefinitionResponse updateDeviceDefinition(UpdateDeviceDefinitionRequest updateDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a device definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceDefinitionRequest#builder()}
     * </p>
     *
     * @param updateDeviceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeviceDefinitionResponse updateDeviceDefinition(
            Consumer<UpdateDeviceDefinitionRequest.Builder> updateDeviceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateDeviceDefinition(UpdateDeviceDefinitionRequest.builder().applyMutation(updateDeviceDefinitionRequest)
                .build());
    }

    /**
     * Updates a Lambda function definition.
     *
     * @param updateFunctionDefinitionRequest
     * @return Result of the UpdateFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionDefinitionResponse updateFunctionDefinition(
            UpdateFunctionDefinitionRequest updateFunctionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a Lambda function definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFunctionDefinitionRequest#builder()}
     * </p>
     *
     * @param updateFunctionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionDefinitionResponse updateFunctionDefinition(
            Consumer<UpdateFunctionDefinitionRequest.Builder> updateFunctionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateFunctionDefinition(UpdateFunctionDefinitionRequest.builder().applyMutation(updateFunctionDefinitionRequest)
                .build());
    }

    /**
     * Updates a group.
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * Updates the Certificate expiry time for a group.
     *
     * @param updateGroupCertificateConfigurationRequest
     * @return Result of the UpdateGroupCertificateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateGroupCertificateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGroupCertificateConfigurationResponse updateGroupCertificateConfiguration(
            UpdateGroupCertificateConfigurationRequest updateGroupCertificateConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the Certificate expiry time for a group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupCertificateConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateGroupCertificateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateGroupCertificateConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupCertificateConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateGroupCertificateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateGroupCertificateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGroupCertificateConfigurationResponse updateGroupCertificateConfiguration(
            Consumer<UpdateGroupCertificateConfigurationRequest.Builder> updateGroupCertificateConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return updateGroupCertificateConfiguration(UpdateGroupCertificateConfigurationRequest.builder()
                .applyMutation(updateGroupCertificateConfigurationRequest).build());
    }

    /**
     * Updates a logger definition.
     *
     * @param updateLoggerDefinitionRequest
     * @return Result of the UpdateLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoggerDefinitionResponse updateLoggerDefinition(UpdateLoggerDefinitionRequest updateLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a logger definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoggerDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLoggerDefinitionRequest#builder()}
     * </p>
     *
     * @param updateLoggerDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLoggerDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoggerDefinitionResponse updateLoggerDefinition(
            Consumer<UpdateLoggerDefinitionRequest.Builder> updateLoggerDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateLoggerDefinition(UpdateLoggerDefinitionRequest.builder().applyMutation(updateLoggerDefinitionRequest)
                .build());
    }

    /**
     * Updates a resource definition.
     *
     * @param updateResourceDefinitionRequest
     * @return Result of the UpdateResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceDefinitionResponse updateResourceDefinition(
            UpdateResourceDefinitionRequest updateResourceDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a resource definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateResourceDefinitionRequest#builder()}
     * </p>
     *
     * @param updateResourceDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceDefinitionResponse updateResourceDefinition(
            Consumer<UpdateResourceDefinitionRequest.Builder> updateResourceDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        return updateResourceDefinition(UpdateResourceDefinitionRequest.builder().applyMutation(updateResourceDefinitionRequest)
                .build());
    }

    /**
     * Updates a subscription definition.
     *
     * @param updateSubscriptionDefinitionRequest
     * @return Result of the UpdateSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubscriptionDefinitionResponse updateSubscriptionDefinition(
            UpdateSubscriptionDefinitionRequest updateSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a subscription definition.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubscriptionDefinitionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriptionDefinitionRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubscriptionDefinitionResponse updateSubscriptionDefinition(
            Consumer<UpdateSubscriptionDefinitionRequest.Builder> updateSubscriptionDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        return updateSubscriptionDefinition(UpdateSubscriptionDefinitionRequest.builder()
                .applyMutation(updateSubscriptionDefinitionRequest).build());
    }

    /**
     * Updates the runtime configuration of a thing.
     *
     * @param updateThingRuntimeConfigurationRequest
     * @return Result of the UpdateThingRuntimeConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateThingRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateThingRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateThingRuntimeConfigurationResponse updateThingRuntimeConfiguration(
            UpdateThingRuntimeConfigurationRequest updateThingRuntimeConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the runtime configuration of a thing.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThingRuntimeConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateThingRuntimeConfigurationRequest#builder()}
     * </p>
     *
     * @param updateThingRuntimeConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThingRuntimeConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateThingRuntimeConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateThingRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateThingRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateThingRuntimeConfigurationResponse updateThingRuntimeConfiguration(
            Consumer<UpdateThingRuntimeConfigurationRequest.Builder> updateThingRuntimeConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        return updateThingRuntimeConfiguration(UpdateThingRuntimeConfigurationRequest.builder()
                .applyMutation(updateThingRuntimeConfigurationRequest).build());
    }

    /**
     * Create a {@link GreengrassClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GreengrassClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GreengrassClient}.
     */
    static GreengrassClientBuilder builder() {
        return new DefaultGreengrassClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
