/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that define an Amazon SageMaker machine learning resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SageMakerMachineLearningModelResourceData implements SdkPojo, Serializable,
        ToCopyableBuilder<SageMakerMachineLearningModelResourceData.Builder, SageMakerMachineLearningModelResourceData> {
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPath").getter(getter(SageMakerMachineLearningModelResourceData::destinationPath))
            .setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()).build();

    private static final SdkField<ResourceDownloadOwnerSetting> OWNER_SETTING_FIELD = SdkField
            .<ResourceDownloadOwnerSetting> builder(MarshallingType.SDK_POJO).memberName("OwnerSetting")
            .getter(getter(SageMakerMachineLearningModelResourceData::ownerSetting)).setter(setter(Builder::ownerSetting))
            .constructor(ResourceDownloadOwnerSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerSetting").build()).build();

    private static final SdkField<String> SAGE_MAKER_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SageMakerJobArn").getter(getter(SageMakerMachineLearningModelResourceData::sageMakerJobArn))
            .setter(setter(Builder::sageMakerJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PATH_FIELD,
            OWNER_SETTING_FIELD, SAGE_MAKER_JOB_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationPath;

    private final ResourceDownloadOwnerSetting ownerSetting;

    private final String sageMakerJobArn;

    private SageMakerMachineLearningModelResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.ownerSetting = builder.ownerSetting;
        this.sageMakerJobArn = builder.sageMakerJobArn;
    }

    /**
     * The absolute local path of the resource inside the Lambda environment.
     * 
     * @return The absolute local path of the resource inside the Lambda environment.
     */
    public final String destinationPath() {
        return destinationPath;
    }

    /**
     * Returns the value of the OwnerSetting property for this object.
     * 
     * @return The value of the OwnerSetting property for this object.
     */
    public final ResourceDownloadOwnerSetting ownerSetting() {
        return ownerSetting;
    }

    /**
     * The ARN of the Amazon SageMaker training job that represents the source model.
     * 
     * @return The ARN of the Amazon SageMaker training job that represents the source model.
     */
    public final String sageMakerJobArn() {
        return sageMakerJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(ownerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerMachineLearningModelResourceData)) {
            return false;
        }
        SageMakerMachineLearningModelResourceData other = (SageMakerMachineLearningModelResourceData) obj;
        return Objects.equals(destinationPath(), other.destinationPath()) && Objects.equals(ownerSetting(), other.ownerSetting())
                && Objects.equals(sageMakerJobArn(), other.sageMakerJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SageMakerMachineLearningModelResourceData").add("DestinationPath", destinationPath())
                .add("OwnerSetting", ownerSetting()).add("SageMakerJobArn", sageMakerJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        case "OwnerSetting":
            return Optional.ofNullable(clazz.cast(ownerSetting()));
        case "SageMakerJobArn":
            return Optional.ofNullable(clazz.cast(sageMakerJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SageMakerMachineLearningModelResourceData, T> g) {
        return obj -> g.apply((SageMakerMachineLearningModelResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SageMakerMachineLearningModelResourceData> {
        /**
         * The absolute local path of the resource inside the Lambda environment.
         * 
         * @param destinationPath
         *        The absolute local path of the resource inside the Lambda environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);

        /**
         * Sets the value of the OwnerSetting property for this object.
         *
         * @param ownerSetting
         *        The new value for the OwnerSetting property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerSetting(ResourceDownloadOwnerSetting ownerSetting);

        /**
         * Sets the value of the OwnerSetting property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceDownloadOwnerSetting.Builder}
         * avoiding the need to create one manually via {@link ResourceDownloadOwnerSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDownloadOwnerSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #ownerSetting(ResourceDownloadOwnerSetting)}.
         * 
         * @param ownerSetting
         *        a consumer that will call methods on {@link ResourceDownloadOwnerSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerSetting(ResourceDownloadOwnerSetting)
         */
        default Builder ownerSetting(Consumer<ResourceDownloadOwnerSetting.Builder> ownerSetting) {
            return ownerSetting(ResourceDownloadOwnerSetting.builder().applyMutation(ownerSetting).build());
        }

        /**
         * The ARN of the Amazon SageMaker training job that represents the source model.
         * 
         * @param sageMakerJobArn
         *        The ARN of the Amazon SageMaker training job that represents the source model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerJobArn(String sageMakerJobArn);
    }

    static final class BuilderImpl implements Builder {
        private String destinationPath;

        private ResourceDownloadOwnerSetting ownerSetting;

        private String sageMakerJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerMachineLearningModelResourceData model) {
            destinationPath(model.destinationPath);
            ownerSetting(model.ownerSetting);
            sageMakerJobArn(model.sageMakerJobArn);
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final ResourceDownloadOwnerSetting.Builder getOwnerSetting() {
            return ownerSetting != null ? ownerSetting.toBuilder() : null;
        }

        public final void setOwnerSetting(ResourceDownloadOwnerSetting.BuilderImpl ownerSetting) {
            this.ownerSetting = ownerSetting != null ? ownerSetting.build() : null;
        }

        @Override
        public final Builder ownerSetting(ResourceDownloadOwnerSetting ownerSetting) {
            this.ownerSetting = ownerSetting;
            return this;
        }

        public final String getSageMakerJobArn() {
            return sageMakerJobArn;
        }

        public final void setSageMakerJobArn(String sageMakerJobArn) {
            this.sageMakerJobArn = sageMakerJobArn;
        }

        @Override
        public final Builder sageMakerJobArn(String sageMakerJobArn) {
            this.sageMakerJobArn = sageMakerJobArn;
            return this;
        }

        @Override
        public SageMakerMachineLearningModelResourceData build() {
            return new SageMakerMachineLearningModelResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
