/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a core definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreDefinitionVersion.Builder, CoreDefinitionVersion> {
    private static final SdkField<List<Core>> CORES_FIELD = SdkField
            .<List<Core>> builder(MarshallingType.LIST)
            .getter(getter(CoreDefinitionVersion::cores))
            .setter(setter(Builder::cores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Core> builder(MarshallingType.SDK_POJO)
                                            .constructor(Core::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Core> cores;

    private CoreDefinitionVersion(BuilderImpl builder) {
        this.cores = builder.cores;
    }

    /**
     * A list of cores in the core definition version.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of cores in the core definition version.
     */
    public List<Core> cores() {
        return cores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cores());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreDefinitionVersion)) {
            return false;
        }
        CoreDefinitionVersion other = (CoreDefinitionVersion) obj;
        return Objects.equals(cores(), other.cores());
    }

    @Override
    public String toString() {
        return ToString.builder("CoreDefinitionVersion").add("Cores", cores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cores":
            return Optional.ofNullable(clazz.cast(cores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreDefinitionVersion, T> g) {
        return obj -> g.apply((CoreDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreDefinitionVersion> {
        /**
         * A list of cores in the core definition version.
         * 
         * @param cores
         *        A list of cores in the core definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Collection<Core> cores);

        /**
         * A list of cores in the core definition version.
         * 
         * @param cores
         *        A list of cores in the core definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Core... cores);

        /**
         * A list of cores in the core definition version. This is a convenience that creates an instance of the
         * {@link List<Core>.Builder} avoiding the need to create one manually via {@link List<Core>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Core>.Builder#build()} is called immediately and its result
         * is passed to {@link #cores(List<Core>)}.
         * 
         * @param cores
         *        a consumer that will call methods on {@link List<Core>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cores(List<Core>)
         */
        Builder cores(Consumer<Core.Builder>... cores);
    }

    static final class BuilderImpl implements Builder {
        private List<Core> cores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreDefinitionVersion model) {
            cores(model.cores);
        }

        public final Collection<Core.Builder> getCores() {
            return cores != null ? cores.stream().map(Core::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ___listOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core... cores) {
            cores(Arrays.asList(cores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Consumer<Core.Builder>... cores) {
            cores(Stream.of(cores).map(c -> Core.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCores(Collection<Core.BuilderImpl> cores) {
            this.cores = ___listOfCoreCopier.copyFromBuilder(cores);
        }

        @Override
        public CoreDefinitionVersion build() {
            return new CoreDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
