/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCoreDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<CreateCoreDefinitionVersionRequest.Builder, CreateCoreDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCoreDefinitionVersionRequest::amznClientToken)).setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<String> CORE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCoreDefinitionVersionRequest::coreDefinitionId)).setter(setter(Builder::coreDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CoreDefinitionId").build()).build();

    private static final SdkField<List<Core>> CORES_FIELD = SdkField
            .<List<Core>> builder(MarshallingType.LIST)
            .getter(getter(CreateCoreDefinitionVersionRequest::cores))
            .setter(setter(Builder::cores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Core> builder(MarshallingType.SDK_POJO)
                                            .constructor(Core::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            CORE_DEFINITION_ID_FIELD, CORES_FIELD));

    private final String amznClientToken;

    private final String coreDefinitionId;

    private final List<Core> cores;

    private CreateCoreDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.coreDefinitionId = builder.coreDefinitionId;
        this.cores = builder.cores;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public String amznClientToken() {
        return amznClientToken;
    }

    /**
     * The ID of the core definition.
     * 
     * @return The ID of the core definition.
     */
    public String coreDefinitionId() {
        return coreDefinitionId;
    }

    /**
     * A list of cores in the core definition version.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of cores in the core definition version.
     */
    public List<Core> cores() {
        return cores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(coreDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(cores());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoreDefinitionVersionRequest)) {
            return false;
        }
        CreateCoreDefinitionVersionRequest other = (CreateCoreDefinitionVersionRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(coreDefinitionId(), other.coreDefinitionId()) && Objects.equals(cores(), other.cores());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCoreDefinitionVersionRequest").add("AmznClientToken", amznClientToken())
                .add("CoreDefinitionId", coreDefinitionId()).add("Cores", cores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "CoreDefinitionId":
            return Optional.ofNullable(clazz.cast(coreDefinitionId()));
        case "Cores":
            return Optional.ofNullable(clazz.cast(cores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCoreDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateCoreDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * The ID of the core definition.
         * 
         * @param coreDefinitionId
         *        The ID of the core definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDefinitionId(String coreDefinitionId);

        /**
         * A list of cores in the core definition version.
         * 
         * @param cores
         *        A list of cores in the core definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Collection<Core> cores);

        /**
         * A list of cores in the core definition version.
         * 
         * @param cores
         *        A list of cores in the core definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Core... cores);

        /**
         * A list of cores in the core definition version. This is a convenience that creates an instance of the
         * {@link List<Core>.Builder} avoiding the need to create one manually via {@link List<Core>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Core>.Builder#build()} is called immediately and its result
         * is passed to {@link #cores(List<Core>)}.
         * 
         * @param cores
         *        a consumer that will call methods on {@link List<Core>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cores(List<Core>)
         */
        Builder cores(Consumer<Core.Builder>... cores);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private String coreDefinitionId;

        private List<Core> cores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCoreDefinitionVersionRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            coreDefinitionId(model.coreDefinitionId);
            cores(model.cores);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getCoreDefinitionId() {
            return coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        public final Collection<Core.Builder> getCores() {
            return cores != null ? cores.stream().map(Core::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ___listOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core... cores) {
            cores(Arrays.asList(cores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Consumer<Core.Builder>... cores) {
            cores(Stream.of(cores).map(c -> Core.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCores(Collection<Core.BuilderImpl> cores) {
            this.cores = ___listOfCoreCopier.copyFromBuilder(cores);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCoreDefinitionVersionRequest build() {
            return new CreateCoreDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
