/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCoreDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<DeleteCoreDefinitionRequest.Builder, DeleteCoreDefinitionRequest> {
    private static final SdkField<String> CORE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteCoreDefinitionRequest::coreDefinitionId)).setter(setter(Builder::coreDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CoreDefinitionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEFINITION_ID_FIELD));

    private final String coreDefinitionId;

    private DeleteCoreDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.coreDefinitionId = builder.coreDefinitionId;
    }

    /**
     * The ID of the core definition.
     * 
     * @return The ID of the core definition.
     */
    public String coreDefinitionId() {
        return coreDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreDefinitionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCoreDefinitionRequest)) {
            return false;
        }
        DeleteCoreDefinitionRequest other = (DeleteCoreDefinitionRequest) obj;
        return Objects.equals(coreDefinitionId(), other.coreDefinitionId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteCoreDefinitionRequest").add("CoreDefinitionId", coreDefinitionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreDefinitionId":
            return Optional.ofNullable(clazz.cast(coreDefinitionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCoreDefinitionRequest, T> g) {
        return obj -> g.apply((DeleteCoreDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCoreDefinitionRequest> {
        /**
         * The ID of the core definition.
         * 
         * @param coreDefinitionId
         *        The ID of the core definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDefinitionId(String coreDefinitionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String coreDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCoreDefinitionRequest model) {
            super(model);
            coreDefinitionId(model.coreDefinitionId);
        }

        public final String getCoreDefinitionId() {
            return coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCoreDefinitionRequest build() {
            return new DeleteCoreDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
