/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration that defines the default containerization used for when running Lambda functions in the group.
 * Individual Lambda functions can be override this setting.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionDefaultExecutionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionDefaultExecutionConfig.Builder, FunctionDefaultExecutionConfig> {
    private static final SdkField<String> ISOLATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionDefaultExecutionConfig::isolationModeAsString)).setter(setter(Builder::isolationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISOLATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String isolationMode;

    private FunctionDefaultExecutionConfig(BuilderImpl builder) {
        this.isolationMode = builder.isolationMode;
    }

    /**
     * Returns the value of the IsolationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isolationMode}
     * will return {@link FunctionIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #isolationModeAsString}.
     * </p>
     * 
     * @return The value of the IsolationMode property for this object.
     * @see FunctionIsolationMode
     */
    public FunctionIsolationMode isolationMode() {
        return FunctionIsolationMode.fromValue(isolationMode);
    }

    /**
     * Returns the value of the IsolationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isolationMode}
     * will return {@link FunctionIsolationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #isolationModeAsString}.
     * </p>
     * 
     * @return The value of the IsolationMode property for this object.
     * @see FunctionIsolationMode
     */
    public String isolationModeAsString() {
        return isolationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isolationModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefaultExecutionConfig)) {
            return false;
        }
        FunctionDefaultExecutionConfig other = (FunctionDefaultExecutionConfig) obj;
        return Objects.equals(isolationModeAsString(), other.isolationModeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("FunctionDefaultExecutionConfig").add("IsolationMode", isolationModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsolationMode":
            return Optional.ofNullable(clazz.cast(isolationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionDefaultExecutionConfig, T> g) {
        return obj -> g.apply((FunctionDefaultExecutionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionDefaultExecutionConfig> {
        /**
         * Sets the value of the IsolationMode property for this object.
         *
         * @param isolationMode
         *        The new value for the IsolationMode property for this object.
         * @see FunctionIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionIsolationMode
         */
        Builder isolationMode(String isolationMode);

        /**
         * Sets the value of the IsolationMode property for this object.
         *
         * @param isolationMode
         *        The new value for the IsolationMode property for this object.
         * @see FunctionIsolationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionIsolationMode
         */
        Builder isolationMode(FunctionIsolationMode isolationMode);
    }

    static final class BuilderImpl implements Builder {
        private String isolationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefaultExecutionConfig model) {
            isolationMode(model.isolationMode);
        }

        public final String getIsolationModeAsString() {
            return isolationMode;
        }

        @Override
        public final Builder isolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
            return this;
        }

        @Override
        public final Builder isolationMode(FunctionIsolationMode isolationMode) {
            this.isolationMode(isolationMode.toString());
            return this;
        }

        public final void setIsolationMode(String isolationMode) {
            this.isolationMode = isolationMode;
        }

        @Override
        public FunctionDefaultExecutionConfig build() {
            return new FunctionDefaultExecutionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
