/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectorDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetConnectorDefinitionVersionRequest.Builder, GetConnectorDefinitionVersionRequest> {
    private static final SdkField<String> CONNECTOR_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConnectorDefinitionVersionRequest::connectorDefinitionId))
            .setter(setter(Builder::connectorDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorDefinitionId").build())
            .build();

    private static final SdkField<String> CONNECTOR_DEFINITION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetConnectorDefinitionVersionRequest::connectorDefinitionVersionId))
            .setter(setter(Builder::connectorDefinitionVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorDefinitionVersionId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConnectorDefinitionVersionRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DEFINITION_ID_FIELD,
            CONNECTOR_DEFINITION_VERSION_ID_FIELD, NEXT_TOKEN_FIELD));

    private final String connectorDefinitionId;

    private final String connectorDefinitionVersionId;

    private final String nextToken;

    private GetConnectorDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.connectorDefinitionId = builder.connectorDefinitionId;
        this.connectorDefinitionVersionId = builder.connectorDefinitionVersionId;
        this.nextToken = builder.nextToken;
    }

    /**
     * The ID of the connector definition.
     * 
     * @return The ID of the connector definition.
     */
    public String connectorDefinitionId() {
        return connectorDefinitionId;
    }

    /**
     * The ID of the connector definition version.
     * 
     * @return The ID of the connector definition version.
     */
    public String connectorDefinitionVersionId() {
        return connectorDefinitionVersionId;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDefinitionVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorDefinitionVersionRequest)) {
            return false;
        }
        GetConnectorDefinitionVersionRequest other = (GetConnectorDefinitionVersionRequest) obj;
        return Objects.equals(connectorDefinitionId(), other.connectorDefinitionId())
                && Objects.equals(connectorDefinitionVersionId(), other.connectorDefinitionVersionId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetConnectorDefinitionVersionRequest").add("ConnectorDefinitionId", connectorDefinitionId())
                .add("ConnectorDefinitionVersionId", connectorDefinitionVersionId()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorDefinitionId":
            return Optional.ofNullable(clazz.cast(connectorDefinitionId()));
        case "ConnectorDefinitionVersionId":
            return Optional.ofNullable(clazz.cast(connectorDefinitionVersionId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorDefinitionVersionRequest, T> g) {
        return obj -> g.apply((GetConnectorDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectorDefinitionVersionRequest> {
        /**
         * The ID of the connector definition.
         * 
         * @param connectorDefinitionId
         *        The ID of the connector definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDefinitionId(String connectorDefinitionId);

        /**
         * The ID of the connector definition version.
         * 
         * @param connectorDefinitionVersionId
         *        The ID of the connector definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDefinitionVersionId(String connectorDefinitionVersionId);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String connectorDefinitionId;

        private String connectorDefinitionVersionId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorDefinitionVersionRequest model) {
            super(model);
            connectorDefinitionId(model.connectorDefinitionId);
            connectorDefinitionVersionId(model.connectorDefinitionVersionId);
            nextToken(model.nextToken);
        }

        public final String getConnectorDefinitionId() {
            return connectorDefinitionId;
        }

        @Override
        public final Builder connectorDefinitionId(String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
            return this;
        }

        public final void setConnectorDefinitionId(String connectorDefinitionId) {
            this.connectorDefinitionId = connectorDefinitionId;
        }

        public final String getConnectorDefinitionVersionId() {
            return connectorDefinitionVersionId;
        }

        @Override
        public final Builder connectorDefinitionVersionId(String connectorDefinitionVersionId) {
            this.connectorDefinitionVersionId = connectorDefinitionVersionId;
            return this;
        }

        public final void setConnectorDefinitionVersionId(String connectorDefinitionVersionId) {
            this.connectorDefinitionVersionId = connectorDefinitionVersionId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConnectorDefinitionVersionRequest build() {
            return new GetConnectorDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
