/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoreDefinitionVersionsResponse extends GreengrassResponse implements
        ToCopyableBuilder<ListCoreDefinitionVersionsResponse.Builder, ListCoreDefinitionVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCoreDefinitionVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<VersionInformation>> VERSIONS_FIELD = SdkField
            .<List<VersionInformation>> builder(MarshallingType.LIST)
            .getter(getter(ListCoreDefinitionVersionsResponse::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VersionInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VersionInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VERSIONS_FIELD));

    private final String nextToken;

    private final List<VersionInformation> versions;

    private ListCoreDefinitionVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.versions = builder.versions;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Information about a version.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about a version.
     */
    public List<VersionInformation> versions() {
        return versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreDefinitionVersionsResponse)) {
            return false;
        }
        ListCoreDefinitionVersionsResponse other = (ListCoreDefinitionVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(versions(), other.versions());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCoreDefinitionVersionsResponse").add("NextToken", nextToken()).add("Versions", versions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoreDefinitionVersionsResponse, T> g) {
        return obj -> g.apply((ListCoreDefinitionVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCoreDefinitionVersionsResponse> {
        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Information about a version.
         * 
         * @param versions
         *        Information about a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<VersionInformation> versions);

        /**
         * Information about a version.
         * 
         * @param versions
         *        Information about a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(VersionInformation... versions);

        /**
         * Information about a version. This is a convenience that creates an instance of the {@link List
         * <VersionInformation>.Builder} avoiding the need to create one manually via {@link List
         * <VersionInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VersionInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #versions(List<VersionInformation>)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link List<VersionInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(List<VersionInformation>)
         */
        Builder versions(Consumer<VersionInformation.Builder>... versions);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VersionInformation> versions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreDefinitionVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            versions(model.versions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VersionInformation.Builder> getVersions() {
            return versions != null ? versions.stream().map(VersionInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<VersionInformation> versions) {
            this.versions = ___listOfVersionInformationCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(VersionInformation... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<VersionInformation.Builder>... versions) {
            versions(Stream.of(versions).map(c -> VersionInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<VersionInformation.BuilderImpl> versions) {
            this.versions = ___listOfVersionInformationCopier.copyFromBuilder(versions);
        }

        @Override
        public ListCoreDefinitionVersionsResponse build() {
            return new ListCoreDefinitionVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
