/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a logger
 */
@Generated("software.amazon.awssdk:codegen")
public final class Logger implements SdkPojo, Serializable, ToCopyableBuilder<Logger.Builder, Logger> {
    private static final SdkField<String> COMPONENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Logger::componentAsString)).setter(setter(Builder::component))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Logger::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Logger::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()).build();

    private static final SdkField<Integer> SPACE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Logger::space)).setter(setter(Builder::space))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Space").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Logger::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_FIELD, ID_FIELD,
            LEVEL_FIELD, SPACE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String component;

    private final String id;

    private final String level;

    private final Integer space;

    private final String type;

    private Logger(BuilderImpl builder) {
        this.component = builder.component;
        this.id = builder.id;
        this.level = builder.level;
        this.space = builder.space;
        this.type = builder.type;
    }

    /**
     * The component that will be subject to logging.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #component} will
     * return {@link LoggerComponent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #componentAsString}.
     * </p>
     * 
     * @return The component that will be subject to logging.
     * @see LoggerComponent
     */
    public LoggerComponent component() {
        return LoggerComponent.fromValue(component);
    }

    /**
     * The component that will be subject to logging.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #component} will
     * return {@link LoggerComponent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #componentAsString}.
     * </p>
     * 
     * @return The component that will be subject to logging.
     * @see LoggerComponent
     */
    public String componentAsString() {
        return component;
    }

    /**
     * A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition version. Max
     * length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     * 
     * @return A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition
     *         version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     */
    public String id() {
        return id;
    }

    /**
     * The level of the logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LoggerLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The level of the logs.
     * @see LoggerLevel
     */
    public LoggerLevel level() {
        return LoggerLevel.fromValue(level);
    }

    /**
     * The level of the logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LoggerLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The level of the logs.
     * @see LoggerLevel
     */
    public String levelAsString() {
        return level;
    }

    /**
     * The amount of file space, in KB, to use if the local file system is used for logging purposes.
     * 
     * @return The amount of file space, in KB, to use if the local file system is used for logging purposes.
     */
    public Integer space() {
        return space;
    }

    /**
     * The type of log output which will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LoggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of log output which will be used.
     * @see LoggerType
     */
    public LoggerType type() {
        return LoggerType.fromValue(type);
    }

    /**
     * The type of log output which will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LoggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of log output which will be used.
     * @see LoggerType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(space());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logger)) {
            return false;
        }
        Logger other = (Logger) obj;
        return Objects.equals(componentAsString(), other.componentAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(levelAsString(), other.levelAsString()) && Objects.equals(space(), other.space())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Logger").add("Component", componentAsString()).add("Id", id()).add("Level", levelAsString())
                .add("Space", space()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Component":
            return Optional.ofNullable(clazz.cast(componentAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "Space":
            return Optional.ofNullable(clazz.cast(space()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Logger, T> g) {
        return obj -> g.apply((Logger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Logger> {
        /**
         * The component that will be subject to logging.
         * 
         * @param component
         *        The component that will be subject to logging.
         * @see LoggerComponent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggerComponent
         */
        Builder component(String component);

        /**
         * The component that will be subject to logging.
         * 
         * @param component
         *        The component that will be subject to logging.
         * @see LoggerComponent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggerComponent
         */
        Builder component(LoggerComponent component);

        /**
         * A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition version.
         * Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * 
         * @param id
         *        A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition
         *        version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The level of the logs.
         * 
         * @param level
         *        The level of the logs.
         * @see LoggerLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggerLevel
         */
        Builder level(String level);

        /**
         * The level of the logs.
         * 
         * @param level
         *        The level of the logs.
         * @see LoggerLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggerLevel
         */
        Builder level(LoggerLevel level);

        /**
         * The amount of file space, in KB, to use if the local file system is used for logging purposes.
         * 
         * @param space
         *        The amount of file space, in KB, to use if the local file system is used for logging purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder space(Integer space);

        /**
         * The type of log output which will be used.
         * 
         * @param type
         *        The type of log output which will be used.
         * @see LoggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggerType
         */
        Builder type(String type);

        /**
         * The type of log output which will be used.
         * 
         * @param type
         *        The type of log output which will be used.
         * @see LoggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggerType
         */
        Builder type(LoggerType type);
    }

    static final class BuilderImpl implements Builder {
        private String component;

        private String id;

        private String level;

        private Integer space;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Logger model) {
            component(model.component);
            id(model.id);
            level(model.level);
            space(model.space);
            type(model.type);
        }

        public final String getComponentAsString() {
            return component;
        }

        @Override
        public final Builder component(String component) {
            this.component = component;
            return this;
        }

        @Override
        public final Builder component(LoggerComponent component) {
            this.component(component.toString());
            return this;
        }

        public final void setComponent(String component) {
            this.component = component;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLevelAsString() {
            return level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggerLevel level) {
            this.level(level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Integer getSpace() {
            return space;
        }

        @Override
        public final Builder space(Integer space) {
            this.space = space;
            return this;
        }

        public final void setSpace(Integer space) {
            this.space = space;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoggerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Logger build() {
            return new Logger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
