/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A policy used by the function to access a resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceAccessPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceAccessPolicy.Builder, ResourceAccessPolicy> {
    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceAccessPolicy::permissionAsString)).setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceAccessPolicy::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD,
            RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String permission;

    private final String resourceId;

    private ResourceAccessPolicy(BuilderImpl builder) {
        this.permission = builder.permission;
        this.resourceId = builder.resourceId;
    }

    /**
     * The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro''
     * (read-only).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro''
     *         (read-only).
     * @see Permission
     */
    public Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro''
     * (read-only).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro''
     *         (read-only).
     * @see Permission
     */
    public String permissionAsString() {
        return permission;
    }

    /**
     * The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
     * 
     * @return The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceAccessPolicy)) {
            return false;
        }
        ResourceAccessPolicy other = (ResourceAccessPolicy) obj;
        return Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(resourceId(), other.resourceId());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceAccessPolicy").add("Permission", permissionAsString()).add("ResourceId", resourceId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceAccessPolicy, T> g) {
        return obj -> g.apply((ResourceAccessPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceAccessPolicy> {
        /**
         * The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro''
         * (read-only).
         * 
         * @param permission
         *        The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or
         *        ''ro'' (read-only).
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro''
         * (read-only).
         * 
         * @param permission
         *        The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or
         *        ''ro'' (read-only).
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);

        /**
         * The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
         * 
         * @param resourceId
         *        The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private String permission;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceAccessPolicy model) {
            permission(model.permission);
            resourceId(model.resourceId);
        }

        public final String getPermissionAsString() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public ResourceAccessPolicy build() {
            return new ResourceAccessPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
