/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * General error information.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BadRequestException extends GreengrassException implements
        ToCopyableBuilder<BadRequestException.Builder, BadRequestException> {
    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .memberName("ErrorDetails")
            .getter(getter(BadRequestException::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ErrorDetail> errorDetails;

    private BadRequestException(BuilderImpl builder) {
        super(builder);
        this.errorDetails = builder.errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasErrorDetails() {
        return errorDetails != null && !(errorDetails instanceof SdkAutoConstructList);
    }

    /**
     * Details about the error.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorDetails} method.
     * </p>
     * 
     * @return Details about the error.
     */
    public List<ErrorDetail> errorDetails() {
        return errorDetails;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BadRequestException, T> g) {
        return obj -> g.apply((BadRequestException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BadRequestException>, GreengrassException.Builder {
        /**
         * Details about the error.
         * 
         * @param errorDetails
         *        Details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(Collection<ErrorDetail> errorDetails);

        /**
         * Details about the error.
         * 
         * @param errorDetails
         *        Details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetail... errorDetails);

        /**
         * Details about the error. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrass.model.ErrorDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.greengrass.model.ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrass.model.ErrorDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #errorDetails(List<ErrorDetail>)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrass.model.ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(java.util.Collection<ErrorDetail>)
         */
        Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends GreengrassException.BuilderImpl implements Builder {
        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestException model) {
            super(model);
            errorDetails(model.errorDetails);
        }

        public final List<ErrorDetail.Builder> getErrorDetails() {
            List<ErrorDetail.Builder> result = ErrorDetailsCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail... errorDetails) {
            errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder>... errorDetails) {
            errorDetails(Stream.of(errorDetails).map(c -> ErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BadRequestException build() {
            return new BadRequestException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
