/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a function definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionDefinitionVersion.Builder, FunctionDefinitionVersion> {
    private static final SdkField<FunctionDefaultConfig> DEFAULT_CONFIG_FIELD = SdkField
            .<FunctionDefaultConfig> builder(MarshallingType.SDK_POJO).memberName("DefaultConfig")
            .getter(getter(FunctionDefinitionVersion::defaultConfig)).setter(setter(Builder::defaultConfig))
            .constructor(FunctionDefaultConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConfig").build()).build();

    private static final SdkField<List<Function>> FUNCTIONS_FIELD = SdkField
            .<List<Function>> builder(MarshallingType.LIST)
            .memberName("Functions")
            .getter(getter(FunctionDefinitionVersion::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Functions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Function> builder(MarshallingType.SDK_POJO)
                                            .constructor(Function::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_CONFIG_FIELD,
            FUNCTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FunctionDefaultConfig defaultConfig;

    private final List<Function> functions;

    private FunctionDefinitionVersion(BuilderImpl builder) {
        this.defaultConfig = builder.defaultConfig;
        this.functions = builder.functions;
    }

    /**
     * The default configuration that applies to all Lambda functions in this function definition version. Individual
     * Lambda functions can override these settings.
     * 
     * @return The default configuration that applies to all Lambda functions in this function definition version.
     *         Individual Lambda functions can override these settings.
     */
    public final FunctionDefaultConfig defaultConfig() {
        return defaultConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructList);
    }

    /**
     * A list of Lambda functions in this function definition version.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return A list of Lambda functions in this function definition version.
     */
    public final List<Function> functions() {
        return functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefinitionVersion)) {
            return false;
        }
        FunctionDefinitionVersion other = (FunctionDefinitionVersion) obj;
        return Objects.equals(defaultConfig(), other.defaultConfig()) && hasFunctions() == other.hasFunctions()
                && Objects.equals(functions(), other.functions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionDefinitionVersion").add("DefaultConfig", defaultConfig())
                .add("Functions", hasFunctions() ? functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultConfig":
            return Optional.ofNullable(clazz.cast(defaultConfig()));
        case "Functions":
            return Optional.ofNullable(clazz.cast(functions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultConfig", DEFAULT_CONFIG_FIELD);
        map.put("Functions", FUNCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<FunctionDefinitionVersion, T> g) {
        return obj -> g.apply((FunctionDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionDefinitionVersion> {
        /**
         * The default configuration that applies to all Lambda functions in this function definition version.
         * Individual Lambda functions can override these settings.
         * 
         * @param defaultConfig
         *        The default configuration that applies to all Lambda functions in this function definition version.
         *        Individual Lambda functions can override these settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultConfig(FunctionDefaultConfig defaultConfig);

        /**
         * The default configuration that applies to all Lambda functions in this function definition version.
         * Individual Lambda functions can override these settings. This is a convenience method that creates an
         * instance of the {@link FunctionDefaultConfig.Builder} avoiding the need to create one manually via
         * {@link FunctionDefaultConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionDefaultConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultConfig(FunctionDefaultConfig)}.
         * 
         * @param defaultConfig
         *        a consumer that will call methods on {@link FunctionDefaultConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultConfig(FunctionDefaultConfig)
         */
        default Builder defaultConfig(Consumer<FunctionDefaultConfig.Builder> defaultConfig) {
            return defaultConfig(FunctionDefaultConfig.builder().applyMutation(defaultConfig).build());
        }

        /**
         * A list of Lambda functions in this function definition version.
         * 
         * @param functions
         *        A list of Lambda functions in this function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Collection<Function> functions);

        /**
         * A list of Lambda functions in this function definition version.
         * 
         * @param functions
         *        A list of Lambda functions in this function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Function... functions);

        /**
         * A list of Lambda functions in this function definition version. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.greengrass.model.Function.Builder} avoiding the need
         * to create one manually via {@link software.amazon.awssdk.services.greengrass.model.Function#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrass.model.Function.Builder#build()} is called immediately and
         * its result is passed to {@link #functions(List<Function>)}.
         * 
         * @param functions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrass.model.Function.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functions(java.util.Collection<Function>)
         */
        Builder functions(Consumer<Function.Builder>... functions);
    }

    static final class BuilderImpl implements Builder {
        private FunctionDefaultConfig defaultConfig;

        private List<Function> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefinitionVersion model) {
            defaultConfig(model.defaultConfig);
            functions(model.functions);
        }

        public final FunctionDefaultConfig.Builder getDefaultConfig() {
            return defaultConfig != null ? defaultConfig.toBuilder() : null;
        }

        public final void setDefaultConfig(FunctionDefaultConfig.BuilderImpl defaultConfig) {
            this.defaultConfig = defaultConfig != null ? defaultConfig.build() : null;
        }

        @Override
        public final Builder defaultConfig(FunctionDefaultConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public final List<Function.Builder> getFunctions() {
            List<Function.Builder> result = ___listOfFunctionCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            this.functions = ___listOfFunctionCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ___listOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function... functions) {
            functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<Function.Builder>... functions) {
            functions(Stream.of(functions).map(c -> Function.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FunctionDefinitionVersion build() {
            return new FunctionDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
