/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both
 * values to override the default values. We recommend that you avoid running as root unless absolutely necessary to
 * minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to
 * ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionRunAsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionRunAsConfig.Builder, FunctionRunAsConfig> {
    private static final SdkField<Integer> GID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Gid")
            .getter(getter(FunctionRunAsConfig::gid)).setter(setter(Builder::gid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()).build();

    private static final SdkField<Integer> UID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Uid")
            .getter(getter(FunctionRunAsConfig::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GID_FIELD, UID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer gid;

    private final Integer uid;

    private FunctionRunAsConfig(BuilderImpl builder) {
        this.gid = builder.gid;
        this.uid = builder.uid;
    }

    /**
     * The group ID whose permissions are used to run a Lambda function.
     * 
     * @return The group ID whose permissions are used to run a Lambda function.
     */
    public final Integer gid() {
        return gid;
    }

    /**
     * The user ID whose permissions are used to run a Lambda function.
     * 
     * @return The user ID whose permissions are used to run a Lambda function.
     */
    public final Integer uid() {
        return uid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gid());
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionRunAsConfig)) {
            return false;
        }
        FunctionRunAsConfig other = (FunctionRunAsConfig) obj;
        return Objects.equals(gid(), other.gid()) && Objects.equals(uid(), other.uid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionRunAsConfig").add("Gid", gid()).add("Uid", uid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gid":
            return Optional.ofNullable(clazz.cast(gid()));
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Gid", GID_FIELD);
        map.put("Uid", UID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionRunAsConfig, T> g) {
        return obj -> g.apply((FunctionRunAsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionRunAsConfig> {
        /**
         * The group ID whose permissions are used to run a Lambda function.
         * 
         * @param gid
         *        The group ID whose permissions are used to run a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gid(Integer gid);

        /**
         * The user ID whose permissions are used to run a Lambda function.
         * 
         * @param uid
         *        The user ID whose permissions are used to run a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(Integer uid);
    }

    static final class BuilderImpl implements Builder {
        private Integer gid;

        private Integer uid;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionRunAsConfig model) {
            gid(model.gid);
            uid(model.uid);
        }

        public final Integer getGid() {
            return gid;
        }

        public final void setGid(Integer gid) {
            this.gid = gid;
        }

        @Override
        public final Builder gid(Integer gid) {
            this.gid = gid;
            return this;
        }

        public final Integer getUid() {
            return uid;
        }

        public final void setUid(Integer uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(Integer uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public FunctionRunAsConfig build() {
            return new FunctionRunAsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
