/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectorDefinitionResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetConnectorDefinitionResponse.Builder, GetConnectorDefinitionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetConnectorDefinitionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTimestamp").getter(getter(GetConnectorDefinitionResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetConnectorDefinitionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTimestamp").getter(getter(GetConnectorDefinitionResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestVersion").getter(getter(GetConnectorDefinitionResponse::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()).build();

    private static final SdkField<String> LATEST_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestVersionArn").getter(getter(GetConnectorDefinitionResponse::latestVersionArn))
            .setter(setter(Builder::latestVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConnectorDefinitionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetConnectorDefinitionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIMESTAMP_FIELD, ID_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, LATEST_VERSION_FIELD, LATEST_VERSION_ARN_FIELD,
            NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String creationTimestamp;

    private final String id;

    private final String lastUpdatedTimestamp;

    private final String latestVersion;

    private final String latestVersionArn;

    private final String name;

    private final Map<String, String> tags;

    private GetConnectorDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.id = builder.id;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.latestVersion = builder.latestVersion;
        this.latestVersionArn = builder.latestVersionArn;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * The ARN of the definition.
     * 
     * @return The ARN of the definition.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The time, in milliseconds since the epoch, when the definition was created.
     * 
     * @return The time, in milliseconds since the epoch, when the definition was created.
     */
    public final String creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * The ID of the definition.
     * 
     * @return The ID of the definition.
     */
    public final String id() {
        return id;
    }

    /**
     * The time, in milliseconds since the epoch, when the definition was last updated.
     * 
     * @return The time, in milliseconds since the epoch, when the definition was last updated.
     */
    public final String lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * The ID of the latest version associated with the definition.
     * 
     * @return The ID of the latest version associated with the definition.
     */
    public final String latestVersion() {
        return latestVersion;
    }

    /**
     * The ARN of the latest version associated with the definition.
     * 
     * @return The ARN of the latest version associated with the definition.
     */
    public final String latestVersionArn() {
        return latestVersionArn;
    }

    /**
     * The name of the definition.
     * 
     * @return The name of the definition.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Tag(s) attached to the resource arn.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tag(s) attached to the resource arn.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorDefinitionResponse)) {
            return false;
        }
        GetConnectorDefinitionResponse other = (GetConnectorDefinitionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(id(), other.id()) && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(latestVersionArn(), other.latestVersionArn()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectorDefinitionResponse").add("Arn", arn()).add("CreationTimestamp", creationTimestamp())
                .add("Id", id()).add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("LatestVersion", latestVersion())
                .add("LatestVersionArn", latestVersionArn()).add("Name", name()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "LatestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "LatestVersionArn":
            return Optional.ofNullable(clazz.cast(latestVersionArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("LatestVersion", LATEST_VERSION_FIELD);
        map.put("LatestVersionArn", LATEST_VERSION_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorDefinitionResponse, T> g) {
        return obj -> g.apply((GetConnectorDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectorDefinitionResponse> {
        /**
         * The ARN of the definition.
         * 
         * @param arn
         *        The ARN of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time, in milliseconds since the epoch, when the definition was created.
         * 
         * @param creationTimestamp
         *        The time, in milliseconds since the epoch, when the definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(String creationTimestamp);

        /**
         * The ID of the definition.
         * 
         * @param id
         *        The ID of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The time, in milliseconds since the epoch, when the definition was last updated.
         * 
         * @param lastUpdatedTimestamp
         *        The time, in milliseconds since the epoch, when the definition was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(String lastUpdatedTimestamp);

        /**
         * The ID of the latest version associated with the definition.
         * 
         * @param latestVersion
         *        The ID of the latest version associated with the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(String latestVersion);

        /**
         * The ARN of the latest version associated with the definition.
         * 
         * @param latestVersionArn
         *        The ARN of the latest version associated with the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionArn(String latestVersionArn);

        /**
         * The name of the definition.
         * 
         * @param name
         *        The name of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Tag(s) attached to the resource arn.
         * 
         * @param tags
         *        Tag(s) attached to the resource arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String arn;

        private String creationTimestamp;

        private String id;

        private String lastUpdatedTimestamp;

        private String latestVersion;

        private String latestVersionArn;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorDefinitionResponse model) {
            super(model);
            arn(model.arn);
            creationTimestamp(model.creationTimestamp);
            id(model.id);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            latestVersion(model.latestVersion);
            latestVersionArn(model.latestVersionArn);
            name(model.name);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final String getLatestVersionArn() {
            return latestVersionArn;
        }

        public final void setLatestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
        }

        @Override
        public final Builder latestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetConnectorDefinitionResponse build() {
            return new GetConnectorDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
