/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupCertificateAuthorityResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetGroupCertificateAuthorityResponse.Builder, GetGroupCertificateAuthorityResponse> {
    private static final SdkField<String> GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupCertificateAuthorityArn")
            .getter(getter(GetGroupCertificateAuthorityResponse::groupCertificateAuthorityArn))
            .setter(setter(Builder::groupCertificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupCertificateAuthorityArn")
                    .build()).build();

    private static final SdkField<String> GROUP_CERTIFICATE_AUTHORITY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupCertificateAuthorityId")
            .getter(getter(GetGroupCertificateAuthorityResponse::groupCertificateAuthorityId))
            .setter(setter(Builder::groupCertificateAuthorityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupCertificateAuthorityId")
                    .build()).build();

    private static final SdkField<String> PEM_ENCODED_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PemEncodedCertificate").getter(getter(GetGroupCertificateAuthorityResponse::pemEncodedCertificate))
            .setter(setter(Builder::pemEncodedCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PemEncodedCertificate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD, GROUP_CERTIFICATE_AUTHORITY_ID_FIELD, PEM_ENCODED_CERTIFICATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupCertificateAuthorityArn;

    private final String groupCertificateAuthorityId;

    private final String pemEncodedCertificate;

    private GetGroupCertificateAuthorityResponse(BuilderImpl builder) {
        super(builder);
        this.groupCertificateAuthorityArn = builder.groupCertificateAuthorityArn;
        this.groupCertificateAuthorityId = builder.groupCertificateAuthorityId;
        this.pemEncodedCertificate = builder.pemEncodedCertificate;
    }

    /**
     * The ARN of the certificate authority for the group.
     * 
     * @return The ARN of the certificate authority for the group.
     */
    public final String groupCertificateAuthorityArn() {
        return groupCertificateAuthorityArn;
    }

    /**
     * The ID of the certificate authority for the group.
     * 
     * @return The ID of the certificate authority for the group.
     */
    public final String groupCertificateAuthorityId() {
        return groupCertificateAuthorityId;
    }

    /**
     * The PEM encoded certificate for the group.
     * 
     * @return The PEM encoded certificate for the group.
     */
    public final String pemEncodedCertificate() {
        return pemEncodedCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupCertificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(groupCertificateAuthorityId());
        hashCode = 31 * hashCode + Objects.hashCode(pemEncodedCertificate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupCertificateAuthorityResponse)) {
            return false;
        }
        GetGroupCertificateAuthorityResponse other = (GetGroupCertificateAuthorityResponse) obj;
        return Objects.equals(groupCertificateAuthorityArn(), other.groupCertificateAuthorityArn())
                && Objects.equals(groupCertificateAuthorityId(), other.groupCertificateAuthorityId())
                && Objects.equals(pemEncodedCertificate(), other.pemEncodedCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGroupCertificateAuthorityResponse")
                .add("GroupCertificateAuthorityArn", groupCertificateAuthorityArn())
                .add("GroupCertificateAuthorityId", groupCertificateAuthorityId())
                .add("PemEncodedCertificate", pemEncodedCertificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupCertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(groupCertificateAuthorityArn()));
        case "GroupCertificateAuthorityId":
            return Optional.ofNullable(clazz.cast(groupCertificateAuthorityId()));
        case "PemEncodedCertificate":
            return Optional.ofNullable(clazz.cast(pemEncodedCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupCertificateAuthorityArn", GROUP_CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("GroupCertificateAuthorityId", GROUP_CERTIFICATE_AUTHORITY_ID_FIELD);
        map.put("PemEncodedCertificate", PEM_ENCODED_CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGroupCertificateAuthorityResponse, T> g) {
        return obj -> g.apply((GetGroupCertificateAuthorityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGroupCertificateAuthorityResponse> {
        /**
         * The ARN of the certificate authority for the group.
         * 
         * @param groupCertificateAuthorityArn
         *        The ARN of the certificate authority for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorityArn(String groupCertificateAuthorityArn);

        /**
         * The ID of the certificate authority for the group.
         * 
         * @param groupCertificateAuthorityId
         *        The ID of the certificate authority for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorityId(String groupCertificateAuthorityId);

        /**
         * The PEM encoded certificate for the group.
         * 
         * @param pemEncodedCertificate
         *        The PEM encoded certificate for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pemEncodedCertificate(String pemEncodedCertificate);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String groupCertificateAuthorityArn;

        private String groupCertificateAuthorityId;

        private String pemEncodedCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupCertificateAuthorityResponse model) {
            super(model);
            groupCertificateAuthorityArn(model.groupCertificateAuthorityArn);
            groupCertificateAuthorityId(model.groupCertificateAuthorityId);
            pemEncodedCertificate(model.pemEncodedCertificate);
        }

        public final String getGroupCertificateAuthorityArn() {
            return groupCertificateAuthorityArn;
        }

        public final void setGroupCertificateAuthorityArn(String groupCertificateAuthorityArn) {
            this.groupCertificateAuthorityArn = groupCertificateAuthorityArn;
        }

        @Override
        public final Builder groupCertificateAuthorityArn(String groupCertificateAuthorityArn) {
            this.groupCertificateAuthorityArn = groupCertificateAuthorityArn;
            return this;
        }

        public final String getGroupCertificateAuthorityId() {
            return groupCertificateAuthorityId;
        }

        public final void setGroupCertificateAuthorityId(String groupCertificateAuthorityId) {
            this.groupCertificateAuthorityId = groupCertificateAuthorityId;
        }

        @Override
        public final Builder groupCertificateAuthorityId(String groupCertificateAuthorityId) {
            this.groupCertificateAuthorityId = groupCertificateAuthorityId;
            return this;
        }

        public final String getPemEncodedCertificate() {
            return pemEncodedCertificate;
        }

        public final void setPemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
        }

        @Override
        public final Builder pemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
            return this;
        }

        @Override
        public GetGroupCertificateAuthorityResponse build() {
            return new GetGroupCertificateAuthorityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
