/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Group owner related settings for local resources.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupOwnerSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupOwnerSetting.Builder, GroupOwnerSetting> {
    private static final SdkField<Boolean> AUTO_ADD_GROUP_OWNER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAddGroupOwner").getter(getter(GroupOwnerSetting::autoAddGroupOwner))
            .setter(setter(Builder::autoAddGroupOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAddGroupOwner").build()).build();

    private static final SdkField<String> GROUP_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupOwner").getter(getter(GroupOwnerSetting::groupOwner)).setter(setter(Builder::groupOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ADD_GROUP_OWNER_FIELD,
            GROUP_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean autoAddGroupOwner;

    private final String groupOwner;

    private GroupOwnerSetting(BuilderImpl builder) {
        this.autoAddGroupOwner = builder.autoAddGroupOwner;
        this.groupOwner = builder.groupOwner;
    }

    /**
     * If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the Lambda
     * process privileges. Thus the Lambda process will have the file access permissions of the added Linux group.
     * 
     * @return If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the
     *         Lambda process privileges. Thus the Lambda process will have the file access permissions of the added
     *         Linux group.
     */
    public final Boolean autoAddGroupOwner() {
        return autoAddGroupOwner;
    }

    /**
     * The name of the Linux OS group whose privileges will be added to the Lambda process. This field is optional.
     * 
     * @return The name of the Linux OS group whose privileges will be added to the Lambda process. This field is
     *         optional.
     */
    public final String groupOwner() {
        return groupOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoAddGroupOwner());
        hashCode = 31 * hashCode + Objects.hashCode(groupOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupOwnerSetting)) {
            return false;
        }
        GroupOwnerSetting other = (GroupOwnerSetting) obj;
        return Objects.equals(autoAddGroupOwner(), other.autoAddGroupOwner()) && Objects.equals(groupOwner(), other.groupOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupOwnerSetting").add("AutoAddGroupOwner", autoAddGroupOwner())
                .add("GroupOwner", groupOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoAddGroupOwner":
            return Optional.ofNullable(clazz.cast(autoAddGroupOwner()));
        case "GroupOwner":
            return Optional.ofNullable(clazz.cast(groupOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoAddGroupOwner", AUTO_ADD_GROUP_OWNER_FIELD);
        map.put("GroupOwner", GROUP_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupOwnerSetting, T> g) {
        return obj -> g.apply((GroupOwnerSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupOwnerSetting> {
        /**
         * If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the
         * Lambda process privileges. Thus the Lambda process will have the file access permissions of the added Linux
         * group.
         * 
         * @param autoAddGroupOwner
         *        If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to
         *        the Lambda process privileges. Thus the Lambda process will have the file access permissions of the
         *        added Linux group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAddGroupOwner(Boolean autoAddGroupOwner);

        /**
         * The name of the Linux OS group whose privileges will be added to the Lambda process. This field is optional.
         * 
         * @param groupOwner
         *        The name of the Linux OS group whose privileges will be added to the Lambda process. This field is
         *        optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOwner(String groupOwner);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoAddGroupOwner;

        private String groupOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupOwnerSetting model) {
            autoAddGroupOwner(model.autoAddGroupOwner);
            groupOwner(model.groupOwner);
        }

        public final Boolean getAutoAddGroupOwner() {
            return autoAddGroupOwner;
        }

        public final void setAutoAddGroupOwner(Boolean autoAddGroupOwner) {
            this.autoAddGroupOwner = autoAddGroupOwner;
        }

        @Override
        public final Builder autoAddGroupOwner(Boolean autoAddGroupOwner) {
            this.autoAddGroupOwner = autoAddGroupOwner;
            return this;
        }

        public final String getGroupOwner() {
            return groupOwner;
        }

        public final void setGroupOwner(String groupOwner) {
            this.groupOwner = groupOwner;
        }

        @Override
        public final Builder groupOwner(String groupOwner) {
            this.groupOwner = groupOwner;
            return this;
        }

        @Override
        public GroupOwnerSetting build() {
            return new GroupOwnerSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
