/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that define a secret resource, which references a secret from AWS Secrets Manager. AWS IoT Greengrass
 * stores a local, encrypted copy of the secret on the Greengrass core, where it can be securely accessed by connectors
 * and Lambda functions.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecretsManagerSecretResourceData implements SdkPojo, Serializable,
        ToCopyableBuilder<SecretsManagerSecretResourceData.Builder, SecretsManagerSecretResourceData> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(SecretsManagerSecretResourceData::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalStagingLabelsToDownload")
            .getter(getter(SecretsManagerSecretResourceData::additionalStagingLabelsToDownload))
            .setter(setter(Builder::additionalStagingLabelsToDownload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalStagingLabelsToDownload")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> additionalStagingLabelsToDownload;

    private SecretsManagerSecretResourceData(BuilderImpl builder) {
        this.arn = builder.arn;
        this.additionalStagingLabelsToDownload = builder.additionalStagingLabelsToDownload;
    }

    /**
     * The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version
     * (represented by the ''AWSCURRENT'' staging label) is included by default.
     * 
     * @return The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest
     *         version (represented by the ''AWSCURRENT'' staging label) is included by default.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalStagingLabelsToDownload
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalStagingLabelsToDownload() {
        return additionalStagingLabelsToDownload != null && !(additionalStagingLabelsToDownload instanceof SdkAutoConstructList);
    }

    /**
     * Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalStagingLabelsToDownload}
     * method.
     * </p>
     * 
     * @return Optional. The staging labels whose values you want to make available on the core, in addition to
     *         ''AWSCURRENT''.
     */
    public final List<String> additionalStagingLabelsToDownload() {
        return additionalStagingLabelsToDownload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalStagingLabelsToDownload() ? additionalStagingLabelsToDownload() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretsManagerSecretResourceData)) {
            return false;
        }
        SecretsManagerSecretResourceData other = (SecretsManagerSecretResourceData) obj;
        return Objects.equals(arn(), other.arn())
                && hasAdditionalStagingLabelsToDownload() == other.hasAdditionalStagingLabelsToDownload()
                && Objects.equals(additionalStagingLabelsToDownload(), other.additionalStagingLabelsToDownload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SecretsManagerSecretResourceData")
                .add("ARN", arn())
                .add("AdditionalStagingLabelsToDownload",
                        hasAdditionalStagingLabelsToDownload() ? additionalStagingLabelsToDownload() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AdditionalStagingLabelsToDownload":
            return Optional.ofNullable(clazz.cast(additionalStagingLabelsToDownload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ARN", ARN_FIELD);
        map.put("AdditionalStagingLabelsToDownload", ADDITIONAL_STAGING_LABELS_TO_DOWNLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecretsManagerSecretResourceData, T> g) {
        return obj -> g.apply((SecretsManagerSecretResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecretsManagerSecretResourceData> {
        /**
         * The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version
         * (represented by the ''AWSCURRENT'' staging label) is included by default.
         * 
         * @param arn
         *        The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest
         *        version (represented by the ''AWSCURRENT'' staging label) is included by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Optional. The staging labels whose values you want to make available on the core, in addition to
         * ''AWSCURRENT''.
         * 
         * @param additionalStagingLabelsToDownload
         *        Optional. The staging labels whose values you want to make available on the core, in addition to
         *        ''AWSCURRENT''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload);

        /**
         * Optional. The staging labels whose values you want to make available on the core, in addition to
         * ''AWSCURRENT''.
         * 
         * @param additionalStagingLabelsToDownload
         *        Optional. The staging labels whose values you want to make available on the core, in addition to
         *        ''AWSCURRENT''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalStagingLabelsToDownload(String... additionalStagingLabelsToDownload);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> additionalStagingLabelsToDownload = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecretsManagerSecretResourceData model) {
            arn(model.arn);
            additionalStagingLabelsToDownload(model.additionalStagingLabelsToDownload);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAdditionalStagingLabelsToDownload() {
            if (additionalStagingLabelsToDownload instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalStagingLabelsToDownload;
        }

        public final void setAdditionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload = ___listOf__stringCopier.copy(additionalStagingLabelsToDownload);
        }

        @Override
        public final Builder additionalStagingLabelsToDownload(Collection<String> additionalStagingLabelsToDownload) {
            this.additionalStagingLabelsToDownload = ___listOf__stringCopier.copy(additionalStagingLabelsToDownload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalStagingLabelsToDownload(String... additionalStagingLabelsToDownload) {
            additionalStagingLabelsToDownload(Arrays.asList(additionalStagingLabelsToDownload));
            return this;
        }

        @Override
        public SecretsManagerSecretResourceData build() {
            return new SecretsManagerSecretResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
