/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetDeploymentsResponse extends GreengrassResponse implements
        ToCopyableBuilder<ResetDeploymentsResponse.Builder, ResetDeploymentsResponse> {
    private static final SdkField<String> DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetDeploymentsResponse::deploymentArn)).setter(setter(Builder::deploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentArn").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetDeploymentsResponse::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ARN_FIELD,
            DEPLOYMENT_ID_FIELD));

    private final String deploymentArn;

    private final String deploymentId;

    private ResetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentArn = builder.deploymentArn;
        this.deploymentId = builder.deploymentId;
    }

    /**
     * The ARN of the deployment.
     * 
     * @return The ARN of the deployment.
     */
    public String deploymentArn() {
        return deploymentArn;
    }

    /**
     * The ID of the deployment.
     * 
     * @return The ID of the deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDeploymentsResponse)) {
            return false;
        }
        ResetDeploymentsResponse other = (ResetDeploymentsResponse) obj;
        return Objects.equals(deploymentArn(), other.deploymentArn()) && Objects.equals(deploymentId(), other.deploymentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResetDeploymentsResponse").add("DeploymentArn", deploymentArn())
                .add("DeploymentId", deploymentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentArn":
            return Optional.ofNullable(clazz.cast(deploymentArn()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetDeploymentsResponse, T> g) {
        return obj -> g.apply((ResetDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResetDeploymentsResponse> {
        /**
         * The ARN of the deployment.
         * 
         * @param deploymentArn
         *        The ARN of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentArn(String deploymentArn);

        /**
         * The ID of the deployment.
         * 
         * @param deploymentId
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String deploymentArn;

        private String deploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDeploymentsResponse model) {
            super(model);
            deploymentArn(model.deploymentArn);
            deploymentId(model.deploymentId);
        }

        public final String getDeploymentArn() {
            return deploymentArn;
        }

        @Override
        public final Builder deploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
            return this;
        }

        public final void setDeploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public ResetDeploymentsResponse build() {
            return new ResetDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
