/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Device::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Boolean> SYNC_SHADOW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Device::syncShadow)).setter(setter(Builder::syncShadow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncShadow").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            ID_FIELD, SYNC_SHADOW_FIELD, THING_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String id;

    private final Boolean syncShadow;

    private final String thingArn;

    private Device(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.id = builder.id;
        this.syncShadow = builder.syncShadow;
        this.thingArn = builder.thingArn;
    }

    /**
     * The ARN of the certificate associated with the device.
     * 
     * @return The ARN of the certificate associated with the device.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * A descriptive or arbitrary ID for the device. This value must be unique within the device definition version. Max
     * length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     * 
     * @return A descriptive or arbitrary ID for the device. This value must be unique within the device definition
     *         version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     */
    public String id() {
        return id;
    }

    /**
     * If true, the device's local shadow will be automatically synced with the cloud.
     * 
     * @return If true, the device's local shadow will be automatically synced with the cloud.
     */
    public Boolean syncShadow() {
        return syncShadow;
    }

    /**
     * The thing ARN of the device.
     * 
     * @return The thing ARN of the device.
     */
    public String thingArn() {
        return thingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(syncShadow());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(id(), other.id())
                && Objects.equals(syncShadow(), other.syncShadow()) && Objects.equals(thingArn(), other.thingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Device").add("CertificateArn", certificateArn()).add("Id", id()).add("SyncShadow", syncShadow())
                .add("ThingArn", thingArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "SyncShadow":
            return Optional.ofNullable(clazz.cast(syncShadow()));
        case "ThingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * The ARN of the certificate associated with the device.
         * 
         * @param certificateArn
         *        The ARN of the certificate associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * A descriptive or arbitrary ID for the device. This value must be unique within the device definition version.
         * Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * 
         * @param id
         *        A descriptive or arbitrary ID for the device. This value must be unique within the device definition
         *        version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * If true, the device's local shadow will be automatically synced with the cloud.
         * 
         * @param syncShadow
         *        If true, the device's local shadow will be automatically synced with the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncShadow(Boolean syncShadow);

        /**
         * The thing ARN of the device.
         * 
         * @param thingArn
         *        The thing ARN of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String id;

        private Boolean syncShadow;

        private String thingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            certificateArn(model.certificateArn);
            id(model.id);
            syncShadow(model.syncShadow);
            thingArn(model.thingArn);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getSyncShadow() {
            return syncShadow;
        }

        @Override
        public final Builder syncShadow(Boolean syncShadow) {
            this.syncShadow = syncShadow;
            return this;
        }

        public final void setSyncShadow(Boolean syncShadow) {
            this.syncShadow = syncShadow;
        }

        public final String getThingArn() {
            return thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
