/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a component dependency for a Lambda function component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentDependencyRequirement implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentDependencyRequirement.Builder, ComponentDependencyRequirement> {
    private static final SdkField<String> VERSION_REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionRequirement").getter(getter(ComponentDependencyRequirement::versionRequirement))
            .setter(setter(Builder::versionRequirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRequirement").build())
            .build();

    private static final SdkField<String> DEPENDENCY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dependencyType").getter(getter(ComponentDependencyRequirement::dependencyTypeAsString))
            .setter(setter(Builder::dependencyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_REQUIREMENT_FIELD,
            DEPENDENCY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String versionRequirement;

    private final String dependencyType;

    private ComponentDependencyRequirement(BuilderImpl builder) {
        this.versionRequirement = builder.versionRequirement;
        this.dependencyType = builder.dependencyType;
    }

    /**
     * <p>
     * The component version requirement for the component dependency.
     * </p>
     * <p>
     * AWS IoT Greengrass V2 uses semantic version constraints. For more information, see <a
     * href="https://semver.org/">Semantic Versioning</a>.
     * </p>
     * 
     * @return The component version requirement for the component dependency.</p>
     *         <p>
     *         AWS IoT Greengrass V2 uses semantic version constraints. For more information, see <a
     *         href="https://semver.org/">Semantic Versioning</a>.
     */
    public final String versionRequirement() {
        return versionRequirement;
    }

    /**
     * <p>
     * The type of this dependency. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SOFT</code> – The component doesn't restart if the dependency changes state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HARD</code> – The component restarts if the dependency changes state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>HARD</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dependencyType}
     * will return {@link ComponentDependencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dependencyTypeAsString}.
     * </p>
     * 
     * @return The type of this dependency. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SOFT</code> – The component doesn't restart if the dependency changes state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HARD</code> – The component restarts if the dependency changes state.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>HARD</code>
     * @see ComponentDependencyType
     */
    public final ComponentDependencyType dependencyType() {
        return ComponentDependencyType.fromValue(dependencyType);
    }

    /**
     * <p>
     * The type of this dependency. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SOFT</code> – The component doesn't restart if the dependency changes state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HARD</code> – The component restarts if the dependency changes state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>HARD</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dependencyType}
     * will return {@link ComponentDependencyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dependencyTypeAsString}.
     * </p>
     * 
     * @return The type of this dependency. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SOFT</code> – The component doesn't restart if the dependency changes state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HARD</code> – The component restarts if the dependency changes state.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>HARD</code>
     * @see ComponentDependencyType
     */
    public final String dependencyTypeAsString() {
        return dependencyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionRequirement());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentDependencyRequirement)) {
            return false;
        }
        ComponentDependencyRequirement other = (ComponentDependencyRequirement) obj;
        return Objects.equals(versionRequirement(), other.versionRequirement())
                && Objects.equals(dependencyTypeAsString(), other.dependencyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentDependencyRequirement").add("VersionRequirement", versionRequirement())
                .add("DependencyType", dependencyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionRequirement":
            return Optional.ofNullable(clazz.cast(versionRequirement()));
        case "dependencyType":
            return Optional.ofNullable(clazz.cast(dependencyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentDependencyRequirement, T> g) {
        return obj -> g.apply((ComponentDependencyRequirement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentDependencyRequirement> {
        /**
         * <p>
         * The component version requirement for the component dependency.
         * </p>
         * <p>
         * AWS IoT Greengrass V2 uses semantic version constraints. For more information, see <a
         * href="https://semver.org/">Semantic Versioning</a>.
         * </p>
         * 
         * @param versionRequirement
         *        The component version requirement for the component dependency.</p>
         *        <p>
         *        AWS IoT Greengrass V2 uses semantic version constraints. For more information, see <a
         *        href="https://semver.org/">Semantic Versioning</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRequirement(String versionRequirement);

        /**
         * <p>
         * The type of this dependency. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SOFT</code> – The component doesn't restart if the dependency changes state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HARD</code> – The component restarts if the dependency changes state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>HARD</code>
         * </p>
         * 
         * @param dependencyType
         *        The type of this dependency. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SOFT</code> – The component doesn't restart if the dependency changes state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HARD</code> – The component restarts if the dependency changes state.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>HARD</code>
         * @see ComponentDependencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentDependencyType
         */
        Builder dependencyType(String dependencyType);

        /**
         * <p>
         * The type of this dependency. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SOFT</code> – The component doesn't restart if the dependency changes state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HARD</code> – The component restarts if the dependency changes state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>HARD</code>
         * </p>
         * 
         * @param dependencyType
         *        The type of this dependency. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SOFT</code> – The component doesn't restart if the dependency changes state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HARD</code> – The component restarts if the dependency changes state.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>HARD</code>
         * @see ComponentDependencyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComponentDependencyType
         */
        Builder dependencyType(ComponentDependencyType dependencyType);
    }

    static final class BuilderImpl implements Builder {
        private String versionRequirement;

        private String dependencyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentDependencyRequirement model) {
            versionRequirement(model.versionRequirement);
            dependencyType(model.dependencyType);
        }

        public final String getVersionRequirement() {
            return versionRequirement;
        }

        @Override
        public final Builder versionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
            return this;
        }

        public final void setVersionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
        }

        public final String getDependencyType() {
            return dependencyType;
        }

        @Override
        public final Builder dependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
            return this;
        }

        @Override
        public final Builder dependencyType(ComponentDependencyType dependencyType) {
            this.dependencyType(dependencyType == null ? null : dependencyType.toString());
            return this;
        }

        public final void setDependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
        }

        @Override
        public ComponentDependencyRequirement build() {
            return new ComponentDependencyRequirement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
